/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.rest;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.rest.RestConnection;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RestConnectionEditor
extends MetadataEditor<RestConnection> {
    private static final Class<?> PKG = RestConnectionEditor.class;
    private Text wName;
    private TextVar wBaseUrl;
    private TextVar wTestUrl;
    private ComboVar wAuthType;
    private static String[] authTypes = new String[]{"No Auth", "API Key", "Basic", "Bearer", "Certificate"};
    private Composite wAuthComp;
    private PasswordTextVar wBearerValue;
    private TextVar wUsername;
    private PasswordTextVar wPassword;
    private TextVar wAuthorizationName;
    private TextVar wAuthorizationPrefix;
    private PasswordTextVar wAuthorizationValue;
    private TextVar wTrustStorePassword;
    private TextVar wTrustStoreFile;
    private Button wbTrustStoreFile;
    private Button wIgnoreSsl;
    private TextVar wKeyStoreFile;
    private Button wbKeyStoreFile;
    private PasswordTextVar wKeyStorePassword;
    private ComboVar wKeyStoreType;
    private PasswordTextVar wKeyPassword;
    private TextVar wCertificateAlias;
    private PropsUi props = PropsUi.getInstance();
    private int middle = this.props.getMiddlePct();
    private int margin;
    private IVariables variables;
    Control lastControl;

    public RestConnectionEditor(HopGui hopGui, MetadataManager<RestConnection> manager, RestConnection restConnection) {
        super(hopGui, manager, (IHopMetadata)restConnection);
        RestConnectionEditor restConnectionEditor = this;
        this.margin = restConnectionEditor.props.getMargin();
    }

    public void createControl(Composite composite) {
        this.variables = this.hopGui.getVariables();
        Label wlName = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.Name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, this.margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, -this.margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(this.middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        this.lastControl = this.wName;
        Group gAuth = new Group(composite, 16);
        gAuth.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.AuthGroup.Label", (String[])new String[0]));
        FormLayout gAuthLayout = new FormLayout();
        gAuthLayout.marginWidth = 3;
        gAuthLayout.marginHeight = 3;
        gAuth.setLayout((Layout)gAuthLayout);
        PropsUi.setLook((Widget)gAuth);
        Label wlAuthType = new Label((Composite)gAuth, 131072);
        PropsUi.setLook((Widget)wlAuthType);
        wlAuthType.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.AuthType", (String[])new String[0]));
        FormData fdlAuthType = new FormData();
        fdlAuthType.top = new FormAttachment(0, this.margin);
        fdlAuthType.left = new FormAttachment(0, 0);
        fdlAuthType.right = new FormAttachment(this.middle, -this.margin);
        wlAuthType.setLayoutData((Object)fdlAuthType);
        this.wAuthType = new ComboVar(this.variables, (Composite)gAuth, 2056);
        PropsUi.setLook((Widget)this.wAuthType);
        FormData fdAuthType = new FormData();
        fdAuthType.top = new FormAttachment((Control)wlAuthType, 0, 0x1000000);
        fdAuthType.left = new FormAttachment(this.middle, 0);
        fdAuthType.right = new FormAttachment(95, 0);
        this.wAuthType.setLayoutData((Object)fdAuthType);
        this.wAuthType.setItems(authTypes);
        this.wAuthType.addListener(13, e -> {
            if (this.wAuthType.getText().equals("No Auth")) {
                this.addNoAuthFields();
            } else if (this.wAuthType.getText().equals("API Key")) {
                this.addApiKeyFields();
            } else if (this.wAuthType.getText().equals("Basic")) {
                this.addBasicAuthFields();
            } else if (this.wAuthType.getText().equals("Bearer")) {
                this.addBearerFields();
            } else if (this.wAuthType.getText().equals("Certificate")) {
                this.addCertificateFields();
            }
        });
        ScrolledComposite wsAuthComp = new ScrolledComposite((Composite)gAuth, 768);
        PropsUi.setLook((Widget)wsAuthComp);
        FormData fdAuthSComp = new FormData();
        fdAuthSComp.top = new FormAttachment((Control)this.wAuthType, this.margin);
        fdAuthSComp.left = new FormAttachment(0, 0);
        fdAuthSComp.right = new FormAttachment(95, 0);
        fdAuthSComp.bottom = new FormAttachment(95, 0);
        wsAuthComp.setLayoutData((Object)fdAuthSComp);
        this.wAuthComp = new Composite((Composite)wsAuthComp, 8);
        PropsUi.setLook((Widget)this.wAuthComp);
        this.wAuthComp.setLayout((Layout)new FormLayout());
        FormData fdAuthComp = new FormData();
        fdAuthComp.left = new FormAttachment(0, 0);
        fdAuthComp.right = new FormAttachment(0, 0);
        fdAuthComp.top = new FormAttachment(95, 0);
        fdAuthComp.bottom = new FormAttachment(95, 0);
        this.wAuthComp.setLayoutData((Object)fdAuthComp);
        this.wAuthComp.pack();
        wsAuthComp.setContent((Control)this.wAuthComp);
        this.wAuthType.select(0);
        this.wAuthComp.layout();
        FormData fdAuth = new FormData();
        fdAuth.left = new FormAttachment(0, 0);
        fdAuth.top = new FormAttachment((Control)this.wName, this.margin);
        fdAuth.right = new FormAttachment(100, 0);
        gAuth.setLayoutData((Object)fdAuth);
        Group gUrl = new Group(composite, 16);
        gUrl.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.UrlGroup.Label", (String[])new String[0]));
        FormLayout gUrlLayout = new FormLayout();
        gUrlLayout.marginWidth = 3;
        gUrlLayout.marginHeight = 3;
        gUrl.setLayout((Layout)gUrlLayout);
        PropsUi.setLook((Widget)gUrl);
        Label wlBaseUrl = new Label((Composite)gUrl, 131072);
        PropsUi.setLook((Widget)wlBaseUrl);
        wlBaseUrl.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.BaseUrl", (String[])new String[0]));
        FormData fdlBaseUrl = new FormData();
        fdlBaseUrl.top = new FormAttachment(0, this.margin);
        fdlBaseUrl.left = new FormAttachment(0, 0);
        fdlBaseUrl.right = new FormAttachment(this.middle, -this.margin);
        wlBaseUrl.setLayoutData((Object)fdlBaseUrl);
        this.wBaseUrl = new TextVar(this.variables, (Composite)gUrl, 18436);
        PropsUi.setLook((Widget)this.wBaseUrl);
        FormData fdBaseUrl = new FormData();
        fdBaseUrl.top = new FormAttachment(0, 0);
        fdBaseUrl.left = new FormAttachment(this.middle, 0);
        fdBaseUrl.right = new FormAttachment(95, 0);
        this.wBaseUrl.setLayoutData((Object)fdBaseUrl);
        this.lastControl = this.wBaseUrl;
        Label wlTestUrl = new Label((Composite)gUrl, 131072);
        PropsUi.setLook((Widget)wlTestUrl);
        wlTestUrl.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.TestUrl", (String[])new String[0]));
        FormData fdlTestUrl = new FormData();
        fdlTestUrl.top = new FormAttachment(this.lastControl, this.margin);
        fdlTestUrl.left = new FormAttachment(0, 0);
        fdlTestUrl.right = new FormAttachment(this.middle, -this.margin);
        wlTestUrl.setLayoutData((Object)fdlTestUrl);
        this.wTestUrl = new TextVar(this.variables, (Composite)gUrl, 18436);
        PropsUi.setLook((Widget)this.wTestUrl);
        FormData fdTestUrl = new FormData();
        fdTestUrl.top = new FormAttachment((Control)wlTestUrl, 0, 0x1000000);
        fdTestUrl.left = new FormAttachment(this.middle, 0);
        fdTestUrl.right = new FormAttachment(95, 0);
        this.wTestUrl.setLayoutData((Object)fdTestUrl);
        this.lastControl = this.wTestUrl;
        FormData fdUrl = new FormData();
        fdUrl.top = new FormAttachment((Control)gAuth, this.margin);
        fdUrl.left = new FormAttachment(0, 0);
        fdUrl.right = new FormAttachment(95, 0);
        gUrl.setLayoutData((Object)fdUrl);
        Group gSSLTrustStore = new Group(composite, 16);
        gSSLTrustStore.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.SSLGroup.Label", (String[])new String[0]));
        FormLayout gSSLTrustStoreLayout = new FormLayout();
        gSSLTrustStoreLayout.marginWidth = 3;
        gSSLTrustStoreLayout.marginHeight = 3;
        gSSLTrustStore.setLayout((Layout)gSSLTrustStoreLayout);
        PropsUi.setLook((Widget)gSSLTrustStore);
        Label wlTrustStoreFile = new Label((Composite)gSSLTrustStore, 131072);
        wlTrustStoreFile.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.TrustStoreFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTrustStoreFile);
        FormData fdlTrustStoreFile = new FormData();
        fdlTrustStoreFile.left = new FormAttachment(0, 0);
        fdlTrustStoreFile.top = new FormAttachment(0, this.margin);
        fdlTrustStoreFile.right = new FormAttachment(this.middle, -this.margin);
        wlTrustStoreFile.setLayoutData((Object)fdlTrustStoreFile);
        this.wbTrustStoreFile = new Button((Composite)gSSLTrustStore, 0x1000008);
        PropsUi.setLook((Widget)this.wbTrustStoreFile);
        this.wbTrustStoreFile.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTrustStoreFile = new FormData();
        fdbTrustStoreFile.right = new FormAttachment(100, 0);
        fdbTrustStoreFile.top = new FormAttachment(0, 0);
        this.wbTrustStoreFile.setLayoutData((Object)fdbTrustStoreFile);
        this.wbTrustStoreFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.hopGui.getShell(), (TextVar)this.wTrustStoreFile, (IVariables)this.variables, (String[])new String[]{"*.)"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.wTrustStoreFile = new TextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wTrustStoreFile);
        FormData fdTrustStoreFile = new FormData();
        fdTrustStoreFile.left = new FormAttachment(this.middle, 0);
        fdTrustStoreFile.top = new FormAttachment(0, this.margin);
        fdTrustStoreFile.right = new FormAttachment((Control)this.wbTrustStoreFile, -this.margin);
        this.wTrustStoreFile.setLayoutData((Object)fdTrustStoreFile);
        Label wlTrustStorePassword = new Label((Composite)gSSLTrustStore, 131072);
        wlTrustStorePassword.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.TrustStorePassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTrustStorePassword);
        FormData fdlTrustStorePassword = new FormData();
        fdlTrustStorePassword.left = new FormAttachment(0, 0);
        fdlTrustStorePassword.top = new FormAttachment((Control)this.wbTrustStoreFile, this.margin);
        fdlTrustStorePassword.right = new FormAttachment(this.middle, -this.margin);
        wlTrustStorePassword.setLayoutData((Object)fdlTrustStorePassword);
        this.wTrustStorePassword = new PasswordTextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wTrustStorePassword);
        FormData fdTrustStorePassword = new FormData();
        fdTrustStorePassword.left = new FormAttachment(this.middle, 0);
        fdTrustStorePassword.top = new FormAttachment((Control)this.wbTrustStoreFile, this.margin);
        fdTrustStorePassword.right = new FormAttachment(100, 0);
        this.wTrustStorePassword.setLayoutData((Object)fdTrustStorePassword);
        Label wlIgnoreSsl = new Label((Composite)gSSLTrustStore, 131072);
        wlIgnoreSsl.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.IgnoreSsl.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreSsl);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.top = new FormAttachment((Control)this.wTrustStorePassword, this.margin);
        fdLabel.right = new FormAttachment(this.middle, -this.margin);
        wlIgnoreSsl.setLayoutData((Object)fdLabel);
        this.wIgnoreSsl = new Button((Composite)gSSLTrustStore, 32);
        PropsUi.setLook((Widget)this.wIgnoreSsl);
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(this.middle, 0);
        fdButton.top = new FormAttachment((Control)wlIgnoreSsl, 0, 0x1000000);
        fdButton.right = new FormAttachment(100, 0);
        this.wIgnoreSsl.setLayoutData((Object)fdButton);
        this.wIgnoreSsl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestConnectionEditor.this.setChanged();
                RestConnectionEditor.this.activateTrustoreFields();
            }
        });
        Label wlClientCert = new Label((Composite)gSSLTrustStore, 258);
        PropsUi.setLook((Widget)wlClientCert);
        FormData fdlClientCert = new FormData();
        fdlClientCert.left = new FormAttachment(0, 0);
        fdlClientCert.right = new FormAttachment(100, 0);
        fdlClientCert.top = new FormAttachment((Control)this.wIgnoreSsl, this.margin * 2);
        wlClientCert.setLayoutData((Object)fdlClientCert);
        Label wlClientCertLabel = new Label((Composite)gSSLTrustStore, 16384);
        wlClientCertLabel.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.ClientCertificate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlClientCertLabel);
        FormData fdlClientCertLabel = new FormData();
        fdlClientCertLabel.left = new FormAttachment(0, 0);
        fdlClientCertLabel.top = new FormAttachment((Control)wlClientCert, this.margin);
        wlClientCertLabel.setLayoutData((Object)fdlClientCertLabel);
        Label wlKeyStoreFile = new Label((Composite)gSSLTrustStore, 131072);
        wlKeyStoreFile.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.KeyStoreFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyStoreFile);
        FormData fdlKeyStoreFile = new FormData();
        fdlKeyStoreFile.left = new FormAttachment(0, 0);
        fdlKeyStoreFile.top = new FormAttachment((Control)wlClientCertLabel, this.margin);
        fdlKeyStoreFile.right = new FormAttachment(this.middle, -this.margin);
        wlKeyStoreFile.setLayoutData((Object)fdlKeyStoreFile);
        this.wbKeyStoreFile = new Button((Composite)gSSLTrustStore, 0x1000008);
        PropsUi.setLook((Widget)this.wbKeyStoreFile);
        this.wbKeyStoreFile.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbKeyStoreFile = new FormData();
        fdbKeyStoreFile.right = new FormAttachment(100, 0);
        fdbKeyStoreFile.top = new FormAttachment((Control)wlClientCertLabel, this.margin);
        this.wbKeyStoreFile.setLayoutData((Object)fdbKeyStoreFile);
        this.wbKeyStoreFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.hopGui.getShell(), (TextVar)this.wKeyStoreFile, (IVariables)this.variables, (String[])new String[]{"*.p12;*.pfx;*.jks", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"RestConnectionEditor.CertificateFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.wKeyStoreFile = new TextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wKeyStoreFile);
        FormData fdKeyStoreFile = new FormData();
        fdKeyStoreFile.left = new FormAttachment(this.middle, 0);
        fdKeyStoreFile.top = new FormAttachment((Control)wlClientCertLabel, this.margin);
        fdKeyStoreFile.right = new FormAttachment((Control)this.wbKeyStoreFile, -this.margin);
        this.wKeyStoreFile.setLayoutData((Object)fdKeyStoreFile);
        Label wlKeyStorePassword = new Label((Composite)gSSLTrustStore, 131072);
        wlKeyStorePassword.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.KeyStorePassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyStorePassword);
        FormData fdlKeyStorePassword = new FormData();
        fdlKeyStorePassword.left = new FormAttachment(0, 0);
        fdlKeyStorePassword.top = new FormAttachment((Control)this.wbKeyStoreFile, this.margin);
        fdlKeyStorePassword.right = new FormAttachment(this.middle, -this.margin);
        wlKeyStorePassword.setLayoutData((Object)fdlKeyStorePassword);
        this.wKeyStorePassword = new PasswordTextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wKeyStorePassword);
        FormData fdKeyStorePassword = new FormData();
        fdKeyStorePassword.left = new FormAttachment(this.middle, 0);
        fdKeyStorePassword.top = new FormAttachment((Control)this.wbKeyStoreFile, this.margin);
        fdKeyStorePassword.right = new FormAttachment(100, 0);
        this.wKeyStorePassword.setLayoutData((Object)fdKeyStorePassword);
        Label wlKeyStoreType = new Label((Composite)gSSLTrustStore, 131072);
        wlKeyStoreType.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.KeyStoreType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyStoreType);
        FormData fdlKeyStoreType = new FormData();
        fdlKeyStoreType.left = new FormAttachment(0, 0);
        fdlKeyStoreType.top = new FormAttachment((Control)this.wKeyStorePassword, this.margin);
        fdlKeyStoreType.right = new FormAttachment(this.middle, -this.margin);
        wlKeyStoreType.setLayoutData((Object)fdlKeyStoreType);
        this.wKeyStoreType = new ComboVar(this.variables, (Composite)gSSLTrustStore, 2056);
        PropsUi.setLook((Widget)this.wKeyStoreType);
        this.wKeyStoreType.setItems(new String[]{"PKCS12", "JKS"});
        FormData fdKeyStoreType = new FormData();
        fdKeyStoreType.left = new FormAttachment(this.middle, 0);
        fdKeyStoreType.top = new FormAttachment((Control)wlKeyStoreType, 0, 0x1000000);
        fdKeyStoreType.right = new FormAttachment(100, 0);
        this.wKeyStoreType.setLayoutData((Object)fdKeyStoreType);
        Label wlKeyPassword = new Label((Composite)gSSLTrustStore, 131072);
        wlKeyPassword.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.KeyPassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyPassword);
        FormData fdlKeyPassword = new FormData();
        fdlKeyPassword.left = new FormAttachment(0, 0);
        fdlKeyPassword.top = new FormAttachment((Control)this.wKeyStoreType, this.margin);
        fdlKeyPassword.right = new FormAttachment(this.middle, -this.margin);
        wlKeyPassword.setLayoutData((Object)fdlKeyPassword);
        this.wKeyPassword = new PasswordTextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wKeyPassword);
        this.wKeyPassword.setToolTipText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.KeyPassword.Tooltip", (String[])new String[0]));
        FormData fdKeyPassword = new FormData();
        fdKeyPassword.left = new FormAttachment(this.middle, 0);
        fdKeyPassword.top = new FormAttachment((Control)this.wKeyStoreType, this.margin);
        fdKeyPassword.right = new FormAttachment(100, 0);
        this.wKeyPassword.setLayoutData((Object)fdKeyPassword);
        Label wlCertificateAlias = new Label((Composite)gSSLTrustStore, 131072);
        wlCertificateAlias.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.CertificateAlias.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCertificateAlias);
        FormData fdlCertificateAlias = new FormData();
        fdlCertificateAlias.left = new FormAttachment(0, 0);
        fdlCertificateAlias.top = new FormAttachment((Control)this.wKeyPassword, this.margin);
        fdlCertificateAlias.right = new FormAttachment(this.middle, -this.margin);
        wlCertificateAlias.setLayoutData((Object)fdlCertificateAlias);
        this.wCertificateAlias = new TextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wCertificateAlias);
        this.wCertificateAlias.setToolTipText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.CertificateAlias.Tooltip", (String[])new String[0]));
        FormData fdCertificateAlias = new FormData();
        fdCertificateAlias.left = new FormAttachment(this.middle, 0);
        fdCertificateAlias.top = new FormAttachment((Control)this.wKeyPassword, this.margin);
        fdCertificateAlias.right = new FormAttachment(100, 0);
        this.wCertificateAlias.setLayoutData((Object)fdCertificateAlias);
        FormData fdSSLTrustStore = new FormData();
        fdSSLTrustStore.left = new FormAttachment(0, 0);
        fdSSLTrustStore.right = new FormAttachment(100, 0);
        fdSSLTrustStore.top = new FormAttachment((Control)gUrl, this.margin);
        gSSLTrustStore.setLayoutData((Object)fdSSLTrustStore);
        this.setWidgetsContent();
        wsAuthComp.setExpandHorizontal(true);
        wsAuthComp.setExpandVertical(true);
        Rectangle authCompBounds = this.wAuthComp.getBounds();
        wsAuthComp.setMinSize(authCompBounds.width, authCompBounds.height);
        Control[] controls = new Control[]{this.wName, this.wBaseUrl, this.wTestUrl, this.wAuthComp, this.wAuthType, this.wTrustStoreFile, this.wTrustStorePassword, this.wKeyStoreFile, this.wKeyStorePassword, this.wKeyStoreType, this.wKeyPassword, this.wCertificateAlias};
        this.enableControls(controls);
    }

    private void enableControls(Control[] controls) {
        for (Control control : controls) {
            if (control == null || control.isDisposed()) continue;
            control.addListener(24, e -> this.setChanged());
            control.addListener(13, e -> this.setChanged());
        }
    }

    private void clearAuthComp() {
        for (Control child : this.wAuthComp.getChildren()) {
            child.dispose();
        }
    }

    private void addNoAuthFields() {
        this.clearAuthComp();
        this.wAuthComp.pack();
        this.wAuthComp.redraw();
    }

    private void addBasicAuthFields() {
        this.clearAuthComp();
        Label wlUsername = new Label(this.wAuthComp, 131072);
        PropsUi.setLook((Widget)wlUsername);
        wlUsername.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.Basic.Username", (String[])new String[0]));
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment(0, this.margin);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(this.middle, -this.margin);
        wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar(this.variables, this.wAuthComp, 18436);
        PropsUi.setLook((Widget)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)wlUsername, 0, 0x1000000);
        fdUsername.left = new FormAttachment(this.middle, 0);
        fdUsername.right = new FormAttachment(95, this.margin);
        this.wUsername.setLayoutData((Object)fdUsername);
        this.lastControl = wlUsername;
        Label wlPassword = new Label(this.wAuthComp, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.Basic.Password", (String[])new String[0]));
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment(this.lastControl, this.margin);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(this.middle, -this.margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, this.wAuthComp, 18436);
        PropsUi.setLook((Widget)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)wlPassword, 0, 0x1000000);
        fdPassword.left = new FormAttachment(this.middle, 0);
        fdPassword.right = new FormAttachment(95, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        this.wAuthComp.pack();
        this.wAuthComp.redraw();
        Control[] controls = new Control[]{this.wUsername, this.wPassword};
        this.enableControls(controls);
    }

    private void addBearerFields() {
        this.clearAuthComp();
        Label wlBearer = new Label(this.wAuthComp, 131072);
        PropsUi.setLook((Widget)wlBearer);
        wlBearer.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.Bearer.Token", (String[])new String[0]));
        FormData fdlBearer = new FormData();
        fdlBearer.top = new FormAttachment(0, this.margin);
        fdlBearer.left = new FormAttachment(0, 0);
        fdlBearer.right = new FormAttachment(this.middle, -this.margin);
        wlBearer.setLayoutData((Object)fdlBearer);
        this.wBearerValue = new PasswordTextVar(this.variables, this.wAuthComp, 18436);
        PropsUi.setLook((Widget)this.wBearerValue);
        FormData fdBearer = new FormData();
        fdBearer.top = new FormAttachment((Control)wlBearer, 0, 0x1000000);
        fdBearer.left = new FormAttachment(this.middle, 0);
        fdBearer.right = new FormAttachment(95, 0);
        this.wBearerValue.setLayoutData((Object)fdBearer);
        this.wAuthComp.pack();
        Control[] controls = new Control[]{this.wBearerValue};
        this.enableControls(controls);
    }

    private void addApiKeyFields() {
        this.clearAuthComp();
        Label wlAuthorizationName = new Label(this.wAuthComp, 131072);
        PropsUi.setLook((Widget)wlAuthorizationName);
        wlAuthorizationName.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.API.AuthorizationName", (String[])new String[0]));
        FormData fdlAuthorizationName = new FormData();
        fdlAuthorizationName.top = new FormAttachment(0, this.margin);
        fdlAuthorizationName.left = new FormAttachment(0, 0);
        fdlAuthorizationName.right = new FormAttachment(this.middle, -this.margin);
        wlAuthorizationName.setLayoutData((Object)fdlAuthorizationName);
        this.wAuthorizationName = new TextVar(this.variables, this.wAuthComp, 18436);
        PropsUi.setLook((Widget)this.wAuthorizationName);
        FormData fdAuthorizationName = new FormData();
        fdAuthorizationName.top = new FormAttachment((Control)wlAuthorizationName, 0, 0x1000000);
        fdAuthorizationName.left = new FormAttachment(this.middle, 0);
        fdAuthorizationName.right = new FormAttachment(95, 0);
        this.wAuthorizationName.setLayoutData((Object)fdAuthorizationName);
        this.lastControl = this.wAuthorizationName;
        Label wlAuthorizationPrefix = new Label(this.wAuthComp, 131072);
        PropsUi.setLook((Widget)wlAuthorizationPrefix);
        wlAuthorizationPrefix.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.API.AuthorizationPrefix", (String[])new String[0]));
        FormData fdlAuthorizationPrefix = new FormData();
        fdlAuthorizationPrefix.top = new FormAttachment(this.lastControl, this.margin);
        fdlAuthorizationPrefix.left = new FormAttachment(0, 0);
        fdlAuthorizationPrefix.right = new FormAttachment(this.middle, -this.margin);
        wlAuthorizationPrefix.setLayoutData((Object)fdlAuthorizationPrefix);
        this.wAuthorizationPrefix = new TextVar(this.variables, this.wAuthComp, 18436);
        PropsUi.setLook((Widget)this.wAuthorizationPrefix);
        FormData fdAuthorizationPrefix = new FormData();
        fdAuthorizationPrefix.top = new FormAttachment((Control)wlAuthorizationPrefix, 0, 0x1000000);
        fdAuthorizationPrefix.left = new FormAttachment(this.middle, 0);
        fdAuthorizationPrefix.right = new FormAttachment(95, 0);
        this.wAuthorizationPrefix.setLayoutData((Object)fdAuthorizationPrefix);
        this.lastControl = this.wAuthorizationPrefix;
        Label wlAuthorizationValue = new Label(this.wAuthComp, 131072);
        PropsUi.setLook((Widget)wlAuthorizationValue);
        wlAuthorizationValue.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.API.AuthorizationValue", (String[])new String[0]));
        FormData fdlAuthorizationValue = new FormData();
        fdlAuthorizationValue.top = new FormAttachment(this.lastControl, this.margin);
        fdlAuthorizationValue.left = new FormAttachment(0, 0);
        fdlAuthorizationValue.right = new FormAttachment(this.middle, -this.margin);
        wlAuthorizationValue.setLayoutData((Object)fdlAuthorizationValue);
        this.wAuthorizationValue = new PasswordTextVar(this.variables, this.wAuthComp, 18436);
        PropsUi.setLook((Widget)this.wAuthorizationValue);
        FormData fdAuthorizationValue = new FormData();
        fdAuthorizationValue.top = new FormAttachment((Control)wlAuthorizationValue, 0, 0x1000000);
        fdAuthorizationValue.left = new FormAttachment(this.middle, 0);
        fdAuthorizationValue.right = new FormAttachment(95, 0);
        this.wAuthorizationValue.setLayoutData((Object)fdAuthorizationValue);
        this.wAuthComp.pack();
        Control[] controls = new Control[]{this.wAuthorizationName, this.wAuthorizationPrefix, this.wAuthorizationValue};
        this.enableControls(controls);
    }

    private void addCertificateFields() {
        this.clearAuthComp();
        Label wlInfo = new Label(this.wAuthComp, 16448);
        wlInfo.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.Certificate.Info", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInfo);
        FormData fdlInfo = new FormData();
        fdlInfo.top = new FormAttachment(0, this.margin);
        fdlInfo.left = new FormAttachment(0, 0);
        fdlInfo.right = new FormAttachment(100, 0);
        wlInfo.setLayoutData((Object)fdlInfo);
        this.wAuthComp.pack();
        this.wAuthComp.redraw();
    }

    public Button[] createButtonsForButtonBar(Composite composite) {
        Button wTest = new Button(composite, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        return new Button[]{wTest};
    }

    private void test() {
        Object responsePreview;
        IVariables variables = this.hopGui.getVariables();
        RestConnection restConnection = new RestConnection(variables);
        restConnection.setName(this.wName.getText());
        if (StringUtils.isEmpty((String)this.wTestUrl.getText())) {
            restConnection.setTestUrl(this.wBaseUrl.getText());
        } else {
            restConnection.setTestUrl(this.wTestUrl.getText());
        }
        restConnection.setBaseUrl(this.wBaseUrl.getText());
        restConnection.setTestUrl(this.wTestUrl.getText());
        restConnection.setTrustStoreFile(this.wTrustStoreFile.getText());
        restConnection.setTrustStorePassword(this.wTrustStorePassword.getText());
        restConnection.setIgnoreSsl(this.wIgnoreSsl.getSelection());
        restConnection.setKeyStoreFile(this.wKeyStoreFile.getText());
        restConnection.setKeyStorePassword(this.wKeyStorePassword.getText());
        restConnection.setKeyStoreType(this.wKeyStoreType.getText());
        restConnection.setKeyPassword(this.wKeyPassword.getText());
        restConnection.setCertificateAlias(this.wCertificateAlias.getText());
        restConnection.setAuthType(this.wAuthType.getText());
        if (!this.wAuthType.getText().equals("No Auth")) {
            if (this.wAuthType.getText().equals("Basic")) {
                restConnection.setUsername(this.wUsername.getText());
                restConnection.setPassword(this.wPassword.getText());
            } else if (this.wAuthType.getText().equals("Bearer")) {
                restConnection.setBearerToken(this.wBearerValue.getText());
            } else if (this.wAuthType.getText().equals("API Key")) {
                restConnection.setAuthorizationHeaderName(this.wAuthorizationName.getText());
                restConnection.setAuthorizationPrefix(this.wAuthorizationPrefix.getText());
                restConnection.setAuthorizationHeaderValue(this.wAuthorizationValue.getText());
            } else if (this.wAuthType.getText().equals("Certificate")) {
                // empty if block
            }
        }
        String resolvedTestUrl = variables.resolve(restConnection.getTestUrl());
        try {
            responsePreview = restConnection.getResponse(resolvedTestUrl);
            if (responsePreview != null && ((String)responsePreview).length() > 500) {
                responsePreview = ((String)responsePreview).substring(0, 500) + "... (truncated)";
            }
        }
        catch (Exception e) {
            responsePreview = "<error retrieving response: " + Const.NVL((String)e.getMessage(), (String)"unknown") + ">";
        }
        String debugSummary = "ignoreSsl = " + restConnection.isIgnoreSsl() + "\ntrustStore (raw) = " + Const.NVL((String)restConnection.getTrustStoreFile(), (String)"<empty>") + "\ntrustStore (resolved) = " + (StringUtils.isEmpty((String)restConnection.getTrustStoreFile()) ? "<empty>" : variables.resolve(restConnection.getTrustStoreFile())) + "\nkeyStore (raw) = " + Const.NVL((String)restConnection.getKeyStoreFile(), (String)"<empty>") + "\nkeyStore (resolved) = " + (StringUtils.isEmpty((String)restConnection.getKeyStoreFile()) ? "<empty>" : variables.resolve(restConnection.getKeyStoreFile())) + "\nkeyStore type = " + Const.NVL((String)restConnection.getKeyStoreType(), (String)"<empty>") + "\nkey password set = " + !StringUtils.isEmpty((String)restConnection.getKeyPassword()) + "\nauthType = " + Const.NVL((String)restConnection.getAuthType(), (String)"<empty>") + "\ntest URL (resolved) = " + resolvedTestUrl + "\nresponse preview = " + Const.NVL((String)responsePreview, (String)"<null>");
        MessageBox debugBox = new MessageBox(this.hopGui.getShell(), 34);
        debugBox.setText("REST Connection Test - Debug Info");
        debugBox.setMessage(debugSummary + "\n\nClick OK to continue the test.");
        debugBox.open();
        try {
            restConnection.testConnection();
            MessageBox box = new MessageBox(this.hopGui.getShell(), 32);
            box.setText("OK");
            String message = BaseMessages.getString(PKG, (String)"RestConnectionEditor.ConnectionTestSuccess", (String[])new String[0]) + Const.CR;
            message = message + Const.CR;
            message = message + "URL : " + restConnection.getTestUrl();
            box.setMessage(message);
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error connecting to REST URL : " + this.wTestUrl.getText(), e);
        }
    }

    public void dispose() {
    }

    public void setWidgetsContent() {
        if (!StringUtils.isEmpty((String)((RestConnection)this.metadata).getAuthorizationHeaderName()) && !StringUtils.isEmpty((String)((RestConnection)this.metadata).getAuthorizationHeaderValue()) && StringUtils.isEmpty((String)((RestConnection)this.metadata).getAuthType())) {
            ((RestConnection)this.metadata).setAuthType("API Key");
        }
        this.wName.setText(Const.NVL((String)((RestConnection)this.metadata).getName(), (String)""));
        this.wBaseUrl.setText(Const.NVL((String)((RestConnection)this.metadata).getBaseUrl(), (String)""));
        this.wTestUrl.setText(Const.NVL((String)((RestConnection)this.metadata).getTestUrl(), (String)""));
        this.wTrustStoreFile.setText(Const.NVL((String)((RestConnection)this.metadata).getTrustStoreFile(), (String)""));
        this.wTrustStorePassword.setText(Const.NVL((String)((RestConnection)this.metadata).getTrustStorePassword(), (String)""));
        this.wIgnoreSsl.setSelection(((RestConnection)this.metadata).isIgnoreSsl());
        this.wKeyStoreFile.setText(Const.NVL((String)((RestConnection)this.metadata).getKeyStoreFile(), (String)""));
        this.wKeyStorePassword.setText(Const.NVL((String)((RestConnection)this.metadata).getKeyStorePassword(), (String)""));
        this.wKeyStoreType.setText(Const.NVL((String)((RestConnection)this.metadata).getKeyStoreType(), (String)"PKCS12"));
        this.wKeyPassword.setText(Const.NVL((String)((RestConnection)this.metadata).getKeyPassword(), (String)""));
        this.wCertificateAlias.setText(Const.NVL((String)((RestConnection)this.metadata).getCertificateAlias(), (String)""));
        if (StringUtils.isEmpty((String)((RestConnection)this.metadata).getAuthType())) {
            ((RestConnection)this.metadata).setAuthType("No Auth");
            this.wAuthType.select(0);
        } else {
            this.wAuthType.select(Arrays.asList(authTypes).indexOf(((RestConnection)this.metadata).getAuthType()));
        }
        switch (((RestConnection)this.metadata).getAuthType()) {
            case "Basic": {
                this.addBasicAuthFields();
                this.wUsername.setText(Const.NVL((String)((RestConnection)this.metadata).getUsername(), (String)""));
                this.wPassword.setText(Const.NVL((String)((RestConnection)this.metadata).getPassword(), (String)""));
                break;
            }
            case "Bearer": {
                this.addBearerFields();
                this.wBearerValue.setText(((RestConnection)this.metadata).getBearerToken());
                break;
            }
            case "API Key": {
                this.addApiKeyFields();
                this.wAuthorizationName.setText(Const.NVL((String)((RestConnection)this.metadata).getAuthorizationHeaderName(), (String)""));
                this.wAuthorizationPrefix.setText(Const.NVL((String)((RestConnection)this.metadata).getAuthorizationPrefix(), (String)""));
                this.wAuthorizationValue.setText(Const.NVL((String)((RestConnection)this.metadata).getAuthorizationHeaderValue(), (String)""));
                break;
            }
            case "Certificate": {
                this.addCertificateFields();
            }
        }
    }

    public void getWidgetsContent(RestConnection connection) {
        connection.setName(this.wName.getText());
        connection.setBaseUrl(this.wBaseUrl.getText());
        connection.setTestUrl(this.wTestUrl.getText());
        connection.setTrustStoreFile(this.wTrustStoreFile.getText());
        connection.setTrustStorePassword(this.wTrustStorePassword.getText());
        connection.setIgnoreSsl(this.wIgnoreSsl.getSelection());
        connection.setKeyStoreFile(this.wKeyStoreFile.getText());
        connection.setKeyStorePassword(this.wKeyStorePassword.getText());
        connection.setKeyStoreType(this.wKeyStoreType.getText());
        connection.setKeyPassword(this.wKeyPassword.getText());
        connection.setCertificateAlias(this.wCertificateAlias.getText());
        connection.setAuthType(this.wAuthType.getText());
        if (this.wAuthType.getText().equals("Basic")) {
            connection.setUsername(this.wUsername.getText());
            connection.setPassword(this.wPassword.getText());
        } else if (this.wAuthType.getText().equals("Bearer")) {
            connection.setBearerToken(this.wBearerValue.getText());
        } else if (this.wAuthType.getText().equals("API Key")) {
            connection.setAuthorizationHeaderName(this.wAuthorizationName.getText());
            connection.setAuthorizationPrefix(this.wAuthorizationPrefix.getText());
            connection.setAuthorizationHeaderValue(this.wAuthorizationValue.getText());
        }
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    private void activateTrustoreFields() {
        this.wTrustStoreFile.setEnabled(!this.wIgnoreSsl.getSelection());
        this.wbTrustStoreFile.setEnabled(!this.wIgnoreSsl.getSelection());
        this.wTrustStorePassword.setEnabled(!this.wIgnoreSsl.getSelection());
    }
}

