/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration.tabs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ConfigKeyboardShortcutsTab {
    private static final Class<?> PKG = BaseDialog.class;
    private Font monoFont;
    private Color keyForegroundColor;
    private Color keyBackgroundColor;

    @GuiTab(id="10150-config-perspective-keyboard-shortcuts-tab", parentId="ConfigurationPerspective.Tabs.ID", description="Keyboard shortcuts tab")
    public void addKeyboardShortcutsTab(CTabFolder wTabFolder) {
        FontData[] fontData;
        int margin = PropsUi.getMargin();
        CTabItem wShortcutsTab = new CTabItem(wTabFolder, 0);
        wShortcutsTab.setFont(GuiResource.getInstance().getFontDefault());
        wShortcutsTab.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.KeyboardShortuts", (String[])new String[0]));
        wShortcutsTab.setImage(GuiResource.getInstance().getImageKeyboard());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FormLayout());
        Composite contentComposite = new Composite((Composite)scrolledComposite, 0);
        PropsUi.setLook((Widget)contentComposite);
        contentComposite.setLayout((Layout)new FormLayout());
        Display display = wTabFolder.getDisplay();
        this.keyForegroundColor = display.getSystemColor(16);
        this.keyBackgroundColor = new Color((Device)display, 240, 240, 245);
        if (PropsUi.getInstance().isDarkMode()) {
            this.keyBackgroundColor = new Color((Device)display, 24, 24, 24);
        }
        if ((fontData = display.getSystemFont().getFontData()).length > 0) {
            FontData monoFontData = new FontData(fontData[0].getName(), fontData[0].getHeight(), 1);
            this.monoFont = new Font((Device)display, monoFontData);
        }
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        Map shortcutsMap = guiRegistry.getShortCutsMap();
        boolean isMacOS = Const.isOSX();
        Control lastControl = null;
        ArrayList classNames = new ArrayList(shortcutsMap.keySet());
        Collections.sort(classNames);
        for (String className : classNames) {
            List allShortcuts = (List)shortcutsMap.get(className);
            if (allShortcuts == null || allShortcuts.isEmpty()) continue;
            ArrayList<KeyboardShortcut> shortcuts = new ArrayList<KeyboardShortcut>();
            for (KeyboardShortcut shortcut : allShortcuts) {
                if (shortcut.isOsx() != isMacOS) continue;
                shortcuts.add(shortcut);
            }
            if (shortcuts.isEmpty()) continue;
            shortcuts.sort((s1, s2) -> this.formatMethodName(s1.getParentMethodName()).compareTo(this.formatMethodName(s2.getParentMethodName())));
            ExpandBar expandBar = new ExpandBar(contentComposite, 0);
            PropsUi.setLook((Widget)expandBar);
            Composite expandContent = new Composite((Composite)expandBar, 0);
            PropsUi.setLook((Widget)expandContent);
            FormLayout expandLayout = new FormLayout();
            expandLayout.marginWidth = PropsUi.getFormMargin();
            expandLayout.marginHeight = PropsUi.getFormMargin();
            expandContent.setLayout((Layout)expandLayout);
            Control lastShortcut = null;
            for (KeyboardShortcut shortcut : shortcuts) {
                lastShortcut = this.createShortcutRow(expandContent, shortcut, lastShortcut, margin);
            }
            ExpandItem expandItem = new ExpandItem(expandBar, 0);
            expandItem.setText(this.getPluginName(className));
            expandItem.setControl((Control)expandContent);
            expandItem.setExpanded(true);
            expandItem.setHeight(expandContent.computeSize((int)-1, (int)-1).y);
            FormData fdExpandBar = new FormData();
            fdExpandBar.left = new FormAttachment(0, 0);
            fdExpandBar.right = new FormAttachment(100, 0);
            fdExpandBar.top = lastControl != null ? new FormAttachment(lastControl, margin) : new FormAttachment(0, margin);
            expandBar.setLayoutData((Object)fdExpandBar);
            expandBar.addListener(17, e -> Display.getDefault().asyncExec(() -> {
                if (!contentComposite.isDisposed() && !scrolledComposite.isDisposed()) {
                    contentComposite.layout();
                    scrolledComposite.setMinHeight(contentComposite.computeSize((int)-1, (int)-1).y);
                }
            }));
            expandBar.addListener(18, e -> Display.getDefault().asyncExec(() -> {
                if (!contentComposite.isDisposed() && !scrolledComposite.isDisposed()) {
                    contentComposite.layout();
                    scrolledComposite.setMinHeight(contentComposite.computeSize((int)-1, (int)-1).y);
                }
            }));
            lastControl = expandBar;
        }
        if (Const.isOSX()) {
            lastControl = this.addSymbolReference(contentComposite, lastControl, margin);
        }
        Label bottomSpacer = new Label(contentComposite, 0);
        FormData fdBottomSpacer = new FormData();
        fdBottomSpacer.left = new FormAttachment(0, 0);
        fdBottomSpacer.top = new FormAttachment(lastControl, margin * 2);
        fdBottomSpacer.height = 1;
        bottomSpacer.setLayoutData((Object)fdBottomSpacer);
        contentComposite.layout();
        contentComposite.pack();
        scrolledComposite.setContent((Control)contentComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(contentComposite.getBounds().width);
        scrolledComposite.setMinHeight(contentComposite.getBounds().height);
        scrolledComposite.addDisposeListener(e -> {
            if (this.monoFont != null && !this.monoFont.isDisposed()) {
                this.monoFont.dispose();
            }
            if (this.keyBackgroundColor != null && !this.keyBackgroundColor.isDisposed()) {
                this.keyBackgroundColor.dispose();
            }
            if (this.keyForegroundColor != null && !this.keyForegroundColor.isDisposed()) {
                this.keyForegroundColor.dispose();
            }
        });
        wShortcutsTab.setControl((Control)scrolledComposite);
    }

    private Control createShortcutRow(Composite parent, KeyboardShortcut shortcut, Control lastControl, int margin) {
        String keyText;
        Composite row = new Composite(parent, 0);
        PropsUi.setLook((Widget)row);
        row.setLayout((Layout)new FormLayout());
        FormData fdRow = new FormData();
        fdRow.left = new FormAttachment(0, 0);
        fdRow.right = new FormAttachment(100, 0);
        fdRow.top = lastControl != null ? new FormAttachment(lastControl, margin / 2) : new FormAttachment(0, 0);
        row.setLayoutData((Object)fdRow);
        Composite keysComposite = new Composite(row, 0);
        PropsUi.setLook((Widget)keysComposite);
        keysComposite.setLayout((Layout)new FormLayout());
        FormData fdKeys = new FormData();
        fdKeys.left = new FormAttachment(0, 0);
        fdKeys.top = new FormAttachment(0, 0);
        fdKeys.bottom = new FormAttachment(100, 0);
        fdKeys.width = 200;
        keysComposite.setLayoutData((Object)fdKeys);
        boolean isMacOS = Const.isOSX();
        Label lastKey = null;
        if (isMacOS) {
            if (shortcut.isCommand()) {
                lastKey = this.createKeyBadge(keysComposite, "\u2318", (Control)lastKey, margin);
            }
            if (shortcut.isShift()) {
                lastKey = this.createKeyBadge(keysComposite, "\u21e7", (Control)lastKey, margin);
            }
            if (shortcut.isAlt()) {
                lastKey = this.createKeyBadge(keysComposite, "\u2325", (Control)lastKey, margin);
            }
            if (shortcut.isControl()) {
                lastKey = this.createKeyBadge(keysComposite, "\u2303", (Control)lastKey, margin);
            }
        } else {
            if (shortcut.isControl()) {
                lastKey = this.createKeyBadge(keysComposite, "Ctrl", (Control)lastKey, margin);
            }
            if (shortcut.isAlt()) {
                lastKey = this.createKeyBadge(keysComposite, "Alt", (Control)lastKey, margin);
            }
            if (shortcut.isShift()) {
                lastKey = this.createKeyBadge(keysComposite, "Shift", (Control)lastKey, margin);
            }
            if (shortcut.isCommand()) {
                lastKey = this.createKeyBadge(keysComposite, "Cmd", (Control)lastKey, margin);
            }
        }
        if (!Utils.isEmpty((CharSequence)(keyText = this.getKeyText(shortcut.getKeyCode())))) {
            lastKey = this.createKeyBadge(keysComposite, keyText, (Control)lastKey, margin);
        }
        Label methodLabel = new Label(row, 16384);
        PropsUi.setLook((Widget)methodLabel);
        methodLabel.setText(this.formatMethodName(shortcut.getParentMethodName()));
        FormData fdMethod = new FormData();
        fdMethod.left = new FormAttachment((Control)keysComposite, margin);
        fdMethod.top = new FormAttachment(0, 0);
        fdMethod.right = new FormAttachment(100, 0);
        methodLabel.setLayoutData((Object)fdMethod);
        return row;
    }

    private Label createKeyBadge(Composite parent, String text, Control lastControl, int margin) {
        Label key = new Label(parent, 0x1000800);
        key.setText(text);
        key.setBackground(this.keyBackgroundColor);
        key.setForeground(this.keyForegroundColor);
        if (this.monoFont != null) {
            key.setFont(this.monoFont);
        }
        FormData fdKey = new FormData();
        fdKey.left = lastControl != null ? new FormAttachment(lastControl, margin / 2) : new FormAttachment(0, 0);
        fdKey.top = new FormAttachment(0, 0);
        fdKey.bottom = new FormAttachment(100, 0);
        fdKey.width = this.getBadgeWidth(text);
        key.setLayoutData((Object)fdKey);
        return key;
    }

    private int getBadgeWidth(String text) {
        if (text.equals("Ctrl") || text.equals("Alt") || text.equals("Cmd") || text.equals("Shift") || text.equals("Del") || text.equals("Home") || text.equals("End") || text.equals("PgUp") || text.equals("PgDn") || text.equals("Ins") || text.equals("Esc") || text.equals("Space")) {
            return 60;
        }
        if (text.startsWith("F") && text.length() >= 2 && text.length() <= 3) {
            try {
                Integer.parseInt(text.substring(1));
                return 45;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 32;
    }

    private String getKeyText(int keyCode) {
        boolean isMacOS = Const.isOSX();
        if (keyCode == 16777259) {
            return "+";
        }
        if (keyCode == 16777261) {
            return "-";
        }
        if (keyCode == 16777258) {
            return "*";
        }
        if (keyCode == 16777263) {
            return "/";
        }
        if (keyCode == 16777277) {
            return "=";
        }
        if (keyCode == 16777262) {
            return ".";
        }
        if (keyCode == 0x1000050) {
            return "\u21b5";
        }
        if (keyCode >= 0x1000030 && keyCode <= 16777273) {
            return String.valueOf(keyCode - 0x1000030);
        }
        if (keyCode == 32) {
            return "Space";
        }
        if (keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        if (keyCode >= 97 && keyCode <= 122) {
            return String.valueOf(Character.toUpperCase((char)keyCode));
        }
        if (keyCode == 127) {
            return isMacOS ? "\u232b" : "Del";
        }
        if (keyCode >= 48 && keyCode <= 57 || "+-/*=".indexOf(keyCode) >= 0) {
            return String.valueOf((char)keyCode);
        }
        if ((keyCode & 0x1000000) != 0) {
            switch (keyCode & 0xFFFF) {
                case 1: {
                    return "\u2191";
                }
                case 2: {
                    return "\u2193";
                }
                case 3: {
                    return "\u2190";
                }
                case 4: {
                    return "\u2192";
                }
                case 5: {
                    return "PgUp";
                }
                case 6: {
                    return "PgDn";
                }
                case 7: {
                    return "Home";
                }
                case 8: {
                    return "End";
                }
                case 9: {
                    return "Ins";
                }
                case 10: {
                    return "F1";
                }
                case 11: {
                    return "F2";
                }
                case 12: {
                    return "F3";
                }
                case 13: {
                    return "F4";
                }
                case 14: {
                    return "F5";
                }
                case 15: {
                    return "F6";
                }
                case 16: {
                    return "F7";
                }
                case 17: {
                    return "F8";
                }
                case 18: {
                    return "F9";
                }
                case 19: {
                    return "F10";
                }
                case 20: {
                    return "F11";
                }
                case 21: {
                    return "F12";
                }
                case 22: {
                    return "F13";
                }
                case 23: {
                    return "F14";
                }
                case 24: {
                    return "F15";
                }
                case 25: {
                    return "F16";
                }
                case 26: {
                    return "F17";
                }
                case 27: {
                    return "F18";
                }
                case 28: {
                    return "F19";
                }
                case 29: {
                    return "F20";
                }
            }
        }
        if (keyCode == 27) {
            return isMacOS ? "\u238b" : "Esc";
        }
        return "";
    }

    private String formatMethodName(String methodName) {
        if (Utils.isEmpty((CharSequence)methodName)) {
            return "";
        }
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < methodName.length(); ++i) {
            char c = methodName.charAt(i);
            if (i == 0) {
                formatted.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                formatted.append(' ').append(c);
                continue;
            }
            formatted.append(c);
        }
        return formatted.toString();
    }

    private String getPluginName(String className) {
        if (Utils.isEmpty((CharSequence)className)) {
            return "";
        }
        try {
            Class<?> clazz = Class.forName(className);
            GuiPlugin annotation = clazz.getAnnotation(GuiPlugin.class);
            if (annotation != null) {
                String name;
                if (!Utils.isEmpty((CharSequence)annotation.name()) && !Utils.isEmpty((CharSequence)(name = TranslateUtil.translate((String)annotation.name(), clazz)))) {
                    return name;
                }
                if (!Utils.isEmpty((CharSequence)annotation.id())) {
                    return annotation.id();
                }
            }
        }
        catch (Exception clazz) {
            // empty catch block
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < className.length() - 1) {
            return className.substring(lastDot + 1);
        }
        return className;
    }

    private Control addSymbolReference(Composite parent, Control lastControl, int margin) {
        Label separator = new Label(parent, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(0, 0);
        fdSeparator.right = new FormAttachment(100, 0);
        fdSeparator.top = new FormAttachment(lastControl, margin * 2);
        separator.setLayoutData((Object)fdSeparator);
        Label titleLabel = new Label(parent, 16384);
        PropsUi.setLook((Widget)titleLabel);
        titleLabel.setText(BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.SymbolReference.Title", (String[])new String[0]));
        titleLabel.setFont(this.monoFont);
        FormData fdTitle = new FormData();
        fdTitle.left = new FormAttachment(0, 0);
        fdTitle.top = new FormAttachment((Control)separator, margin);
        titleLabel.setLayoutData((Object)fdTitle);
        Composite refComposite = new Composite(parent, 0);
        PropsUi.setLook((Widget)refComposite);
        refComposite.setLayout((Layout)new FormLayout());
        FormData fdRefComposite = new FormData();
        fdRefComposite.left = new FormAttachment(0, 0);
        fdRefComposite.right = new FormAttachment(100, 0);
        fdRefComposite.top = new FormAttachment((Control)titleLabel, margin / 2);
        refComposite.setLayoutData((Object)fdRefComposite);
        String[][] symbols = new String[][]{{"\u2303", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.Control", (String[])new String[0])}, {"\u2325", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.OptionAlt", (String[])new String[0])}, {"\u2318", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.Command", (String[])new String[0])}, {"\u21e7", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.Shift", (String[])new String[0])}, {"\u238b", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.Escape", (String[])new String[0])}, {"\u232b", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.Delete", (String[])new String[0])}, {"\u2191", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.UpArrow", (String[])new String[0])}, {"\u2193", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.DownArrow", (String[])new String[0])}, {"\u2190", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.LeftArrow", (String[])new String[0])}, {"\u2192", BaseMessages.getString(PKG, (String)"ConfigKeyboardShortcutsTab.Key.RightArrow", (String[])new String[0])}};
        Composite lastRef = null;
        int itemsPerRow = 5;
        int currentItem = 0;
        for (String[] symbol : symbols) {
            Composite itemComposite = new Composite(refComposite, 0);
            PropsUi.setLook((Widget)itemComposite);
            itemComposite.setLayout((Layout)new FormLayout());
            Label symbolLabel = new Label(itemComposite, 0x1000800);
            symbolLabel.setText(symbol[0]);
            symbolLabel.setBackground(this.keyBackgroundColor);
            symbolLabel.setForeground(this.keyForegroundColor);
            if (this.monoFont != null) {
                symbolLabel.setFont(this.monoFont);
            }
            FormData fdSymbol = new FormData();
            fdSymbol.left = new FormAttachment(0, 0);
            fdSymbol.top = new FormAttachment(0, 0);
            fdSymbol.width = 24;
            fdSymbol.height = 24;
            symbolLabel.setLayoutData((Object)fdSymbol);
            Label descLabel = new Label(itemComposite, 16384);
            PropsUi.setLook((Widget)descLabel);
            descLabel.setText(symbol[1]);
            descLabel.setForeground(this.keyForegroundColor);
            FormData fdDesc = new FormData();
            fdDesc.left = new FormAttachment((Control)symbolLabel, margin / 2);
            fdDesc.top = new FormAttachment((Control)symbolLabel, 0, 0x1000000);
            fdDesc.right = new FormAttachment(100, 0);
            descLabel.setLayoutData((Object)fdDesc);
            itemComposite.layout(true, true);
            FormData fdItem = new FormData();
            int column = currentItem % itemsPerRow;
            int row = currentItem / itemsPerRow;
            fdItem.left = column == 0 ? new FormAttachment(0, 0) : new FormAttachment(column * 100 / itemsPerRow, 0);
            fdItem.top = row == 0 ? new FormAttachment(0, 0) : new FormAttachment(lastRef, margin / 2);
            itemComposite.setLayoutData((Object)fdItem);
            if (column == itemsPerRow - 1 || currentItem == symbols.length - 1) {
                lastRef = itemComposite;
            }
            ++currentItem;
        }
        refComposite.layout(true, true);
        fdRefComposite.height = refComposite.computeSize((int)-1, (int)-1).y;
        refComposite.setLayoutData((Object)fdRefComposite);
        return refComposite;
    }
}

