/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SerdeUtils {
    private SerdeUtils() {
    }

    @Nonnull
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serializeObject(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object obj) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (obj == null) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object deserializeObject(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serialized) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (serialized == null || serialized.length == 0) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleVersionedSerializer<T> getNaiveObjectSerializer() {
        return new SimpleVersionedSerializer<T>(){

            public @UnknownKeyFor @NonNull @Initialized int getVersion() {
                return 0;
            }

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serialize(T obj) throws @UnknownKeyFor @NonNull @Initialized IOException {
                return SerdeUtils.serializeObject(obj);
            }

            public T deserialize(@UnknownKeyFor @NonNull @Initialized int version, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serialized) throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (version > this.getVersion()) {
                    throw new IOException(String.format("Received serialized object of version %d, which is higher than the highest supported version %d.", version, this.getVersion()));
                }
                return SerdeUtils.deserializeObject(serialized);
            }
        };
    }
}

