/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.time.LocalTime;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class LocalTimeComparator
extends BasicTypeComparator<LocalTime> {
    private static final long serialVersionUID = 1L;

    public LocalTimeComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        return LocalTimeComparator.compareSerializedLocalTime(firstSource, secondSource, this.ascendingComparison);
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 7;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(LocalTime record, MemorySegment target, int offset, int numBytes) {
        LocalTimeComparator.putNormalizedKeyLocalTime(record, target, offset, numBytes);
    }

    public LocalTimeComparator duplicate() {
        return new LocalTimeComparator(this.ascendingComparison);
    }

    public static int compareSerializedLocalTime(DataInputView firstSource, DataInputView secondSource, boolean ascendingComparison) throws IOException {
        int cmp = firstSource.readByte() - secondSource.readByte();
        if (cmp == 0 && (cmp = firstSource.readByte() - secondSource.readByte()) == 0 && (cmp = firstSource.readByte() - secondSource.readByte()) == 0) {
            cmp = firstSource.readInt() - secondSource.readInt();
        }
        return ascendingComparison ? cmp : -cmp;
    }

    public static void putNormalizedKeyLocalTime(LocalTime record, MemorySegment target, int offset, int numBytes) {
        int hour = record.getHour();
        if (numBytes > 0) {
            target.put(offset, (byte)(hour & 0x17F));
            --numBytes;
            ++offset;
        }
        int minute = record.getMinute();
        if (numBytes > 0) {
            target.put(offset, (byte)(minute & 0x17F));
            --numBytes;
            ++offset;
        }
        int second = record.getSecond();
        if (numBytes > 0) {
            target.put(offset, (byte)(second & 0x17F));
            --numBytes;
            ++offset;
        }
        int nano = record.getNano();
        int unsignedNano = nano - Integer.MIN_VALUE;
        if (numBytes >= 4) {
            target.putIntBigEndian(offset, unsignedNano);
            numBytes -= 4;
            offset += 4;
        } else if (numBytes > 0) {
            int i = 0;
            while (numBytes > 0) {
                target.put(offset + i, (byte)(unsignedNano >>> (3 - i << 3)));
                --numBytes;
                ++i;
            }
            return;
        }
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)0);
        }
    }
}

