/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaTimestamp;

public enum GraphPropertyType {
    String,
    Integer,
    Float,
    Boolean,
    Date,
    LocalDateTime,
    ByteArray,
    Time,
    Point,
    Duration,
    LocalTime,
    DateTime;


    public static String getCode(GraphPropertyType type) {
        if (type == null) {
            return null;
        }
        return type.name();
    }

    public static GraphPropertyType parseCode(String code) {
        if (code == null) {
            return String;
        }
        try {
            return GraphPropertyType.valueOf(code);
        }
        catch (IllegalArgumentException e) {
            return String;
        }
    }

    public static String[] getNames() {
        String[] names = new String[GraphPropertyType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = GraphPropertyType.values()[i].name();
        }
        return names;
    }

    public Object convertFromHop(IValueMeta valueMeta, Object valueData) throws HopValueException {
        if (valueMeta.isNull(valueData)) {
            return null;
        }
        TimeZone timeZone = valueMeta.getDateFormatTimeZone();
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        switch (this) {
            case String: {
                return valueMeta.getString(valueData);
            }
            case Boolean: {
                return valueMeta.getBoolean(valueData);
            }
            case Float: {
                return valueMeta.getNumber(valueData);
            }
            case Integer: {
                return valueMeta.getInteger(valueData);
            }
            case Date: {
                return valueMeta.getDate(valueData).toInstant().atZone(timeZone.toZoneId()).toLocalDate();
            }
            case LocalDateTime: {
                return valueMeta.getDate(valueData).toInstant().atZone(timeZone.toZoneId()).toLocalDateTime();
            }
            case ByteArray: {
                return valueMeta.getBinary(valueData);
            }
            case DateTime: {
                ZonedDateTime zonedDateTime;
                if (valueMeta instanceof ValueMetaTimestamp) {
                    ValueMetaTimestamp valueMetaTimestamp = (ValueMetaTimestamp)valueMeta;
                    Timestamp timestamp = valueMetaTimestamp.getTimestamp(valueData);
                    zonedDateTime = timestamp.toInstant().atZone(timeZone.toZoneId());
                } else {
                    Date date = valueMeta.getDate(valueData);
                    zonedDateTime = date.toInstant().atZone(timeZone.toZoneId());
                }
                return zonedDateTime;
            }
        }
        throw new HopValueException("Data conversion to Neo4j type '" + this.name() + "' from value '" + valueMeta.toStringMeta() + "' is not supported yet");
    }

    public static final GraphPropertyType getTypeFromHop(IValueMeta valueMeta) {
        switch (valueMeta.getType()) {
            case 2: {
                return String;
            }
            case 1: {
                return Float;
            }
            case 3: {
                return LocalDateTime;
            }
            case 9: {
                return LocalDateTime;
            }
            case 4: {
                return Boolean;
            }
            case 8: {
                return ByteArray;
            }
            case 6: {
                return String;
            }
            case 5: {
                return Integer;
            }
        }
        return String;
    }
}

