/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.sql.SQLUtils;
import com.clickhouse.client.internal.org.antlr.v4.runtime.tree.ErrorNode;
import com.clickhouse.jdbc.internal.ClickHouseParser;
import com.clickhouse.jdbc.internal.ClickHouseParserBaseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParsedStatement
extends ClickHouseParserBaseListener {
    private String useDatabase;
    private boolean hasResultSet;
    private boolean insert;
    private String insertTableId;
    private List<String> roles;
    private boolean hasErrors;

    public void setUseDatabase(String useDatabase) {
        this.useDatabase = useDatabase;
    }

    public void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    public boolean isHasResultSet() {
        return this.hasResultSet;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setInsertTableId(String insertTableId) {
        this.insertTableId = insertTableId;
    }

    public String getInsertTableId() {
        return this.insertTableId;
    }

    public String getUseDatabase() {
        return this.useDatabase;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        this.setHasErrors(true);
    }

    @Override
    public void enterQueryStmt(ClickHouseParser.QueryStmtContext ctx) {
        ClickHouseParser.QueryContext qCtx = ctx.query();
        if (qCtx != null && (qCtx.selectStmt() != null || qCtx.selectUnionStmt() != null || qCtx.showStmt() != null || qCtx.describeStmt() != null)) {
            this.setHasResultSet(true);
        }
    }

    @Override
    public void enterUseStmt(ClickHouseParser.UseStmtContext ctx) {
        if (ctx.databaseIdentifier() != null) {
            this.setUseDatabase(SQLUtils.unquoteIdentifier(ctx.databaseIdentifier().getText()));
        }
    }

    @Override
    public void enterSetRoleStmt(ClickHouseParser.SetRoleStmtContext ctx) {
        if (ctx.NONE() != null) {
            this.setRoles(Collections.emptyList());
        } else {
            ArrayList<String> roles = new ArrayList<String>();
            for (ClickHouseParser.IdentifierContext id : ctx.setRolesList().identifier()) {
                roles.add(SQLUtils.unquoteIdentifier(id.getText()));
            }
            this.setRoles(roles);
        }
    }
}

