/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbdelete;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodbdelete.Comparator;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteData;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteField;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MongoDbDeleteDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MongoDbDeleteDialog.class;
    public static final String CONST_ERROR = "Error";
    public static final String CONST_MONGO_DB_INPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT = "MongoDbInputDialog.ErrorMessage.UnableToConnect";
    private MetaSelectionLine<MongoDbConnection> wConnection;
    protected MongoDbDeleteMeta currentMeta;
    protected MongoDbDeleteMeta originalMeta;
    private Button wbGetFields;
    private Button wbPreviewDocStruct;
    private CCombo wCollection;
    private TextVar wtvTimeout;
    private TextVar wtvWriteRetries;
    private TextVar wtvWriteRetryDelay;
    private TableView wtvMongoFieldsView;
    private StyledTextComp wstJsonQueryView;
    private Button wbUseJsonQuery;
    private Label wlExecuteForEachRow;
    private Button wcbEcuteForEachRow;
    private ColumnInfo[] colInf;
    private final List<String> inputFields = new ArrayList<String>();

    public MongoDbDeleteDialog(Shell parent, IVariables variables, MongoDbDeleteMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.currentMeta = transformMeta;
        this.originalMeta = (MongoDbDeleteMeta)((Object)this.currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.currentMeta);
        ModifyListener lsMod = e -> this.currentMeta.setChanged();
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fd);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        MetaSelectionLine<MongoDbConnection> lastControl = this.wTransformName;
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fd);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wDeleteOptionsTab = new CTabItem(wTabFolder, 0);
        wDeleteOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wDeleteOptionsTab.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.DeleteTab.TabTitle", (String[])new String[0]));
        Composite wOutputComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wOutputComp);
        FormLayout outputLayout = new FormLayout();
        outputLayout.marginWidth = 3;
        outputLayout.marginHeight = 3;
        wOutputComp.setLayout((Layout)outputLayout);
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, MongoDbConnection.class, wOutputComp, 0, BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ConnectionName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ConnectionName.Tooltip", (String[])new String[0]));
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment(0, 0);
        this.wConnection.setLayoutData((Object)fdConnection);
        lastControl = this.wConnection;
        try {
            this.wConnection.fillItems();
        }
        catch (HopException e2) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error loading list of MongoDB connection names", (Exception)((Object)e2));
        }
        Label wlCollection = new Label(wOutputComp, 131072);
        wlCollection.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Collection.Label", (String[])new String[0]));
        wlCollection.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Collection.TipText", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCollection);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        wlCollection.setLayoutData((Object)fd);
        Button wbGetCollections = new Button(wOutputComp, 0x1000008);
        PropsUi.setLook((Widget)wbGetCollections);
        wbGetCollections.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.GetCollections.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(lastControl, 0);
        wbGetCollections.setLayoutData((Object)fd);
        wbGetCollections.addListener(13, e -> this.getCollectionNames());
        this.wCollection = new CCombo(wOutputComp, 2048);
        PropsUi.setLook((Widget)this.wCollection);
        this.wCollection.addListener(24, e -> {
            this.currentMeta.setChanged();
            this.wCollection.setToolTipText(this.variables.resolve(this.wCollection.getText()));
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(lastControl, margin);
        fd.right = new FormAttachment((Control)wbGetCollections, -margin);
        this.wCollection.setLayoutData((Object)fd);
        Label retriesLab = new Label(wOutputComp, 131072);
        PropsUi.setLook((Widget)retriesLab);
        retriesLab.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.WriteRetries.Label", (String[])new String[0]));
        retriesLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.WriteRetries.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)this.wCollection, margin);
        fd.right = new FormAttachment(middle, -margin);
        retriesLab.setLayoutData((Object)fd);
        this.wtvWriteRetries = new TextVar(this.variables, wOutputComp, 18436);
        PropsUi.setLook((Widget)this.wtvWriteRetries);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.wCollection, margin);
        fd.right = new FormAttachment(100, 0);
        this.wtvWriteRetries.setLayoutData((Object)fd);
        this.wtvWriteRetries.addModifyListener(e -> this.wtvWriteRetries.setToolTipText(this.variables.resolve(this.wtvWriteRetries.getText())));
        Label retriesDelayLab = new Label(wOutputComp, 131072);
        PropsUi.setLook((Widget)retriesDelayLab);
        retriesDelayLab.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.WriteRetriesDelay.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)this.wtvWriteRetries, margin);
        fd.right = new FormAttachment(middle, -margin);
        retriesDelayLab.setLayoutData((Object)fd);
        this.wtvWriteRetryDelay = new TextVar(this.variables, wOutputComp, 18436);
        PropsUi.setLook((Widget)this.wtvWriteRetryDelay);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.wtvWriteRetries, margin);
        fd.right = new FormAttachment(100, 0);
        this.wtvWriteRetryDelay.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wOutputComp.setLayoutData((Object)fd);
        wOutputComp.layout();
        wDeleteOptionsTab.setControl((Control)wOutputComp);
        CTabItem mWQueryTab = new CTabItem(wTabFolder, 0);
        mWQueryTab.setFont(GuiResource.getInstance().getFontDefault());
        mWQueryTab.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.QueryTab.TabTitle", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout filterLayout = new FormLayout();
        filterLayout.marginWidth = 3;
        filterLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)filterLayout);
        Label useDefinedQueryLab = new Label(wFieldsComp, 131072);
        useDefinedQueryLab.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.useQuery.Label", (String[])new String[0]));
        useDefinedQueryLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.useQuery.TipText", (String[])new String[0]));
        PropsUi.setLook((Widget)useDefinedQueryLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(middle, -margin);
        useDefinedQueryLab.setLayoutData((Object)fd);
        this.wbUseJsonQuery = new Button(wFieldsComp, 32);
        PropsUi.setLook((Widget)this.wbUseJsonQuery);
        this.wbUseJsonQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbDeleteDialog.this.currentMeta.setChanged();
                if (MongoDbDeleteDialog.this.wbUseJsonQuery.getSelection()) {
                    MongoDbDeleteDialog.this.setQueryJsonVisibility(true);
                    MongoDbDeleteDialog.this.setQueryFieldVisiblity(false);
                } else {
                    MongoDbDeleteDialog.this.setQueryFieldVisiblity(true);
                    MongoDbDeleteDialog.this.setQueryJsonVisibility(false);
                }
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, -margin);
        fd.top = new FormAttachment(0, margin * 3);
        fd.left = new FormAttachment(middle, 0);
        this.wbUseJsonQuery.setLayoutData((Object)fd);
        this.colInf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Fields.Path", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Fields.Comparator", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Fields.Incoming1", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Fields.Incoming2", (String[])new String[0]), 2, false)};
        this.colInf[1].setComboValues(Comparator.asLabel());
        this.colInf[1].setReadOnly(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta stepMeta = MongoDbDeleteDialog.this.pipelineMeta.findTransform(MongoDbDeleteDialog.this.transformName);
                if (stepMeta != null) {
                    try {
                        IRowMeta row = MongoDbDeleteDialog.this.pipelineMeta.getPrevTransformFields(MongoDbDeleteDialog.this.variables, stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            MongoDbDeleteDialog.this.inputFields.add(row.getValueMeta(i).getName());
                        }
                        MongoDbDeleteDialog.this.setComboBoxes();
                    }
                    catch (HopTransformException e) {
                        MongoDbDeleteDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.Log.UnableToFindInput", (String[])new String[0])});
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wbGetFields = new Button(wFieldsComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbGetFields);
        this.wbGetFields.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.GetFieldsBut", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment(0, margin);
        this.wbGetFields.setLayoutData((Object)fd);
        this.wbGetFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbDeleteDialog.this.getFields();
            }
        });
        this.wbPreviewDocStruct = new Button(wFieldsComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbPreviewDocStruct);
        this.wbPreviewDocStruct.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.PreviewDocStructBut", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment((Control)this.wbGetFields, margin);
        this.wbPreviewDocStruct.setLayoutData((Object)fd);
        this.wbPreviewDocStruct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbDeleteDialog.this.previewDocStruct();
            }
        });
        this.wtvMongoFieldsView = new TableView(this.variables, wFieldsComp, 65538, this.colInf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.wbUseJsonQuery, margin * 2);
        fd.bottom = new FormAttachment((Control)this.wbGetFields, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.wtvMongoFieldsView.setLayoutData((Object)fd);
        this.wlExecuteForEachRow = new Label(wFieldsComp, 131072);
        this.wlExecuteForEachRow.setText(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.execEachRow.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlExecuteForEachRow);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment(0, margin);
        this.wlExecuteForEachRow.setLayoutData((Object)fd);
        this.wcbEcuteForEachRow = new Button(wFieldsComp, 32);
        PropsUi.setLook((Widget)this.wcbEcuteForEachRow);
        this.wcbEcuteForEachRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbDeleteDialog.this.currentMeta.setChanged();
            }
        });
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment((Control)this.wlExecuteForEachRow, margin);
        this.wcbEcuteForEachRow.setLayoutData((Object)fd);
        this.wstJsonQueryView = new StyledTextComp(this.variables, wFieldsComp, 68354);
        PropsUi.setLook((Widget)this.wstJsonQueryView, (int)1);
        this.wstJsonQueryView.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, -margin * 3);
        fd.top = new FormAttachment((Control)this.wbUseJsonQuery, margin * 2);
        fd.bottom = new FormAttachment((Control)this.wlExecuteForEachRow, -margin * 2);
        this.wstJsonQueryView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fd);
        wFieldsComp.layout();
        mWQueryTab.setControl((Control)wFieldsComp);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wTransformName, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -50);
        wTabFolder.setLayoutData((Object)fd);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)wTabFolder);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wTransformName.addListener(13, e -> this.ok());
        wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        if (this.currentMeta.isUseJsonQuery()) {
            this.setQueryFieldVisiblity(false);
        } else {
            this.setQueryJsonVisibility(false);
        }
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void cancel() {
        this.transformName = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.currentMeta);
        if (!this.currentMeta.isUseJsonQuery() && Utils.isEmpty(this.currentMeta.getMongoFields())) {
            this.showNoFieldMessageDialog();
        } else if (this.currentMeta.isUseJsonQuery() && StringUtil.isEmpty((String)this.currentMeta.getJsonQuery())) {
            this.showNoQueryWarningDialog();
        }
        if (!((Object)((Object)this.originalMeta)).equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCustomWriteConcernNames() {
        block8: {
            try {
                String connectionName = this.variables.resolve(this.wConnection.getText());
                MongoDbConnection connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                if (!StringUtil.isEmpty((String)connectionName)) {
                    MongoDbDeleteMeta meta = new MongoDbDeleteMeta();
                    this.getInfo(meta);
                    try {
                        MongoClientWrapper wrapper = connection.createWrapper(this.variables, (ILogChannel)this.log);
                        List<Object> custom = new ArrayList();
                        try {
                            custom = wrapper.getLastErrorModes();
                            break block8;
                        }
                        finally {
                            wrapper.dispose();
                        }
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                    }
                    break block8;
                }
                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{"host name(s)"}));
                smd.open();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, CONST_ERROR, "Error getting collections", e);
            }
        }
    }

    private void getFields() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wtvMongoFieldsView, (int)1, (int[])new int[]{1, 3}, null, (int)-1, (int)-1, null);
            }
        }
        catch (HopTransformException e) {
            this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), e);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getInfo(MongoDbDeleteMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setCollection(this.wCollection.getText());
        meta.setWriteRetries(this.wtvWriteRetries.getText());
        meta.setWriteRetryDelay(this.wtvWriteRetryDelay.getText());
        meta.setUseJsonQuery(this.wbUseJsonQuery.getSelection());
        meta.setExecuteForEachIncomingRow(this.wcbEcuteForEachRow.getSelection());
        meta.setJsonQuery(this.wstJsonQueryView.getText());
        meta.setMongoFields(this.tableToMongoFieldList());
    }

    private List<MongoDbDeleteField> tableToMongoFieldList() {
        int numNonEmpty = this.wtvMongoFieldsView.nrNonEmpty();
        if (numNonEmpty > 0) {
            ArrayList<MongoDbDeleteField> mongoFields = new ArrayList<MongoDbDeleteField>();
            for (int i = 0; i < numNonEmpty; ++i) {
                TableItem item = this.wtvMongoFieldsView.getNonEmpty(i);
                String path = item.getText(1).trim();
                String comparator = item.getText(2).trim();
                String field1 = item.getText(3).trim();
                String field2 = item.getText(4).trim();
                MongoDbDeleteField newField = new MongoDbDeleteField();
                newField.mongoDocPath = path;
                if (StringUtil.isEmpty((String)comparator)) {
                    comparator = Comparator.EQUAL.getValue();
                }
                newField.comparator = comparator;
                newField.incomingField1 = field1;
                newField.incomingField2 = field2;
                mongoFields.add(newField);
            }
            return mongoFields;
        }
        return null;
    }

    private void getData() {
        this.wConnection.setText(Const.NVL((String)this.currentMeta.getConnectionName(), (String)""));
        this.wCollection.setText(Const.NVL((String)this.currentMeta.getCollection(), (String)""));
        this.wtvWriteRetries.setText(Const.NVL((String)this.currentMeta.getWriteRetries(), (String)("" + this.currentMeta.nbRetries)));
        this.wtvWriteRetryDelay.setText(Const.NVL((String)this.currentMeta.getWriteRetryDelay(), (String)("" + this.currentMeta.nbRetries)));
        this.wbUseJsonQuery.setSelection(this.currentMeta.isUseJsonQuery());
        this.wcbEcuteForEachRow.setSelection(this.currentMeta.isExecuteForEachIncomingRow());
        this.wstJsonQueryView.setText(Const.NVL((String)this.currentMeta.getJsonQuery(), (String)""));
        List<MongoDbDeleteField> mongoFields = this.currentMeta.getMongoFields();
        if (!Utils.isEmpty(mongoFields)) {
            for (MongoDbDeleteField field : mongoFields) {
                TableItem item = new TableItem(this.wtvMongoFieldsView.table, 0);
                item.setText(1, Const.NVL((String)field.mongoDocPath, (String)""));
                item.setText(2, Const.NVL((String)field.comparator, (String)""));
                item.setText(3, Const.NVL((String)field.incomingField1, (String)""));
                item.setText(4, Const.NVL((String)field.incomingField2, (String)""));
            }
            this.wtvMongoFieldsView.removeEmptyRows();
            this.wtvMongoFieldsView.setRowNums();
            this.wtvMongoFieldsView.optWidth(true);
        }
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colInf[2].setComboValues(fieldNames);
        this.colInf[2].setReadOnly(false);
        this.colInf[3].setComboValues(fieldNames);
        this.colInf[3].setReadOnly(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollectionNames() {
        try {
            String connectionName = this.variables.resolve(this.wConnection.getText());
            String current = this.wCollection.getText();
            this.wCollection.removeAll();
            MongoDbConnection connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
            String databaseName = this.variables.resolve(connection.getDbName());
            if (!StringUtils.isEmpty((String)connectionName)) {
                MongoDbDeleteMeta meta = new MongoDbDeleteMeta();
                this.getInfo(meta);
                try {
                    Set<String> collections;
                    MongoClientWrapper wrapper = connection.createWrapper(this.variables, (ILogChannel)this.log);
                    try {
                        collections = wrapper.getCollectionsNames(databaseName);
                    }
                    finally {
                        wrapper.dispose();
                    }
                    for (String c : collections) {
                        this.wCollection.add(c);
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_MONGO_DB_INPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT, (String[])new String[0]), e);
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_MONGO_DB_INPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_MONGO_DB_INPUT_DIALOG_ERROR_MESSAGE_UNABLE_TO_CONNECT, (String[])new String[0]), e);
                }
            } else {
                Object missingConnDetails = "";
                if (StringUtils.isEmpty((String)connectionName)) {
                    missingConnDetails = (String)missingConnDetails + "connection name";
                }
                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{missingConnDetails}));
                smd.open();
            }
            if (!StringUtils.isEmpty((String)current)) {
                this.wCollection.setText(current);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error getting collections", e);
        }
    }

    private void previewDocStruct() {
        List<MongoDbDeleteField> mongoFields = this.tableToMongoFieldList();
        if (Utils.isEmpty(mongoFields)) {
            this.showNoFieldMessageDialog();
            return;
        }
        IRowMeta actualR = null;
        boolean gotGenuineRowMeta = false;
        try {
            actualR = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            gotGenuineRowMeta = true;
        }
        catch (HopTransformException hopTransformException) {
            // empty catch block
        }
        RowMeta r = new RowMeta();
        Object[] dummyRow = new Object[mongoFields.size() * 2];
        int i = 0;
        try {
            for (MongoDbDeleteField mongoDbDeleteField : mongoFields) {
                if (!StringUtil.isEmpty((String)mongoDbDeleteField.incomingField1) && !StringUtil.isEmpty((String)mongoDbDeleteField.incomingField2)) {
                    IValueMeta vm1 = ValueMetaFactory.createValueMeta((int)2);
                    vm1.setName(mongoDbDeleteField.incomingField1);
                    r.addValueMeta(vm1);
                    IValueMeta vm2 = ValueMetaFactory.createValueMeta((int)2);
                    vm2.setName(mongoDbDeleteField.incomingField2);
                    r.addValueMeta(vm2);
                    String val1 = this.getValueToDisplay(gotGenuineRowMeta, actualR, mongoDbDeleteField.incomingField1);
                    dummyRow[i++] = val1;
                    String val2 = this.getValueToDisplay(gotGenuineRowMeta, actualR, mongoDbDeleteField.incomingField2);
                    dummyRow[i++] = val2;
                    continue;
                }
                IValueMeta vm = ValueMetaFactory.createValueMeta((int)2);
                vm.setName(mongoDbDeleteField.incomingField1);
                r.addValueMeta(vm);
                String val = this.getValueToDisplay(gotGenuineRowMeta, actualR, mongoDbDeleteField.incomingField1);
                dummyRow[i++] = val;
            }
            Variables vs = new Variables();
            for (MongoDbDeleteField m : mongoFields) {
                m.init((IVariables)vs);
            }
            String string = "";
            String windowTitle = BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.PreviewDocStructure.Title", (String[])new String[0]);
            DBObject query = MongoDbDeleteData.getQueryObject(mongoFields, (IRowMeta)r, dummyRow, (IVariables)vs);
            String string2 = BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.PreviewModifierUpdate.Heading1", (String[])new String[0]) + ": \n\n" + MongoDbDeleteDialog.prettyPrintDocStructure(query.toString());
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, windowTitle, string2, true);
            smd.open();
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.ProblemPreviewingDocStructure.Message", (String[])new String[0]) + ":\n\n" + ex.getMessage(), ex);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.ProblemPreviewingDocStructure.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.ProblemPreviewingDocStructure.Message", (String[])new String[0]) + ":\n\n" + ex.getMessage(), ex);
            return;
        }
    }

    private String getValueToDisplay(boolean genuineRowMeta, IRowMeta rmi, String fieldName) {
        String val = "";
        if (genuineRowMeta && rmi.indexOfValue(fieldName) >= 0) {
            int index = rmi.indexOfValue(fieldName);
            switch (rmi.getValueMeta(index).getType()) {
                case 2: {
                    val = "<string val>";
                    break;
                }
                case 5: {
                    val = "<integer val>";
                    break;
                }
                case 1: {
                    val = "<number val>";
                    break;
                }
                case 4: {
                    val = "<bool val>";
                    break;
                }
                case 3: {
                    val = "<date val>";
                    break;
                }
                case 8: {
                    val = "<binary val>";
                    break;
                }
                case 11: {
                    val = "<JSON document>";
                    break;
                }
                default: {
                    try {
                        int uuidTypeId = ValueMetaFactory.getIdForValueMeta((String)"UUID");
                        if (rmi.getValueMeta(index).getType() == uuidTypeId) {
                            val = "<UUID val>";
                            break;
                        }
                        val = "<unsupported value type>";
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        } else {
            val = "<value>";
        }
        return val;
    }

    private static void pad(StringBuffer toPad, int numBlanks) {
        for (int i = 0; i < numBlanks; ++i) {
            toPad.append(' ');
        }
    }

    public static String prettyPrintDocStructure(String toFormat) {
        StringBuffer result = new StringBuffer();
        int indent = 0;
        String source = toFormat.replaceAll("[ ]*,", ",");
        Element next = Element.OPEN_BRACE;
        while (!source.isEmpty()) {
            source = source.trim();
            String toIndent = "";
            int minIndex = Integer.MAX_VALUE;
            char targetChar = '{';
            if (source.indexOf(123) > -1 && source.indexOf(123) < minIndex) {
                next = Element.OPEN_BRACE;
                minIndex = source.indexOf(123);
                targetChar = '{';
            }
            if (source.indexOf(125) > -1 && source.indexOf(125) < minIndex) {
                next = Element.CLOSE_BRACE;
                minIndex = source.indexOf(125);
                targetChar = '}';
            }
            if (source.indexOf(91) > -1 && source.indexOf(91) < minIndex) {
                next = Element.OPEN_BRACKET;
                minIndex = source.indexOf(91);
                targetChar = '[';
            }
            if (source.indexOf(93) > -1 && source.indexOf(93) < minIndex) {
                next = Element.CLOSE_BRACKET;
                minIndex = source.indexOf(93);
                targetChar = ']';
            }
            if (source.indexOf(44) > -1 && source.indexOf(44) < minIndex) {
                next = Element.COMMA;
                minIndex = source.indexOf(44);
                targetChar = ',';
            }
            if (minIndex == 0) {
                if (next == Element.CLOSE_BRACE || next == Element.CLOSE_BRACKET) {
                    indent -= 2;
                }
                MongoDbDeleteDialog.pad(result, indent);
                String comma = "";
                int offset = 1;
                if (source.length() >= 2 && source.charAt(1) == ',') {
                    comma = ",";
                    offset = 2;
                }
                result.append(targetChar).append(comma).append("\n");
                source = source.substring(offset);
            } else {
                MongoDbDeleteDialog.pad(result, indent);
                if (next == Element.CLOSE_BRACE || next == Element.CLOSE_BRACKET) {
                    toIndent = source.substring(0, minIndex);
                    source = source.substring(minIndex);
                } else {
                    toIndent = source.substring(0, minIndex + 1);
                    source = source.substring(minIndex + 1);
                }
                result.append(toIndent.trim()).append("\n");
            }
            if (next != Element.OPEN_BRACE && next != Element.OPEN_BRACKET) continue;
            indent += 2;
        }
        return result.toString();
    }

    private void showNoFieldMessageDialog() {
        ShowMessageDialog smd = new ShowMessageDialog(this.shell, 16777256, BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.NoFieldPathsDefined.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.NoFieldPathsDefined", (String[])new String[0]));
        smd.open();
    }

    private void showNoQueryWarningDialog() {
        ShowMessageDialog smd = new ShowMessageDialog(this.shell, 16777256, BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.NoJsonQueryDefined.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.NoJsonQueryDefined", (String[])new String[0]));
        smd.open();
    }

    private void setQueryFieldVisiblity(boolean visible) {
        this.wtvMongoFieldsView.setVisible(visible);
        this.wbGetFields.setVisible(visible);
        this.wbPreviewDocStruct.setVisible(visible);
    }

    private void setQueryJsonVisibility(boolean visible) {
        this.wstJsonQueryView.setVisible(visible);
        this.wlExecuteForEachRow.setVisible(visible);
        this.wcbEcuteForEachRow.setVisible(visible);
    }

    private static enum Element {
        OPEN_BRACE,
        CLOSE_BRACE,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        COMMA;

    }
}

