/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import java.util.EnumSet;

public enum SharedAccessAccountResourceType {
    SERVICE('s'),
    CONTAINER('c'),
    OBJECT('o');

    char value;

    private SharedAccessAccountResourceType(char c) {
        this.value = c;
    }

    static String resourceTypesToString(EnumSet<SharedAccessAccountResourceType> types) {
        if (types == null) {
            return "";
        }
        StringBuilder value = new StringBuilder();
        for (SharedAccessAccountResourceType type : types) {
            value.append(type.value);
        }
        return value.toString();
    }

    static EnumSet<SharedAccessAccountResourceType> resourceTypesFromString(String rsrcString) {
        EnumSet<SharedAccessAccountResourceType> resources = EnumSet.noneOf(SharedAccessAccountResourceType.class);
        for (char c : rsrcString.toLowerCase().toCharArray()) {
            boolean invalidCharacter = true;
            for (SharedAccessAccountResourceType rsrc : SharedAccessAccountResourceType.values()) {
                if (c != rsrc.value) continue;
                resources.add(rsrc);
                invalidCharacter = false;
                break;
            }
            if (!invalidCharacter) continue;
            throw new IllegalArgumentException(String.format("%s could not be parsed from '%s'.", "Resource Types", rsrcString));
        }
        return resources;
    }
}

