/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class MetadataConfig {
    private static final String METADATA_URL = "http://metadata.google.internal/computeMetadata/v1/";
    private static final int TIMEOUT_MS = 5000;

    private MetadataConfig() {
    }

    public static String getProjectId() {
        return MetadataConfig.getAttribute("project/project-id");
    }

    public static String getZone() {
        String zoneId = MetadataConfig.getAttribute("instance/zone");
        if (zoneId != null && zoneId.contains("/")) {
            return zoneId.substring(zoneId.lastIndexOf(47) + 1);
        }
        return zoneId;
    }

    public static String getInstanceId() {
        return MetadataConfig.getAttribute("instance/id");
    }

    public static String getClusterName() {
        return MetadataConfig.getAttribute("instance/attributes/cluster-name");
    }

    public static String getContainerName() {
        return MetadataConfig.getAttribute("instance/attributes/container-name");
    }

    public static String getNamespaceId() {
        return MetadataConfig.getAttribute("instance/attributes/namespace-id");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getAttribute(String attributeName) {
        block13: {
            try {
                URL url = new URL(METADATA_URL + attributeName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("Metadata-Flavor", "Google");
                try (InputStream input = connection.getInputStream();){
                    String string;
                    if (connection.getResponseCode() != 200) break block13;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                        string = reader.readLine();
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

