/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.googleapis.notifications;

import java.io.IOException;
import java.nio.charset.Charset;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.notifications.StoredChannel;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.notifications.TypedNotification;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.notifications.UnparsedNotification;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.notifications.UnparsedNotificationCallback;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpMediaType;
import net.snowflake.client.jdbc.internal.google.api.client.util.Beta;
import net.snowflake.client.jdbc.internal.google.api.client.util.ObjectParser;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;

@Beta
public abstract class TypedNotificationCallback<T>
implements UnparsedNotificationCallback {
    private static final long serialVersionUID = 1L;

    protected abstract void onNotification(StoredChannel var1, TypedNotification<T> var2) throws IOException;

    protected abstract ObjectParser getObjectParser() throws IOException;

    protected abstract Class<T> getDataClass() throws IOException;

    @Override
    public final void onNotification(StoredChannel storedChannel, UnparsedNotification notification) throws IOException {
        TypedNotification<T> typedNotification = new TypedNotification<T>(notification);
        String contentType = notification.getContentType();
        if (contentType != null) {
            Charset charset = new HttpMediaType(contentType).getCharsetParameter();
            Class<T> dataClass = Preconditions.checkNotNull(this.getDataClass());
            typedNotification.setContent(this.getObjectParser().parseAndClose(notification.getContentStream(), charset, dataClass));
        }
        this.onNotification(storedChannel, typedNotification);
    }
}

