/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.PKITLSClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.SelfSignedTLSClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;

public abstract class ClientAuthentication {
    private final ClientAuthenticationMethod method;
    private final ClientID clientID;

    protected ClientAuthentication(ClientAuthenticationMethod method, ClientID clientID) {
        this.method = Objects.requireNonNull(method);
        this.clientID = Objects.requireNonNull(clientID);
    }

    public ClientAuthenticationMethod getMethod() {
        return this.method;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public abstract Set<String> getFormParameterNames();

    public static ClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        if (httpRequest.getAuthorization() != null && httpRequest.getAuthorization().startsWith("Basic")) {
            return ClientSecretBasic.parse(httpRequest);
        }
        if (httpRequest.getMethod() != HTTPRequest.Method.POST && !httpRequest.getEntityContentType().matches(ContentType.APPLICATION_URLENCODED)) {
            return null;
        }
        Map params = httpRequest.getBodyAsFormParameters();
        if (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_id")) && StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_secret"))) {
            return ClientSecretPost.parse(httpRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_assertion")) && StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_assertion_type"))) {
            return JWTAuthentication.parse(httpRequest);
        }
        if (httpRequest.getClientX509Certificate() != null && StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_id"))) {
            X500Principal issuer = httpRequest.getClientX509Certificate().getIssuerX500Principal();
            X500Principal subject = httpRequest.getClientX509Certificate().getSubjectX500Principal();
            if (issuer != null && issuer.equals(subject)) {
                if (httpRequest.getClientX509CertificateRootDN() != null && !httpRequest.getClientX509CertificateRootDN().equalsIgnoreCase(issuer.toString())) {
                    throw new ParseException("Client X.509 certificate issuer DN doesn't match HTTP request metadata");
                }
                if (httpRequest.getClientX509CertificateSubjectDN() != null && !httpRequest.getClientX509CertificateSubjectDN().equalsIgnoreCase(subject.toString())) {
                    throw new ParseException("Client X.509 certificate subject DN doesn't match HTTP request metadata");
                }
                return SelfSignedTLSClientAuthentication.parse(httpRequest);
            }
            return PKITLSClientAuthentication.parse(httpRequest);
        }
        return null;
    }

    public abstract void applyTo(HTTPRequest var1);
}

