/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.diagnostic;

import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.diagnostic.CertificateDiagnosticCheck;
import net.snowflake.client.jdbc.diagnostic.DiagnosticCheck;
import net.snowflake.client.jdbc.diagnostic.DnsDiagnosticCheck;
import net.snowflake.client.jdbc.diagnostic.HttpAndHttpsDiagnosticCheck;
import net.snowflake.client.jdbc.diagnostic.ProxyConfig;
import net.snowflake.client.jdbc.diagnostic.SnowflakeEndpoint;
import net.snowflake.client.jdbc.diagnostic.TcpDiagnosticCheck;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class DiagnosticContext {
    private static final SFLogger logger = SFLoggerFactory.getLogger(DiagnosticContext.class);
    private static final String JAVAX_NET_DEBUG = "javax.net.debug";
    private static final String JAVAX_TRUSTSTORE = "javax.net.ssl.trustStore";
    private ProxyConfig proxyConf;
    private List<SnowflakeEndpoint> endpoints = new ArrayList<SnowflakeEndpoint>();
    private final DiagnosticCheck[] tests;

    public DiagnosticContext(String allowListFile, Map<SFSessionProperty, Object> connectionPropertiesMap) {
        this.createProxyConfiguration(connectionPropertiesMap);
        try {
            JsonNode jsonNode = this.readAllowListJsonFile(allowListFile);
            for (JsonNode objectNode : jsonNode) {
                String type = objectNode.get("type").asText();
                String host = objectNode.get("host").asText();
                int port = objectNode.get("port").asInt();
                SnowflakeEndpoint e = new SnowflakeEndpoint(type, host, port);
                this.endpoints.add(e);
            }
        }
        catch (IOException e) {
            logger.error("Failed to read allowlist file: ", e);
        }
        catch (Exception e) {
            logger.error("Failed to parse data in allowlist file: " + allowListFile, e);
        }
        this.tests = new DiagnosticCheck[]{new DnsDiagnosticCheck(this.proxyConf), new TcpDiagnosticCheck(this.proxyConf), new CertificateDiagnosticCheck(this.proxyConf), new HttpAndHttpsDiagnosticCheck(this.proxyConf)};
    }

    DiagnosticContext(Map<SFSessionProperty, Object> connectionPropertiesMap) {
        this.createProxyConfiguration(connectionPropertiesMap);
        this.tests = null;
    }

    private void createProxyConfiguration(Map<SFSessionProperty, Object> connectionPropertiesMap) {
        String proxyHost = (String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_HOST);
        int proxyPort = connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PORT) == null ? -1 : Integer.parseInt((String)connectionPropertiesMap.get((Object)SFSessionProperty.PROXY_PORT));
        String nonProxyHosts = (String)connectionPropertiesMap.get((Object)SFSessionProperty.NON_PROXY_HOSTS);
        this.proxyConf = new ProxyConfig(proxyHost, proxyPort, nonProxyHosts);
    }

    public void runDiagnostics() {
        this.logEnvironmentInfo();
        for (DiagnosticCheck test : this.tests) {
            for (SnowflakeEndpoint endpoint : this.endpoints) {
                test.run(endpoint);
            }
        }
    }

    private JsonNode readAllowListJsonFile(String jsonFilePath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File allowListFile = new File(jsonFilePath);
        return objectMapper.readTree(allowListFile);
    }

    public void logEnvironmentInfo() {
        logger.info("Getting environment information", new Object[0]);
        logger.info("Current truststore used: " + this.getTrustStoreLocation(), new Object[0]);
        logger.info("-Dnetworkaddress.cache.ttl: " + System.getProperty("networkaddress.cache.ttl"), new Object[0]);
        logger.info("-Dnetworkaddress.cache.negative.ttl: " + System.getProperty("networkaddress.cache.negative.ttl"), new Object[0]);
        logger.info("-Djavax.net.debug: " + System.getProperty(JAVAX_NET_DEBUG), new Object[0]);
    }

    private boolean isNullOrEmpty(String a) {
        return a == null || a.isEmpty();
    }

    private String getTrustStoreLocation() {
        String trustStore = System.getProperty(JAVAX_TRUSTSTORE);
        String javaHome = System.getProperty("java.home");
        Path javaSecurityPath = FileSystems.getDefault().getPath(javaHome, "/lib/security");
        logger.info("JAVA_HOME: " + javaHome, new Object[0]);
        if (this.isNullOrEmpty(trustStore)) {
            logger.info("-D{} is null", JAVAX_TRUSTSTORE);
            Path jssecacertsPath = FileSystems.getDefault().getPath(javaSecurityPath.toString(), "jssecacerts");
            Path cacertsPath = FileSystems.getDefault().getPath(javaSecurityPath.toString(), "cacerts");
            logger.info("Checking if jssecacerts or cacerts exist", new Object[0]);
            if (Files.exists(jssecacertsPath, new LinkOption[0])) {
                logger.info(jssecacertsPath.toString() + " exists", new Object[0]);
                trustStore = jssecacertsPath.toString();
            } else if (Files.exists(cacertsPath, new LinkOption[0])) {
                logger.info(cacertsPath.toString() + " exists", new Object[0]);
                trustStore = cacertsPath.toString();
            }
        } else {
            logger.info("-D{} is set by user: {}", JAVAX_TRUSTSTORE, trustStore);
        }
        return trustStore;
    }

    String getHttpProxyHost() {
        return this.proxyConf.getHttpProxyHost();
    }

    int getHttpProxyPort() {
        return this.proxyConf.getHttpProxyPort();
    }

    String getHttpsProxyHost() {
        return this.proxyConf.getHttpsProxyHost();
    }

    int getHttpsProxyPort() {
        return this.proxyConf.getHttpsProxyPort();
    }

    String getHttpNonProxyHosts() {
        return this.proxyConf.getNonProxyHosts();
    }

    List<SnowflakeEndpoint> getEndpoints() {
        return this.endpoints;
    }

    Proxy getProxy(SnowflakeEndpoint snowflakeEndpoint) {
        return this.proxyConf.getProxy(snowflakeEndpoint);
    }

    boolean isProxyEnabled() {
        return this.proxyConf.isProxyEnabled();
    }

    boolean isProxyEnabledOnJvm() {
        return this.proxyConf.isProxyEnabledOnJvm();
    }
}

