/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class TinyIntToFixedConverter
extends AbstractArrowVectorConverter {
    protected TinyIntVector tinyIntVector;
    protected int sfScale = 0;

    public TinyIntToFixedConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector, columnIndex, context);
        this.tinyIntVector = (TinyIntVector)fieldVector;
    }

    @Override
    public byte toByte(int index) throws SFException {
        if (this.tinyIntVector.isNull(index)) {
            return 0;
        }
        return this.getByte(index);
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        if (this.tinyIntVector.isNull(index)) {
            return null;
        }
        ByteBuffer bytes = ByteBuffer.allocate(1);
        this.tinyIntVector.getDataBuffer().getBytes((long)index, bytes);
        return bytes.array();
    }

    protected byte getByte(int index) throws SFException {
        return this.tinyIntVector.getDataBuffer().getByte(index * 1);
    }

    @Override
    public short toShort(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public int toInt(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public float toFloat(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public double toDouble(int index) throws SFException {
        return this.toFloat(index);
    }

    @Override
    public long toLong(int index) throws SFException {
        return this.toByte(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) throws SFException {
        if (this.tinyIntVector.isNull(index)) {
            return null;
        }
        return BigDecimal.valueOf(this.getByte(index), this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        if (!this.shouldTreatDecimalAsInt()) {
            return BigDecimal.valueOf(this.getByte(index), this.sfScale);
        }
        return (long)this.toByte(index);
    }

    @Override
    public String toString(int index) throws SFException {
        return this.isNull(index) ? null : Short.toString(this.getByte(index));
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        short val = this.toShort(index);
        if (val == 0) {
            return false;
        }
        if (val == 1) {
            return true;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Boolean", val);
    }
}

