/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

public enum QueryStatus {
    RUNNING(0, "RUNNING"),
    ABORTING(1, "ABORTING"),
    SUCCESS(2, "SUCCESS"),
    FAILED_WITH_ERROR(3, "FAILED_WITH_ERROR"),
    ABORTED(4, "ABORTED"),
    QUEUED(5, "QUEUED"),
    FAILED_WITH_INCIDENT(6, "FAILED_WITH_INCIDENT"),
    DISCONNECTED(7, "DISCONNECTED"),
    RESUMING_WAREHOUSE(8, "RESUMING_WAREHOUSE"),
    QUEUED_REPAIRING_WAREHOUSE(9, "QUEUED_REPARING_WAREHOUSE"),
    RESTARTED(10, "RESTARTED"),
    BLOCKED(11, "BLOCKED"),
    NO_DATA(12, "NO_DATA");

    private final int value;
    private final String description;
    private String errorMessage = "No error reported";
    private int errorCode = 0;

    private QueryStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Deprecated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Deprecated
    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    @Deprecated
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public static boolean isStillRunning(QueryStatus status) {
        switch (status.getValue()) {
            case 0: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAnError(QueryStatus status) {
        switch (status.getValue()) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static QueryStatus getStatusFromString(String description) {
        if (description != null) {
            for (QueryStatus st : QueryStatus.values()) {
                if (!description.equalsIgnoreCase(st.getDescription())) continue;
                return st;
            }
            return NO_DATA;
        }
        return null;
    }
}

