/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engine;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEnginePluginType;

public class PipelineEngineFactory {
    public static final <T extends PipelineMeta> IPipelineEngine<T> createPipelineEngine(IVariables parentVariables, String runConfigurationName, IHopMetadataProvider metadataProvider, T pipelineMeta) throws HopException {
        PipelineRunConfiguration pipelineRunConfiguration;
        if (StringUtils.isEmpty((String)runConfigurationName)) {
            throw new HopException("Please specify a run configuration to execute the pipeline with");
        }
        try {
            pipelineRunConfiguration = (PipelineRunConfiguration)metadataProvider.getSerializer(PipelineRunConfiguration.class).load(runConfigurationName);
        }
        catch (HopException e) {
            throw new HopException("Error loading the pipeline run configuration '" + runConfigurationName + "'", (Throwable)e);
        }
        if (pipelineRunConfiguration == null) {
            throw new HopException("Unable to find the specified pipeline run configuration '" + runConfigurationName + "' in metadata provider: " + metadataProvider.getDescription());
        }
        Variables variables = new Variables();
        variables.copyFrom(parentVariables);
        pipelineRunConfiguration.applyToVariables((IVariables)variables);
        pipelineRunConfiguration.getEngineRunConfiguration().copyFrom((IVariables)variables);
        IPipelineEngine<T> pipelineEngine = PipelineEngineFactory.createPipelineEngine(pipelineRunConfiguration, pipelineMeta);
        pipelineEngine.initializeFrom((IVariables)variables);
        pipelineMeta.setInternalHopVariables(pipelineEngine);
        pipelineEngine.copyParametersFromDefinitions(pipelineMeta);
        PipelineEngineFactory.applyVariableDefinitions(pipelineEngine, pipelineRunConfiguration.getConfigurationVariables());
        pipelineEngine.setMetadataProvider(metadataProvider);
        pipelineMeta.setMetadataProvider(metadataProvider);
        return pipelineEngine;
    }

    public static <T extends PipelineMeta> void applyVariableDefinitions(IPipelineEngine<T> pipelineEngine, List<DescribedVariable> configurationVariables) {
        for (DescribedVariable cv : configurationVariables) {
            if (!StringUtils.isNotEmpty((String)cv.getValue()) || !StringUtils.isNotEmpty((String)cv.getName())) continue;
            String realValue = pipelineEngine.resolve(cv.getValue());
            pipelineEngine.setVariable(cv.getName(), realValue);
        }
    }

    public static final <T extends PipelineMeta> IPipelineEngine<T> createPipelineEngine(PipelineRunConfiguration pipelineRunConfiguration, T pipelineMeta) throws HopException {
        IPipelineEngineRunConfiguration engineRunConfiguration = pipelineRunConfiguration.getEngineRunConfiguration();
        if (engineRunConfiguration == null) {
            throw new HopException("There is no pipeline execution engine specified in run configuration '" + pipelineRunConfiguration.getName() + "'");
        }
        String enginePluginId = engineRunConfiguration.getEnginePluginId();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        IPlugin plugin = pluginRegistry.findPluginWithId(PipelineEnginePluginType.class, enginePluginId);
        if (plugin == null) {
            throw new HopException("Unable to find pipeline engine plugin type with ID '" + enginePluginId + "'");
        }
        IPipelineEngine pipelineEngine = (IPipelineEngine)pluginRegistry.loadClass(plugin, IPipelineEngine.class);
        pipelineEngine.setPipelineRunConfiguration(pipelineRunConfiguration);
        PipelineEngineFactory.applyVariableDefinitions(pipelineEngine, pipelineRunConfiguration.getConfigurationVariables());
        pipelineEngine.setPipelineMeta(pipelineMeta);
        pipelineEngine.setInternalHopVariables(pipelineEngine);
        return pipelineEngine;
    }
}

