/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;

public class DatabaseImpact {
    private static final Class<?> PKG = Pipeline.class;
    public static final int TYPE_IMPACT_NONE = 0;
    public static final int TYPE_IMPACT_READ = 1;
    public static final int TYPE_IMPACT_WRITE = 2;
    public static final int TYPE_IMPACT_READ_WRITE = 3;
    public static final int TYPE_IMPACT_TRUNCATE = 4;
    public static final int TYPE_IMPACT_DELETE = 5;
    public static final int TYPE_IMPACT_UPDATE = 6;
    public static final String[] typeDesc = new String[]{BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Write", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.ReadOrWrite", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Truncate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Delete", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseImpact.TypeDesc.Label.Update", (String[])new String[0])};
    private String pipelineName;
    private String transformName;
    private String dbname;
    private String table;
    private String field;
    private String valuename;
    private String valueorigin;
    private String sql;
    private String remark;
    private int type;

    public DatabaseImpact(int type, String pipelineName, String transformName, String dbname, String table, String field, String valuename, String valueorigin, String sql, String remark) {
        this.type = type;
        this.pipelineName = pipelineName;
        this.transformName = transformName;
        this.dbname = dbname;
        this.table = table;
        this.field = field;
        this.valuename = valuename;
        this.valueorigin = valueorigin;
        this.sql = sql;
        this.remark = remark;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public String getValueOrigin() {
        return this.valueorigin;
    }

    public String getDatabaseName() {
        return this.dbname;
    }

    public String getTable() {
        return this.table;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.valuename;
    }

    public String getSql() {
        return this.sql;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getTypeDesc() {
        return typeDesc[this.type];
    }

    public static final int getTypeDesc(String typedesc) {
        for (int i = 1; i < typeDesc.length; ++i) {
            if (!typeDesc[i].equalsIgnoreCase(typedesc)) continue;
            return i;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public RowMetaAndData getRow() {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Type", (String[])new String[0])), (Object)this.getTypeDesc());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Pipeline", (String[])new String[0])), (Object)this.getPipelineName());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Transform", (String[])new String[0])), (Object)this.getTransformName());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Database", (String[])new String[0])), (Object)this.getDatabaseName());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Table", (String[])new String[0])), (Object)this.getTable());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Field", (String[])new String[0])), (Object)this.getField());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Value", (String[])new String[0])), (Object)this.getValue());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.ValueOrigin", (String[])new String[0])), (Object)this.getValueOrigin());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.SQL", (String[])new String[0])), (Object)this.getSql());
        r.addValue((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"DatabaseImpact.RowDesc.Label.Remarks", (String[])new String[0])), (Object)this.getRemark());
        return r;
    }
}

