/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.List;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Rectangle;

public class AreaOwner {
    private Rectangle area;
    private Object parent;
    private Object owner;
    private AreaType areaType;

    public AreaOwner(AreaType areaType, int x, int y, int width, int height, DPoint offset, Object parent, Object owner) {
        this.areaType = areaType;
        this.area = new Rectangle((int)((double)x - offset.x), (int)((double)y - offset.y), width, height);
        this.parent = parent;
        this.owner = owner;
    }

    public AreaOwner(AreaOwner o) {
        this.areaType = o.areaType;
        this.area = new Rectangle(o.area);
        this.parent = o.parent;
        this.owner = o.owner;
    }

    public boolean contains(int x, int y) {
        return this.area.contains(x, y);
    }

    public int getCentreX() {
        return this.area.x + this.area.width / 2;
    }

    public int getCentreY() {
        return this.area.y + this.area.height / 2;
    }

    public double distanceTo(AreaOwner o) {
        int distX = this.getCentreX() - o.getCentreX();
        int distY = this.getCentreY() - o.getCentreY();
        return Math.sqrt(distX * distX + distY * distY);
    }

    public static synchronized AreaOwner getVisibleAreaOwner(List<AreaOwner> areaOwners, int x, int y) {
        for (int i = areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public static enum AreaType {
        NOTE(true),
        TRANSFORM_PARTITIONING(false),
        TRANSFORM_ICON(true),
        TRANSFORM_NAME(true),
        TRANSFORM_INFO_ICON(true),
        TRANSFORM_FAILURE_ICON(false),
        TRANSFORM_COPIES_TEXT(true),
        TRANSFORM_DATA_SERVICE(false),
        TRANSFORM_OUTPUT_DATA(true),
        TRANSFORM_TARGET_HOP_ICON(true),
        HOP_COPY_ICON(true),
        HOP_ERROR_ICON(true),
        HOP_INFO_ICON(true),
        HOP_INFO_TRANSFORM_COPIES_ERROR(false),
        HOP_INFO_TRANSFORMS_PARTITIONED(false),
        WORKFLOW_HOP_ICON(true),
        WORKFLOW_HOP_PARALLEL_ICON(true),
        ACTION_ICON(true),
        ACTION_NAME(true),
        ACTION_INFO_ICON(true),
        ACTION_BUSY(false),
        ACTION_RESULT_SUCCESS(true),
        ACTION_RESULT_FAILURE(true),
        ACTION_RESULT_CHECKPOINT(true),
        ROW_DISTRIBUTION_ICON(false),
        CUSTOM(true);

        private final boolean hover;

        private AreaType(boolean hover) {
            this.hover = hover;
        }

        public boolean isSupportHover() {
            return this.hover;
        }
    }
}

