/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.standardizephonenumber;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneField;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneNumberMeta;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StandardizePhoneNumberDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = StandardizePhoneNumberMeta.class;
    private final StandardizePhoneNumberMeta input;
    private TableView wFields;

    public StandardizePhoneNumberDialog(Shell parent, IVariables variables, StandardizePhoneNumberMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    protected void getData() {
        List<StandardizePhoneField> standardizes = this.input.getFields();
        if (!standardizes.isEmpty()) {
            Table table = this.wFields.getTable();
            for (int i = 0; i < standardizes.size(); ++i) {
                StandardizePhoneField standardize = standardizes.get(i);
                TableItem item = new TableItem(table, 0);
                item.setText(1, StringUtils.stripToEmpty((String)standardize.getInputField()));
                item.setText(2, StringUtils.stripToEmpty((String)standardize.getOutputField()));
                item.setText(3, StringUtils.stripToEmpty((String)standardize.getCountryField()));
                item.setText(4, StringUtils.stripToEmpty((String)standardize.getDefaultCountry()));
                item.setText(5, StringUtils.stripToEmpty((String)standardize.getNumberFormat()));
                item.setText(6, StringUtils.stripToEmpty((String)standardize.getNumberTypeField()));
                item.setText(7, StringUtils.stripToEmpty((String)standardize.getIsValidNumberField()));
            }
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.Shell.Title", (String[])new String[0]));
        this.shell.setMinimumSize(650, 350);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label hSpacer = new Label((Composite)this.shell, 258);
        hSpacer.setLayoutData((Object)new FormDataBuilder().left().right().bottom((Control)this.wOk, -margin).height(2).result());
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        wlTransformName.setLayoutData((Object)new FormDataBuilder().right(middle, -margin).result());
        PropsUi.setLook((Widget)wlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.wTransformName.addListener(24, e -> this.input.setChanged());
        this.wTransformName.setLayoutData((Object)new FormDataBuilder().left((Control)wlTransformName, margin).top((Control)wlTransformName, 0, 0x1000000).right().result());
        PropsUi.setLook((Widget)this.wTransformName);
        Label lblFields = new Label((Composite)this.shell, 16384);
        lblFields.setText(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.Fields.Label", (String[])new String[0]));
        lblFields.setLayoutData((Object)new FormDataBuilder().top((Control)this.wTransformName, margin).fullWidth().result());
        PropsUi.setLook((Widget)lblFields);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.InputField.Label", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.OutputField.Label", (String[])new String[0]), 1, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.CountryField.Label", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.DefaultCountry.Label", (String[])new String[0]), 2, this.input.getSupportedCountries(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.NumberFormat.Label", (String[])new String[0]), 2, this.input.getSupportedFormats(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.NumberTypeField.Label", (String[])new String[0]), 1, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.IsValidNumberField.Label", (String[])new String[0]), 1, new String[]{""}, false)};
        columns[0].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.InputField.Tooltip", (String[])new String[0]));
        columns[1].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.OutputField.Tooltip", (String[])new String[0]));
        columns[1].setUsingVariables(true);
        columns[2].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.CountryField.Tooltip", (String[])new String[0]));
        columns[3].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.DefaultCountry.Tooltip", (String[])new String[0]));
        columns[4].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.NumberFormat.Tooltip", (String[])new String[0]));
        columns[5].setUsingVariables(true);
        columns[5].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.NumberTypeField.Tooltip", (String[])new String[0]));
        columns[6].setUsingVariables(true);
        columns[6].setToolTip(BaseMessages.getString(PKG, (String)"StandardizePhoneNumberDialog.ColumnInfo.IsValidNumberField.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.getVariables(), (Composite)this.shell, 67586, columns, 0, e -> this.input.setChanged(), this.props);
        this.wFields.setLayoutData((Object)new FormDataBuilder().left().fullWidth().top((Control)lblFields, margin).bottom((Control)hSpacer, -margin).result());
        this.wFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{2, 20, 20, 10, 12, 12, 12, 8}));
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    final ArrayList<String> inputFields = new ArrayList<String>();
                    if (rowMeta != null) {
                        for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
                            inputFields.add(valueMeta.getName());
                        }
                        String[] fieldNames = Const.sortStrings((String[])inputFields.toArray(new String[0]));
                        columns[0].setComboValues(fieldNames);
                        columns[2].setComboValues(fieldNames);
                    }
                    HopGui.getInstance().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!StandardizePhoneNumberDialog.this.wFields.isDisposed()) {
                                for (int i = 0; i < StandardizePhoneNumberDialog.this.wFields.table.getItemCount(); ++i) {
                                    TableItem item = StandardizePhoneNumberDialog.this.wFields.table.getItem(i);
                                    if (!Utils.isEmpty((CharSequence)item.getText(1)) && !inputFields.contains(item.getText(1))) {
                                        item.setBackground(GuiResource.getInstance().getColorRed());
                                    }
                                    if (Utils.isEmpty((CharSequence)item.getText(3)) || inputFields.contains(item.getText(3))) continue;
                                    item.setBackground(GuiResource.getInstance().getColorRed());
                                }
                            }
                        }
                    });
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        ArrayList<StandardizePhoneField> standardizes = new ArrayList<StandardizePhoneField>();
        for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            StandardizePhoneField standardize = new StandardizePhoneField();
            standardize.setInputField(StringUtils.stripToNull((String)item.getText(1)));
            standardize.setOutputField(StringUtils.stripToNull((String)item.getText(2)));
            standardize.setCountryField(StringUtils.stripToNull((String)item.getText(3)));
            standardize.setDefaultCountry(StringUtils.stripToNull((String)item.getText(4)));
            standardize.setNumberFormat(StringUtils.stripToNull((String)item.getText(5)));
            standardize.setNumberTypeField(item.getText(6));
            standardize.setIsValidNumberField(StringUtils.stripToNull((String)item.getText(7)));
            standardizes.add(standardize);
        }
        this.input.setFields(standardizes);
        this.dispose();
    }
}

