/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.action;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.debug.action.ActionDebugLevel;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.debug.util.Defaults;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.IActionListener;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@ExtensionPoint(id="ModifyActionLogLevelExtensionPoint", extensionPointId="WorkflowStart", description="Modify the logging level of an individual workflow entry if needed")
public class ModifyActionLogLevelExtensionPoint
implements IExtensionPoint<IWorkflowEngine<WorkflowMeta>> {
    public static final String STRING_REFERENCE_VARIABLE_SPACE = "REFERENCE_VARIABLE_SPACE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callExtensionPoint(ILogChannel jobLog, IVariables variables, IWorkflowEngine<WorkflowMeta> workflow) throws HopException {
        IVariables referenceSpace;
        IWorkflowEngine rootWorkflow = workflow;
        IPipelineEngine rootPipeline = null;
        while (rootWorkflow != null || rootPipeline != null) {
            if (rootWorkflow != null) {
                if (rootWorkflow.getParentWorkflow() == null && rootWorkflow.getParentPipeline() == null) break;
                rootPipeline = rootWorkflow.getParentPipeline();
                rootWorkflow = rootWorkflow.getParentWorkflow();
                continue;
            }
            if (rootPipeline.getParentWorkflow() == null && rootPipeline.getParentPipeline() == null) break;
            rootWorkflow = rootPipeline.getParentWorkflow();
            rootPipeline = rootPipeline.getParentPipeline();
        }
        Map rootDataMap = rootWorkflow != null ? rootWorkflow.getExtensionDataMap() : rootPipeline.getExtensionDataMap();
        Map map = rootDataMap;
        synchronized (map) {
            IVariables referenceVariables = (IVariables)rootDataMap.get(STRING_REFERENCE_VARIABLE_SPACE);
            if (referenceVariables == null) {
                referenceVariables = new Variables();
                referenceVariables.initializeFrom((IVariables)workflow);
                rootDataMap.put(STRING_REFERENCE_VARIABLE_SPACE, referenceVariables);
            }
            referenceSpace = referenceVariables;
        }
        WorkflowMeta jobMeta = workflow.getWorkflowMeta();
        final Map entryLevelMap = (Map)jobMeta.getAttributesMap().get("debug_plugin");
        if (entryLevelMap == null) {
            return;
        }
        jobLog.logDetailed("Set debug level information on workflow : " + jobMeta.getName());
        final HashSet<String> entries = new HashSet<String>();
        for (String key : entryLevelMap.keySet()) {
            String entryName;
            int index = key.indexOf(" : ");
            if (index <= 0 || entries.contains(entryName = key.substring(0, index))) continue;
            entries.add(entryName);
        }
        if (entries.isEmpty()) {
            return;
        }
        try {
            final LogLevel jobLogLevel = workflow.getLogLevel();
            final Set<String> variablesToIgnore = Defaults.VARIABLES_TO_IGNORE;
            jobLog.logDetailed("Found debug level info for workflow actions : " + ((Object)entries).toString());
            workflow.addActionListener((IActionListener)new IActionListener<WorkflowMeta>(){

                public void beforeExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionCopy, IAction action) {
                    ILogChannel log = action.getLogChannel();
                    try {
                        ActionDebugLevel debugLevel;
                        if (entries.contains(actionCopy.toString()) && (debugLevel = DebugLevelUtil.getActionDebugLevel(entryLevelMap, actionCopy.toString())) != null) {
                            log.setLogLevel(debugLevel.getLogLevel());
                            workflow.setLogLevel(debugLevel.getLogLevel());
                        }
                    }
                    catch (Exception e) {
                        log.logError("Error setting logging level on action");
                    }
                }

                public void afterExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionCopy, IAction action, Result result) {
                    ILogChannel log = action.getLogChannel();
                    try {
                        ActionDebugLevel debugLevel;
                        if (entries.contains(actionCopy.toString()) && (debugLevel = DebugLevelUtil.getActionDebugLevel(entryLevelMap, actionCopy.toString())) != null) {
                            log.setLogLevel(jobLogLevel);
                            workflow.setLogLevel(jobLogLevel);
                            if (debugLevel.isLoggingResult()) {
                                log.logMinimal("Action results: ");
                                log.logMinimal("  - result=" + result.isResult());
                                log.logMinimal("  - stopped=" + result.isStopped());
                                log.logMinimal("  - linesRead=" + result.getNrLinesRead());
                                log.logMinimal("  - linesWritten=" + result.getNrLinesWritten());
                                log.logMinimal("  - linesInput=" + result.getNrLinesInput());
                                log.logMinimal("  - linesOutput=" + result.getNrLinesOutput());
                                log.logMinimal("  - linesRejected=" + result.getNrLinesRejected());
                                log.logMinimal("  - result row count=" + result.getRows().size());
                                log.logMinimal("  - result files count=" + result.getResultFilesList().size());
                            }
                            if (debugLevel.isLoggingResultRows()) {
                                log.logMinimal("Action result rows: ");
                                for (RowMetaAndData rmad : result.getRows()) {
                                    log.logMinimal(" - " + rmad.toString());
                                }
                            }
                            if (debugLevel.isLoggingResultFiles()) {
                                log.logMinimal("Action result files: ");
                                for (ResultFile resultFile : result.getResultFilesList()) {
                                    log.logMinimal(" - " + resultFile.getFile().toString() + " from " + resultFile.getOrigin() + " : " + resultFile.getComment() + " / " + resultFile.getTypeCode());
                                }
                            }
                            if (debugLevel.isLoggingVariables() && action instanceof IVariables) {
                                log.logMinimal("Action notable variables: ");
                                IAction variables = action;
                                for (String var : variables.getVariableNames()) {
                                    if (variablesToIgnore.contains(var)) continue;
                                    String value = variables.getVariable(var);
                                    String refValue = referenceSpace.getVariable(var);
                                    if (refValue != null && refValue.equals(value)) continue;
                                    log.logMinimal(" - " + var + "=" + value);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        log.logError("Error re-setting logging level on action");
                    }
                }
            });
        }
        catch (Exception e) {
            jobLog.logError("Unable to handle specific debug level for workflow", (Throwable)e);
        }
    }
}

