/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;

public class StringUtil {
    private static final Random random = new Random();
    public static final String UNIX_OPEN = "${";
    public static final String UNIX_CLOSE = "}";
    public static final String WINDOWS_OPEN = "%%";
    public static final String WINDOWS_CLOSE = "%%";
    public static final String HEX_OPEN = "$[";
    public static final String HEX_CLOSE = "]";
    public static final String FIELD_OPEN = "?{";
    public static final String FIELD_CLOSE = "}";
    public static final String RESOLVER_OPEN = "#{";
    public static final String RESOLVER_CLOSE = "}";
    public static final String CRLF = "\r\n";
    public static final String INDENTCHARS = "                    ";
    public static final String EMPTY_STRING = "";
    protected static final String[] SYSTEM_PROPERTIES = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir", "user.country", "user.language", "user.timezone", "org.apache.commons.logging.Log", "org.apache.commons.logging.simplelog.log.org.apache.http", "org.apache.commons.logging.simplelog.showdatetime", "org.eclipse.swt.browser.XULRunnerInitialized", "org.eclipse.swt.browser.XULRunnerPath", "sun.arch.data.model", "sun.boot.class.path", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level"};

    private StringUtil() {
    }

    public static String substitute(String aString, Map<String, String> variablesValues, String open, String close) {
        return StringUtil.substitute(aString, variablesValues, open, close, 0);
    }

    public static String substitute(String aString, Map<String, String> variablesValues, String open, String close, int recursion) {
        if (aString == null) {
            return null;
        }
        int i = aString.indexOf(open);
        if (i < 0) {
            return aString;
        }
        String rest = aString;
        StringBuilder buffer = new StringBuilder();
        while (i > -1) {
            int j = rest.indexOf(close, i + open.length());
            if (j > -1) {
                String varName = rest.substring(i + open.length(), j);
                Object value = variablesValues.get(varName);
                if (value == null) {
                    value = open + varName + close;
                } else {
                    int another = ((String)value).indexOf(open);
                    if (another > -1) {
                        if (recursion > 50) {
                            throw new RuntimeException("Endless loop detected for substitution of variable: " + String.valueOf(value));
                        }
                        value = StringUtil.substitute((String)value, variablesValues, open, close, ++recursion);
                    }
                }
                buffer.append(rest.substring(0, i));
                buffer.append(value);
                rest = rest.substring(j + close.length());
            } else {
                buffer.append(rest);
                rest = EMPTY_STRING;
            }
            i = rest.indexOf(open);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    public static String substituteHex(String aString) {
        if (aString == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String rest = aString;
        int i = rest.indexOf(HEX_OPEN);
        while (i > -1) {
            int j = rest.indexOf(HEX_CLOSE, i + HEX_OPEN.length());
            if (j > -1) {
                buffer.append(rest.substring(0, i));
                String hexString = rest.substring(i + HEX_OPEN.length(), j);
                String[] hexStringArray = hexString.split(",");
                byte[] hexByte = new byte[1];
                for (int pos = 0; pos < hexStringArray.length; ++pos) {
                    int hexInt;
                    try {
                        hexInt = Integer.parseInt(hexStringArray[pos], 16);
                    }
                    catch (NumberFormatException e) {
                        hexInt = 0;
                    }
                    hexByte[0] = (byte)hexInt;
                    buffer.append(new String(hexByte));
                }
                rest = rest.substring(j + HEX_CLOSE.length());
            } else {
                buffer.append(rest);
                rest = EMPTY_STRING;
            }
            i = rest.indexOf(HEX_OPEN);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    public static final synchronized String environmentSubstitute(String aString, Map<String, String> systemProperties) {
        aString = StringUtil.substituteWindows(aString, systemProperties);
        aString = StringUtil.substituteUnix(aString, systemProperties);
        aString = StringUtil.substituteHex(aString);
        return aString;
    }

    public static String substituteUnix(String aString, Map<String, String> variables) {
        return StringUtil.substitute(aString, variables, UNIX_OPEN, "}");
    }

    public static String substituteWindows(String aString, Map<String, String> variables) {
        return StringUtil.substitute(aString, variables, "%%", "%%");
    }

    public static String substituteField(String aString, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (int i = 0; i < rowMeta.size(); ++i) {
            variables.put(rowMeta.getValueMeta(i).getName(), rowMeta.getString(rowData, i));
        }
        return StringUtil.substitute(aString, variables, FIELD_OPEN, "}");
    }

    public static void getUsedVariables(String aString, String open, String close, List<String> list, boolean includeSystemVariables) {
        if (aString == null) {
            return;
        }
        for (int p = 0; p < aString.length(); ++p) {
            int from;
            int to;
            if (!aString.substring(p).startsWith(open) || (to = aString.indexOf(close, (from = p + open.length()) + 1)) < 0) continue;
            String variable = aString.substring(from, to);
            if (Const.indexOfString(variable, list) < 0 && includeSystemVariables || !StringUtil.isSystemVariable(variable) || System.getProperty(variable) == null) {
                list.add(variable);
            }
            p = to + close.length();
        }
    }

    public static boolean isSystemVariable(String aString) {
        return Const.indexOfString(aString, SYSTEM_PROPERTIES) >= 0;
    }

    public static void getUsedVariables(String aString, List<String> list, boolean includeSystemVariables) {
        StringUtil.getUsedVariables(aString, UNIX_OPEN, "}", list, includeSystemVariables);
        StringUtil.getUsedVariables(aString, "%%", "%%", list, includeSystemVariables);
    }

    public static String generateRandomString(int length, String prefix, String postfix, boolean uppercase) {
        StringBuilder buffer = new StringBuilder();
        if (!Utils.isEmpty(prefix)) {
            buffer.append(prefix);
        }
        for (int i = 0; i < length; ++i) {
            int c = 97 + random.nextInt() * 26;
            buffer.append((char)c);
        }
        if (!Utils.isEmpty(postfix)) {
            buffer.append(postfix);
        }
        if (uppercase) {
            return buffer.toString().toUpperCase();
        }
        return buffer.toString();
    }

    public static String initCap(String st) {
        if (st == null || st.trim().isEmpty()) {
            return EMPTY_STRING;
        }
        if (st.substring(0, 1).equals(st.substring(0, 1).toUpperCase())) {
            return st;
        }
        return st.substring(0, 1).toUpperCase() + st.substring(1);
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static final boolean isEmpty(StringBuilder string) {
        return string == null || string.isEmpty();
    }

    public static String getIndent(int indentLevel) {
        return INDENTCHARS.substring(0, indentLevel);
    }

    public static String getFormattedDateTime(Date date) {
        return StringUtil.getFormattedDateTime(date, false);
    }

    public static String getFormattedDateTime(Date date, boolean milliseconds) {
        SimpleDateFormat dateFormat = null;
        dateFormat = milliseconds ? new SimpleDateFormat("yyyyddMM_hhmmssSSS") : new SimpleDateFormat("yyyyddMM_hhmmss");
        return dateFormat.format(date);
    }

    public static String getFormattedDateTimeNow() {
        return StringUtil.getFormattedDateTime(new Date(), false);
    }

    public static String getFormattedDateTimeNow(boolean milliseconds) {
        return StringUtil.getFormattedDateTime(new Date(), milliseconds);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isDate(String str) {
        return StringUtil.isDate(str, "yy-mm-dd");
    }

    public static boolean isDate(String str, String mask) {
        try {
            SimpleDateFormat fdate = new SimpleDateFormat(mask);
            fdate.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getVariableName(String variable) {
        if ((variable = variable.trim()).startsWith(UNIX_OPEN) || variable.startsWith("%%") || variable.startsWith(HEX_OPEN)) {
            variable = variable.substring(2);
        }
        if (variable.endsWith("}") || variable.endsWith(HEX_CLOSE)) {
            variable = variable.substring(0, variable.length() - 1);
        }
        if (variable.endsWith("%%")) {
            variable = variable.substring(0, variable.length() - 2);
        }
        return variable;
    }

    public static boolean isVariable(String variable) {
        if (variable == null) {
            return false;
        }
        return (variable = variable.trim()).startsWith(UNIX_OPEN) && variable.endsWith("}") || variable.startsWith("%%") && variable.endsWith("%%") || variable.startsWith(HEX_OPEN) && variable.endsWith(HEX_CLOSE);
    }

    public static String safeToLowerCase(Object obj) {
        if (obj == null || obj.toString() == null) {
            return null;
        }
        return obj.toString().toLowerCase();
    }

    public static String trimStart(String source, char c) {
        int index;
        if (source == null) {
            return null;
        }
        int length = source.length();
        for (index = 0; index < length && source.charAt(index) == c; ++index) {
        }
        return source.substring(index);
    }

    public static String trimEnd(String source, char c) {
        int index;
        if (source == null) {
            return null;
        }
        for (index = source.length(); index > 0 && source.charAt(index - 1) == c; --index) {
        }
        return source.substring(0, index);
    }

    public static String removeDiacriticalMarks(String source) {
        return Normalizer.normalize(source, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", EMPTY_STRING);
    }
}

