/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection;

import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;

public class DefaultInjectionTypeConverter
extends InjectionTypeConverter {
    @Override
    public String string2string(String v) {
        return v;
    }

    @Override
    public int string2intPrimitive(String v) {
        return Integer.parseInt(v);
    }

    @Override
    public Integer string2integer(String v) {
        return v == null ? null : Integer.valueOf(this.string2intPrimitive(v));
    }

    @Override
    public long string2longPrimitive(String v) {
        return Long.parseLong(v);
    }

    @Override
    public Long string2long(String v) {
        return v == null ? null : Long.valueOf(this.string2longPrimitive(v));
    }

    @Override
    public boolean string2booleanPrimitive(String v) {
        return "Y".equalsIgnoreCase(v) || "Yes".equalsIgnoreCase(v) || "true".equalsIgnoreCase(v) || "1".equals(v);
    }

    @Override
    public Boolean string2boolean(String v) {
        return v == null ? null : Boolean.valueOf(this.string2booleanPrimitive(v));
    }

    @Override
    public Enum<?> string2enum(Class<?> enumClass, String v) throws HopValueException {
        if (v == null) {
            return null;
        }
        for (Object eo : enumClass.getEnumConstants()) {
            IEnumHasCodeAndDescription hasDescription;
            IEnumHasCode hasCode;
            Enum e = (Enum)eo;
            if (e.name().equals(v)) {
                return e;
            }
            if (eo instanceof IEnumHasCode && (hasCode = (IEnumHasCode)eo).getCode().equalsIgnoreCase(v)) {
                return e;
            }
            if (!(eo instanceof IEnumHasCodeAndDescription) || !(hasDescription = (IEnumHasCodeAndDescription)eo).getCode().equalsIgnoreCase(v)) continue;
            return e;
        }
        throw new HopValueException("Unknown value " + v + " for enum " + String.valueOf(enumClass));
    }

    @Override
    public String boolean2string(Boolean v) throws HopValueException {
        if (v == null) {
            return null;
        }
        return v != false ? "Y" : "N";
    }

    @Override
    public int boolean2intPrimitive(Boolean v) throws HopValueException {
        return Boolean.TRUE.equals(v) ? 1 : 0;
    }

    @Override
    public Integer boolean2integer(Boolean v) throws HopValueException {
        return v == null ? null : Integer.valueOf(this.boolean2intPrimitive(v));
    }

    @Override
    public long boolean2longPrimitive(Boolean v) throws HopValueException {
        return Boolean.TRUE.equals(v) ? 1L : 0L;
    }

    @Override
    public Long boolean2long(Boolean v) throws HopValueException {
        return v == null ? null : Long.valueOf(this.boolean2longPrimitive(v));
    }

    @Override
    public boolean boolean2booleanPrimitive(Boolean v) throws HopValueException {
        return v;
    }

    @Override
    public Boolean boolean2boolean(Boolean v) throws HopValueException {
        return v;
    }

    @Override
    public String integer2string(Long v) throws HopValueException {
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    @Override
    public int integer2intPrimitive(Long v) throws HopValueException {
        return v.intValue();
    }

    @Override
    public Integer integer2integer(Long v) throws HopValueException {
        return v == null ? null : Integer.valueOf(this.integer2intPrimitive(v));
    }

    @Override
    public long integer2longPrimitive(Long v) throws HopValueException {
        return v;
    }

    @Override
    public Long integer2long(Long v) throws HopValueException {
        return v == null ? null : Long.valueOf(this.integer2longPrimitive(v));
    }

    @Override
    public boolean integer2booleanPrimitive(Long v) throws HopValueException {
        return v != 0L;
    }

    @Override
    public Boolean integer2boolean(Long v) throws HopValueException {
        return v == null ? null : Boolean.valueOf(this.integer2booleanPrimitive(v));
    }

    @Override
    public String number2string(Double v) throws HopValueException {
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    @Override
    public int number2intPrimitive(Double v) throws HopValueException {
        return Math.round(v.floatValue());
    }

    @Override
    public Integer number2integer(Double v) throws HopValueException {
        return v == null ? null : Integer.valueOf(this.number2intPrimitive(v));
    }

    @Override
    public long number2longPrimitive(Double v) throws HopValueException {
        return Math.round(v);
    }

    @Override
    public Long number2long(Double v) throws HopValueException {
        return v == null ? null : Long.valueOf(this.number2longPrimitive(v));
    }

    @Override
    public boolean number2booleanPrimitive(Double v) throws HopValueException {
        return this.number2intPrimitive(v) != 0;
    }

    @Override
    public Boolean number2boolean(Double v) throws HopValueException {
        return v == null ? null : Boolean.valueOf(this.number2booleanPrimitive(v));
    }
}

