/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueMetaAndData;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.w3c.dom.Node;

public class Condition
implements Cloneable {
    public static final String XML_TAG = "condition";
    private static final String CONST_OR_NOT = "OR NOT";
    private static final String CONST_AND_NOT = "AND NOT";
    public static final String[] operators = new String[]{"-", "OR", "AND", "NOT", "OR NOT", "AND NOT", "XOR"};
    public static final int OPERATOR_NONE = 0;
    public static final int OPERATOR_OR = 1;
    public static final int OPERATOR_AND = 2;
    public static final int OPERATOR_NOT = 3;
    public static final int OPERATOR_OR_NOT = 4;
    public static final int OPERATOR_AND_NOT = 5;
    public static final int OPERATOR_XOR = 6;
    public static final String[] functions = new String[]{"=", "<>", "<", "<=", ">", ">=", "REGEXP", "IS NULL", "IS NOT NULL", "IN LIST", "CONTAINS", "STARTS WITH", "ENDS WITH", "LIKE", "TRUE"};
    public static final int FUNC_EQUAL = 0;
    public static final int FUNC_NOT_EQUAL = 1;
    public static final int FUNC_SMALLER = 2;
    public static final int FUNC_SMALLER_EQUAL = 3;
    public static final int FUNC_LARGER = 4;
    public static final int FUNC_LARGER_EQUAL = 5;
    public static final int FUNC_REGEXP = 6;
    public static final int FUNC_NULL = 7;
    public static final int FUNC_NOT_NULL = 8;
    public static final int FUNC_IN_LIST = 9;
    public static final int FUNC_CONTAINS = 10;
    public static final int FUNC_STARTS_WITH = 11;
    public static final int FUNC_ENDS_WITH = 12;
    public static final int FUNC_LIKE = 13;
    public static final int FUNC_TRUE = 14;
    @HopMetadataProperty(key="negated", isExcludedFromInjection=true)
    private boolean negated = false;
    @HopMetadataProperty(key="operator", storeWithCode=true, enumNameWhenNotFound="NONE", isExcludedFromInjection=true)
    private Operator operator;
    @HopMetadataProperty(key="leftvalue", isExcludedFromInjection=true)
    private String leftValueName;
    @HopMetadataProperty(key="function", storeWithCode=true, isExcludedFromInjection=true)
    private Function function;
    @HopMetadataProperty(key="rightvalue", isExcludedFromInjection=true)
    private String rightValueName;
    @HopMetadataProperty(key="value", isExcludedFromInjection=true)
    private CValue rightValue = null;
    @HopMetadataProperty(groupKey="conditions", key="condition", isExcludedFromInjection=true)
    private List<Condition> children = new ArrayList<Condition>();
    private int leftFieldIndex = -2;
    private int rightFieldIndex = -2;
    private String rightString;
    private String[] inList;

    public Condition() {
        this.operator = Operator.NONE;
        this.function = Function.EQUAL;
    }

    public Condition(String valueName, Function function, String valueName2, ValueMetaAndData exact) throws HopValueException {
        this();
        this.leftValueName = valueName;
        this.function = function;
        this.rightValueName = valueName2;
        this.rightValue = exact == null ? null : new CValue(exact);
        this.clearFieldPositions();
    }

    public Condition(Operator operator, String valueName, Function function, String valueName2, ValueMetaAndData exact) throws HopValueException {
        this();
        this.operator = operator;
        this.leftValueName = valueName;
        this.function = function;
        this.rightValueName = valueName2;
        this.rightValue = exact == null ? null : new CValue(exact);
        this.clearFieldPositions();
    }

    public Condition(boolean negated, String valueName, Function function, String valueName2, ValueMetaAndData exact) throws HopValueException {
        this(valueName, function, valueName2, exact);
        this.negated = negated;
    }

    public Condition(Condition c) {
        this();
        this.negated = c.negated;
        this.operator = c.operator;
        this.function = c.function;
        this.leftValueName = c.leftValueName;
        this.rightValueName = c.rightValueName;
        this.rightValue = c.rightValue == null ? null : new CValue(c.rightValue);
        c.children.forEach(child -> this.children.add(new Condition((Condition)child)));
    }

    public Condition clone() {
        return new Condition(this);
    }

    public String getOperatorDesc() {
        return Const.rightPad(this.operator.getCode(), 7);
    }

    public static int getOperator(String description) {
        if (description == null) {
            return 0;
        }
        for (int i = 1; i < operators.length; ++i) {
            if (!operators[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public static String[] getOperators() {
        String[] operatorCodes = new String[operators.length - 1];
        System.arraycopy(operators, 1, operatorCodes, 0, operators.length - 1);
        return operatorCodes;
    }

    public static final String[] getRealOperators() {
        return new String[]{"OR", "AND", CONST_OR_NOT, CONST_AND_NOT, "XOR"};
    }

    public String getFunctionDesc() {
        return this.function == null ? Function.EQUAL.getCode() : this.function.getCode();
    }

    public static int getFunction(String description) {
        for (int i = 1; i < functions.length; ++i) {
            if (!functions[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public String getRightValueString() {
        if (this.rightValue == null) {
            return null;
        }
        return this.rightValue.getText();
    }

    public boolean isAtomic() {
        return this.children.isEmpty();
    }

    public boolean isComposite() {
        return !this.children.isEmpty();
    }

    public void negate() {
        this.setNegated(!this.isNegated());
    }

    public boolean isEmpty() {
        return this.isAtomic() && this.leftValueName == null;
    }

    public void clearFieldPositions() {
        this.leftFieldIndex = -2;
        this.rightFieldIndex = -2;
    }

    public boolean evaluate(IRowMeta rowMeta, Object[] r) {
        boolean evaluation = false;
        try {
            if (this.isAtomic()) {
                Object field2;
                if (this.function == Function.TRUE) {
                    return !this.negated;
                }
                if (StringUtils.isNotEmpty((String)this.leftValueName)) {
                    this.leftFieldIndex = rowMeta.indexOfValue(this.leftValueName);
                }
                if (StringUtils.isNotEmpty((String)this.rightValueName)) {
                    this.rightFieldIndex = rowMeta.indexOfValue(this.rightValueName);
                    this.rightValue = null;
                }
                if (this.leftFieldIndex < 0) {
                    return false;
                }
                IValueMeta fieldMeta = rowMeta.getValueMeta(this.leftFieldIndex);
                Object field = r[this.leftFieldIndex];
                IValueMeta fieldMeta2 = this.rightValue != null ? this.rightValue.createValueMeta() : null;
                Object object = field2 = this.rightValue != null && this.rightFieldIndex == -2 ? this.rightValue.createValueData() : null;
                if (field2 == null && this.rightFieldIndex >= 0) {
                    fieldMeta2 = rowMeta.getValueMeta(this.rightFieldIndex);
                    field2 = r[this.rightFieldIndex];
                }
                switch (this.function) {
                    case EQUAL: {
                        evaluation = fieldMeta.compare(field, fieldMeta2, field2) == 0;
                        break;
                    }
                    case NOT_EQUAL: {
                        evaluation = fieldMeta.compare(field, fieldMeta2, field2) != 0;
                        break;
                    }
                    case SMALLER: {
                        if (fieldMeta.isNull(field)) {
                            evaluation = false;
                            break;
                        }
                        evaluation = fieldMeta.compare(field, fieldMeta2, field2) < 0;
                        break;
                    }
                    case SMALLER_EQUAL: {
                        if (fieldMeta.isNull(field)) {
                            evaluation = false;
                            break;
                        }
                        evaluation = fieldMeta.compare(field, fieldMeta2, field2) <= 0;
                        break;
                    }
                    case LARGER: {
                        evaluation = fieldMeta.compare(field, fieldMeta2, field2) > 0;
                        break;
                    }
                    case LARGER_EQUAL: {
                        evaluation = fieldMeta.compare(field, fieldMeta2, field2) >= 0;
                        break;
                    }
                    case REGEXP: {
                        if (fieldMeta.isNull(field) || field2 == null) {
                            evaluation = false;
                            break;
                        }
                        evaluation = Pattern.matches(fieldMeta2.getCompatibleString(field2), fieldMeta.getCompatibleString(field));
                        break;
                    }
                    case NULL: {
                        evaluation = fieldMeta.isNull(field);
                        break;
                    }
                    case NOT_NULL: {
                        evaluation = !fieldMeta.isNull(field);
                        break;
                    }
                    case IN_LIST: {
                        if (this.inList == null || this.rightFieldIndex >= 0) {
                            this.inList = Const.splitString(fieldMeta2.getString(field2), ';', true);
                            for (int i = 0; i < this.inList.length; ++i) {
                                this.inList[i] = this.inList[i] == null ? null : this.inList[i].replace("\\", "");
                            }
                            Arrays.sort(this.inList);
                        }
                        String searchString = fieldMeta.getCompatibleString(field);
                        int inIndex = -1;
                        if (searchString != null) {
                            inIndex = Arrays.binarySearch(this.inList, searchString);
                        }
                        evaluation = inIndex >= 0;
                        break;
                    }
                    case CONTAINS: {
                        evaluation = fieldMeta.getCompatibleString(field) != null && fieldMeta.getCompatibleString(field).contains(fieldMeta2.getCompatibleString(field2));
                        break;
                    }
                    case STARTS_WITH: {
                        evaluation = fieldMeta.getCompatibleString(field) != null && fieldMeta.getCompatibleString(field).startsWith(fieldMeta2.getCompatibleString(field2));
                        break;
                    }
                    case ENDS_WITH: {
                        String string = fieldMeta.getCompatibleString(field);
                        if (!Utils.isEmpty(string)) {
                            if (this.rightString == null && field2 != null) {
                                this.rightString = fieldMeta2.getCompatibleString(field2);
                            }
                            if (this.rightString != null) {
                                evaluation = string.endsWith(fieldMeta2.getCompatibleString(field2));
                                break;
                            }
                            evaluation = false;
                            break;
                        }
                        evaluation = false;
                        break;
                    }
                    case LIKE: {
                        if (fieldMeta.isNull(field) || field2 == null) {
                            evaluation = false;
                            break;
                        }
                        String regex = fieldMeta2.getCompatibleString(field2);
                        regex = regex.replace("%", ".*");
                        regex = regex.replace("?", ".");
                        evaluation = Pattern.matches(regex, fieldMeta.getCompatibleString(field));
                        break;
                    }
                }
                if (this.isNegated()) {
                    evaluation = !evaluation;
                }
            } else {
                Condition cb0 = this.children.get(0);
                evaluation = cb0.evaluate(rowMeta, r);
                block26: for (int i = 1; i < this.children.size(); ++i) {
                    Condition cb = this.children.get(i);
                    switch (cb.getOperator()) {
                        case OR: {
                            evaluation = evaluation || cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case AND: {
                            evaluation = evaluation && cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case OR_NOT: {
                            evaluation = evaluation || !cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case AND_NOT: {
                            evaluation = evaluation && !cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case XOR: {
                            evaluation ^= cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                    }
                }
                if (this.isNegated()) {
                    evaluation = !evaluation;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error evaluation condition [" + String.valueOf(this) + "]", e);
        }
        return evaluation;
    }

    public void addCondition(Condition cb) {
        if (this.isAtomic() && this.getLeftValueName() != null) {
            Condition current = new Condition(this);
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.children.add(current);
        } else if (this.isComposite() && cb.getOperator() == Operator.NONE) {
            cb.setOperator(Operator.AND);
        }
        this.children.add(cb);
    }

    public void addCondition(int idx, Condition cb) {
        if (this.isAtomic() && this.getLeftValueName() != null) {
            Condition current = new Condition(this);
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.children.add(current);
        } else if (this.isComposite() && idx > 0 && cb.getOperator() == Operator.NONE) {
            cb.setOperator(Operator.AND);
        }
        this.children.add(idx, cb);
    }

    public void removeCondition(int nr) {
        if (this.isComposite()) {
            boolean moveUp;
            Condition c = this.children.get(nr);
            this.children.remove(nr);
            boolean bl = moveUp = this.isAtomic() || this.nrConditions() == 1;
            if (this.nrConditions() == 1) {
                c = this.getCondition(0);
            }
            if (moveUp) {
                this.setLeftValueName(c.getLeftValueName());
                this.setFunction(c.getFunction());
                this.setRightValueName(c.getRightValueName());
                this.setRightValue(c.getRightValue());
                this.setNegated(this.isNegated() ^ c.isNegated());
            }
        }
    }

    public boolean simplify() {
        Condition condition;
        if (this.nrConditions() == 1 && (condition = this.getCondition(0)).isAtomic()) {
            return this.simplify(condition, this);
        }
        boolean changed = false;
        for (int i = 0; i < this.nrConditions(); ++i) {
            Condition condition2 = this.getCondition(i);
            changed |= condition2.simplify();
            if (i != 0) continue;
            condition2.setOperator(Operator.NONE);
        }
        return changed;
    }

    private boolean simplify(Condition condition, Condition parent) {
        if (condition.isAtomic() && parent.nrConditions() == 1) {
            parent.setLeftValueName(condition.getLeftValueName());
            parent.setFunction(condition.getFunction());
            parent.setRightValueName(condition.getRightValueName());
            parent.setRightValue(condition.getRightValue());
            parent.setNegated(condition.isNegated() ^ parent.isNegated());
            parent.children.clear();
            return true;
        }
        return false;
    }

    public int nrConditions() {
        return this.children.size();
    }

    public Condition getCondition(int i) {
        return this.children.get(i);
    }

    public void setCondition(int i, Condition subCondition) {
        this.children.set(i, subCondition);
    }

    public String toString() {
        return this.toString(0, true, true);
    }

    public String toString(int level, boolean showNegate, boolean showOperator) {
        StringBuilder retval = new StringBuilder();
        if (this.isAtomic()) {
            for (int i = 0; i < level; ++i) {
                retval.append("  ");
            }
            if (showOperator && this.getOperator() != Operator.NONE) {
                retval.append(this.getOperatorDesc());
                retval.append(" ");
            } else {
                retval.append("        ");
            }
            if (this.isNegated() && (showNegate || level > 0)) {
                retval.append("NOT ( ");
            } else {
                retval.append("      ");
            }
            if (this.function == Function.TRUE) {
                retval.append(" TRUE");
            } else {
                retval.append(this.leftValueName + " " + this.getFunctionDesc());
                if (this.function != Function.NULL && this.function != Function.NOT_NULL) {
                    if (this.rightValueName != null) {
                        retval.append(" ");
                        retval.append(this.rightValueName);
                    } else {
                        retval.append(" [" + (this.getRightValueString() == null ? "" : this.getRightValueString()) + "]");
                    }
                }
            }
            if (this.isNegated() && (showNegate || level > 0)) {
                retval.append(" )");
            }
            retval.append(Const.CR);
        } else {
            int i;
            if (this.isNegated() && (showNegate || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval.append("  ");
                }
                retval.append("NOT");
                retval.append(Const.CR);
            }
            if (this.getOperator() != Operator.NONE && (showOperator || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval.append("  ");
                }
                retval.append(this.getOperatorDesc());
                retval.append(Const.CR);
            }
            for (i = 0; i < level; ++i) {
                retval.append("  ");
            }
            retval.append("(" + Const.CR);
            for (i = 0; i < this.children.size(); ++i) {
                Condition cb = this.children.get(i);
                retval.append(cb.toString(level + 1, true, i > 0));
            }
            for (i = 0; i < level; ++i) {
                retval.append("  ");
            }
            retval.append(")");
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String getXml() throws HopValueException {
        try {
            return XmlHandler.openTag(XML_TAG) + XmlMetadataUtil.serializeObjectToXml(this) + XmlHandler.closeTag(XML_TAG);
        }
        catch (Exception e) {
            throw new HopValueException("Error serializing Condition to XML", e);
        }
    }

    public Condition(String xml) throws HopXmlException {
        this(XmlHandler.loadXmlString(xml, XML_TAG));
    }

    public Condition(Node conditionNode) throws HopXmlException {
        this();
        XmlMetadataUtil.deSerializeFromXml(conditionNode, Condition.class, this, null);
    }

    public String[] getUsedFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        this.getUsedFields(fields);
        return fields.keySet().toArray(new String[0]);
    }

    public void getUsedFields(Map<String, String> fields) {
        if (this.isAtomic()) {
            if (this.getLeftValueName() != null) {
                fields.put(this.getLeftValueName(), "-");
            }
            if (this.getRightValueName() != null) {
                fields.put(this.getRightValueName(), "-");
            }
        } else {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition subc = this.getCondition(i);
                subc.getUsedFields(fields);
            }
        }
    }

    @Generated
    public boolean isNegated() {
        return this.negated;
    }

    @Generated
    public Operator getOperator() {
        return this.operator;
    }

    @Generated
    public String getLeftValueName() {
        return this.leftValueName;
    }

    @Generated
    public Function getFunction() {
        return this.function;
    }

    @Generated
    public String getRightValueName() {
        return this.rightValueName;
    }

    @Generated
    public CValue getRightValue() {
        return this.rightValue;
    }

    @Generated
    public List<Condition> getChildren() {
        return this.children;
    }

    @Generated
    public int getLeftFieldIndex() {
        return this.leftFieldIndex;
    }

    @Generated
    public int getRightFieldIndex() {
        return this.rightFieldIndex;
    }

    @Generated
    public String getRightString() {
        return this.rightString;
    }

    @Generated
    public String[] getInList() {
        return this.inList;
    }

    @Generated
    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    @Generated
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Generated
    public void setLeftValueName(String leftValueName) {
        this.leftValueName = leftValueName;
    }

    @Generated
    public void setFunction(Function function) {
        this.function = function;
    }

    @Generated
    public void setRightValueName(String rightValueName) {
        this.rightValueName = rightValueName;
    }

    @Generated
    public void setRightValue(CValue rightValue) {
        this.rightValue = rightValue;
    }

    @Generated
    public void setChildren(List<Condition> children) {
        this.children = children;
    }

    @Generated
    public void setLeftFieldIndex(int leftFieldIndex) {
        this.leftFieldIndex = leftFieldIndex;
    }

    @Generated
    public void setRightFieldIndex(int rightFieldIndex) {
        this.rightFieldIndex = rightFieldIndex;
    }

    @Generated
    public void setRightString(String rightString) {
        this.rightString = rightString;
    }

    @Generated
    public void setInList(String[] inList) {
        this.inList = inList;
    }

    public static enum Operator implements IEnumHasCode
    {
        NONE("-", 0),
        OR("OR", 1),
        AND("AND", 2),
        NOT("NOT", 3),
        OR_NOT("OR NOT", 4),
        AND_NOT("AND NOT", 5),
        XOR("XOR", 6);

        private final String code;
        private final int type;

        private Operator(String code, int type) {
            this.code = code;
            this.type = type;
        }

        public static Operator lookupType(int type) {
            for (Operator value : Operator.values()) {
                if (value.getType() != type) continue;
                return value;
            }
            return null;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        public int getType() {
            return this.type;
        }
    }

    public static final class CValue {
        @HopMetadataProperty(key="name", isExcludedFromInjection=true)
        private String name;
        @HopMetadataProperty(key="type", isExcludedFromInjection=true)
        private String type;
        @HopMetadataProperty(key="text", isExcludedFromInjection=true)
        private String text;
        @HopMetadataProperty(key="length", isExcludedFromInjection=true)
        private int length;
        @HopMetadataProperty(key="precision", isExcludedFromInjection=true)
        private int precision;
        @HopMetadataProperty(key="isnull", isExcludedFromInjection=true)
        private boolean nullValue;
        @HopMetadataProperty(key="mask", isExcludedFromInjection=true)
        private String mask;

        public CValue() {
        }

        public CValue(CValue c) {
            this.name = c.name;
            this.type = c.type;
            this.text = c.text;
            this.length = c.length;
            this.precision = c.precision;
            this.nullValue = c.nullValue;
            this.mask = c.mask;
        }

        public CValue(ValueMetaAndData v) throws HopValueException {
            if (v == null) {
                return;
            }
            IValueMeta valueMeta = v.getValueMeta();
            Object valueData = v.getValueData();
            this.nullValue = valueMeta.isNull(valueData);
            this.text = valueMeta.getString(valueData);
            this.name = valueMeta.getName();
            this.type = valueMeta.getTypeDesc();
            this.length = valueMeta.getLength();
            this.precision = valueMeta.getPrecision();
            this.mask = valueMeta.getConversionMask();
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta(this.type);
        }

        public IValueMeta createValueMeta() throws HopPluginException {
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta(this.name, this.getHopType());
            valueMeta.setLength(this.length, this.precision);
            valueMeta.setConversionMask(this.mask);
            valueMeta.setDecimalSymbol(String.valueOf(Const.DEFAULT_DECIMAL_SEPARATOR));
            valueMeta.setGroupingSymbol(null);
            valueMeta.setCurrencySymbol(null);
            return valueMeta;
        }

        public Object createValueData() throws HopException {
            if (this.isNullValue()) {
                return null;
            }
            IValueMeta valueMeta = this.createValueMeta();
            ValueMetaAndData val = new ValueMetaAndData(valueMeta.getName(), (Object)this.text);
            val.setValueMeta(valueMeta);
            ValueMetaString stringValueMeta = new ValueMetaString(valueMeta.getName());
            stringValueMeta.setConversionMetadata(valueMeta);
            return stringValueMeta.convertDataUsingConversionMetaData(val.getValueData());
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public int getPrecision() {
            return this.precision;
        }

        @Generated
        public boolean isNullValue() {
            return this.nullValue;
        }

        @Generated
        public String getMask() {
            return this.mask;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @Generated
        public void setLength(int length) {
            this.length = length;
        }

        @Generated
        public void setPrecision(int precision) {
            this.precision = precision;
        }

        @Generated
        public void setNullValue(boolean nullValue) {
            this.nullValue = nullValue;
        }

        @Generated
        public void setMask(String mask) {
            this.mask = mask;
        }
    }

    public static enum Function implements IEnumHasCodeAndDescription
    {
        EQUAL("=", 0),
        NOT_EQUAL("<>", 1),
        SMALLER("<", 2),
        SMALLER_EQUAL("<=", 3),
        LARGER(">", 4),
        LARGER_EQUAL(">=", 5),
        REGEXP("REGEXP", 6),
        NULL("IS NULL", 7),
        NOT_NULL("IS NOT NULL", 8),
        IN_LIST("IN LIST", 9),
        CONTAINS("CONTAINS", 10),
        STARTS_WITH("STARTS WITH", 11),
        ENDS_WITH("ENDS WITH", 12),
        LIKE("LIKE", 13),
        TRUE("TRUE", 14);

        private final String code;
        private final String description;
        private final int type;

        private Function(String code, int type) {
            this.code = code;
            this.description = code;
            this.type = type;
        }

        public static Function lookupType(int type) {
            for (Function value : Function.values()) {
                if (value.getType() != type) continue;
                return value;
            }
            return null;
        }

        public static Function lookupCode(String code) {
            for (Function value : Function.values()) {
                if (!value.getCode().equalsIgnoreCase(code)) continue;
                return value;
            }
            return null;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public int getType() {
            return this.type;
        }
    }
}

