/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.DateValueMap;
import com.ibm.as400.resource.IntegerValueMap;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.QualifiedValueMap;
import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SubstringValueMap;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;

public class RJobLog
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final byte[] NEWEST;
    public static final String NEXT = "*NEXT";
    public static final byte[] OLDEST;
    public static final String PREVIOUS = "*PRV";
    private static final String PRESENTATION_KEY_ = "JOB_LOG";
    private static final String ICON_BASE_NAME_ = "RJobLog";
    private static PresentationLoader presentationLoader_;
    private static ResourceMetaDataTable selections_;
    private static ProgramMap selectionMap_;
    public static final String LIST_DIRECTION = "LIST_DIRECTION";
    public static final String STARTING_MESSAGE_KEY = "STARTING_MESSAGE_KEY";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyoljbl";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RJobLog";
    private static ProgramCallDocument staticDocument_;
    private static final String DEFAULT_MESSAGE_FILE_ = "/QSYS.LIB/QCPFMSG.MSGF";
    private static final byte[] EMPTY_BYTES_;
    private static final byte[] BLANK_INTERNAL_JOB_ID_;
    private byte[] internalJobID_ = null;
    private String name_ = "*";
    private String number_ = "";
    private String user_ = "";

    public RJobLog() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RQueuedMessage.attributes_, selections_, null, openListProgramName_, null, selectionMap_);
        this.updatePresentation();
    }

    public RJobLog(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RJobLog(AS400 system, String name, String user, String number) {
        this();
        try {
            this.setSystem(system);
            this.setName(name);
            this.setUser(user);
            this.setNumber(number);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RJobLog(AS400 system, byte[] internalJobID) {
        this();
        try {
            this.setSystem(system);
            this.setName("*INT");
            this.setInternalJobID(internalJobID);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        ProgramCallDocument document;
        block7: {
            if (this.internalJobID_ == null && !this.name_.equals("*")) {
                if (this.number_.length() == 0) {
                    throw new ExtendedIllegalStateException("number", 4);
                }
                if (this.user_.length() == 0) {
                    throw new ExtendedIllegalStateException("user", 4);
                }
            }
            super.establishConnection();
            document = (ProgramCallDocument)staticDocument_.clone();
            try {
                if (this.internalJobID_ != null) {
                    document.setValue("qgyoljbl.messageSelectionInformation.internalJobIdentifier", this.internalJobID_);
                    document.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.jobName", "*INT");
                } else {
                    document.setValue("qgyoljbl.messageSelectionInformation.internalJobIdentifier", BLANK_INTERNAL_JOB_ID_);
                    document.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.jobName", this.name_.toUpperCase());
                    document.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.jobNumber", this.number_.toUpperCase());
                    document.setValue("qgyoljbl.messageSelectionInformation.qualifiedJobName.userName", this.user_.toUpperCase());
                }
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block7;
                Trace.log(2, "Error setting path information in PCML document", (Throwable)e);
            }
        }
        this.setDocument(document);
    }

    public byte[] getInternalJobID() {
        return this.internalJobID_;
    }

    public String getName() {
        return this.name_;
    }

    public String getNumber() {
        return this.number_;
    }

    public String getUser() {
        return this.user_;
    }

    public void setInternalJobID(byte[] internalJobID) throws PropertyVetoException {
        if (internalJobID == null) {
            throw new NullPointerException("internalJobID");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        byte[] oldValue = this.internalJobID_;
        this.fireVetoableChange("internalJobID", oldValue, internalJobID);
        this.internalJobID_ = internalJobID;
        this.updatePresentation();
        this.firePropertyChange("internalJobID", oldValue, internalJobID);
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.name_;
        this.fireVetoableChange("name", oldValue, name);
        this.name_ = name;
        this.updatePresentation();
        this.firePropertyChange("name", oldValue, name);
    }

    public void setNumber(String number) throws PropertyVetoException {
        if (number == null) {
            throw new NullPointerException("number");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.number_;
        this.fireVetoableChange("number", oldValue, number);
        this.number_ = number;
        this.updatePresentation();
        this.firePropertyChange("number", oldValue, number);
    }

    public void setUser(String user) throws PropertyVetoException {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.user_;
        this.fireVetoableChange("user", oldValue, user);
        this.user_ = user;
        this.updatePresentation();
        this.firePropertyChange("user", oldValue, user);
    }

    private void updatePresentation() {
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        StringBuffer fullName = new StringBuffer();
        fullName.append(this.number_);
        fullName.append('/');
        fullName.append(this.user_);
        fullName.append('/');
        fullName.append(this.name_);
        presentation.setFullName(fullName.toString());
    }

    public static void writeMessage(AS400 system, String messageID, int messageType) throws ResourceException {
        RJobLog.writeMessage(system, messageID, messageType, DEFAULT_MESSAGE_FILE_, null);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, byte[] substitutionData) throws ResourceException {
        RJobLog.writeMessage(system, messageID, messageType, DEFAULT_MESSAGE_FILE_, substitutionData);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, String messageFile) throws ResourceException {
        RJobLog.writeMessage(system, messageID, messageType, messageFile, null);
    }

    public static void writeMessage(AS400 system, String messageID, int messageType, String messageFile, byte[] substitutionData) throws ResourceException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (messageID == null) {
            throw new NullPointerException("messageID");
        }
        String messageTypeAsString = null;
        switch (messageType) {
            case 1: {
                messageTypeAsString = "*COMP";
                break;
            }
            case 2: {
                messageTypeAsString = "*DIAG";
                break;
            }
            case 4: {
                messageTypeAsString = "*INFO";
                break;
            }
            case 15: {
                messageTypeAsString = "*ESCAPE";
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("messageType", 2);
            }
        }
        if (messageFile == null) {
            throw new NullPointerException("messageFile");
        }
        if (messageFile.length() == 0) {
            throw new ExtendedIllegalArgumentException("messageFile", 2);
        }
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(system);
            document.setValue("qmhsndpm.messageID", messageID);
            QSYSObjectPathName messageFilePathName = new QSYSObjectPathName(messageFile);
            document.setValue("qmhsndpm.qualifiedMessageFileName.objectName", messageFilePathName.getObjectName());
            document.setValue("qmhsndpm.qualifiedMessageFileName.libraryName", messageFilePathName.getLibraryName());
            if (substitutionData == null) {
                document.setIntValue("qmhsndpm.lengthOfMessageDataOrImmediateText", 0);
                document.setValue("qmhsndpm.messageDataOrImmediateText", "");
            } else {
                document.setIntValue("qmhsndpm.lengthOfMessageDataOrImmediateText", substitutionData.length);
                document.setValue("qmhsndpm.messageDataOrImmediateText", substitutionData);
            }
            document.setValue("qmhsndpm.messageType", messageTypeAsString);
            if (!document.callProgram("qmhsndpm")) {
                AS400Message[] messageList = document.getMessageList("qmhsndpm");
                if (messageList.length == 1 && messageList[0].getID().equals(messageID) && messageList[0].getType() == messageType) {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "False escape message ignored.");
                    }
                    return;
                }
                throw new ResourceException(messageList);
            }
        }
        catch (PcmlException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error when writing a message", (Throwable)e);
            }
            throw new ResourceException(e);
        }
    }

    @Override
    Resource newResource(String programName, int[] indices) throws PcmlException, ResourceException {
        AS400 system = this.getSystem();
        ProgramCallDocument document = this.getDocument();
        byte[] messageKey = (byte[])document.getValue(programName + ".receiverVariable.messageKey", indices);
        String jobLogName = this.toString();
        Object resourceKey = RQueuedMessage.computeResourceKey(system, jobLogName, messageKey);
        RQueuedMessage rQueuedMessage = (RQueuedMessage)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(resourceKey);
        if (rQueuedMessage == null) {
            rQueuedMessage = new RQueuedMessage();
            rQueuedMessage.setResourceKey(resourceKey);
        }
        Object[] attributeIDs = openListAttributeMap_.getIDs();
        Object[] values = openListAttributeMap_.getValues(attributeIDs, system, document, programName, indices);
        for (int i = 0; i < values.length; ++i) {
            rQueuedMessage.initializeAttributeValue(attributeIDs[i], values[i]);
        }
        StringBuffer name = new StringBuffer();
        name.append((String)rQueuedMessage.getAttributeValue("MESSAGE_ID"));
        name.append('(');
        name.append(Presentation.bytesToHex((byte[])rQueuedMessage.getAttributeValue("MESSAGE_KEY")));
        name.append(')');
        StringBuffer fullName = new StringBuffer();
        fullName.append(jobLogName);
        fullName.append('-');
        fullName.append(name.toString());
        Presentation presentation = rQueuedMessage.getPresentation();
        presentation.setName(name.toString());
        presentation.setFullName(fullName.toString());
        presentation.setValue("Description Text", rQueuedMessage.getAttributeValue("MESSAGE_TEXT"));
        presentation.setValue("Help Text", rQueuedMessage.getAttributeValue("MESSAGE_HELP"));
        return rQueuedMessage;
    }

    static {
        block2: {
            NEWEST = new byte[]{-1, -1, -1, -1};
            OLDEST = new byte[]{0, 0, 0, 0};
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selectionMap_ = new ProgramMap();
            selections_.add(LIST_DIRECTION, String.class, false, new String[]{NEXT, PREVIOUS}, NEXT, true);
            selectionMap_.add(LIST_DIRECTION, null, "messageSelectionInformation.listDirection");
            selections_.add(STARTING_MESSAGE_KEY, byte[].class, false, (Object[])new byte[][]{NEWEST, OLDEST}, OLDEST, false);
            selectionMap_.add(STARTING_MESSAGE_KEY, null, "messageSelectionInformation.startingMessageKey");
            openListAttributeMap_ = new ProgramMap();
            openListAttributeMap_.add("MESSAGE_SEVERITY", null, "receiverVariable.messageSeverity");
            openListAttributeMap_.add("MESSAGE_ID", null, "receiverVariable.messageIdentifier");
            openListAttributeMap_.add((Object)"MESSAGE_TYPE", null, "receiverVariable.messageType", new IntegerValueMap());
            openListAttributeMap_.add("MESSAGE_KEY", null, "receiverVariable.messageKey");
            openListAttributeMap_.add((Object)"MESSAGE_FILE", null, "receiverVariable.messageFile", new QualifiedValueMap(20, "MSGF"));
            openListAttributeMap_.add((Object)"DATE_SENT", null, "receiverVariable.dateAndTimeSent", new DateValueMap(13));
            openListAttributeMap_.add("MESSAGE_TEXT", null, "receiverVariable.messageWithReplacementData.data");
            openListAttributeMap_.add((Object)"SENDER_JOB_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(0, 10, true));
            openListAttributeMap_.add((Object)"SENDER_JOB_NUMBER", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(20, 6, true));
            openListAttributeMap_.add((Object)"SENDER_USER_NAME", null, "receiverVariable.qualifiedSenderJobName.data", new SubstringValueMap(10, 10, true));
            openListAttributeMap_.add("SENDING_PROGRAM_NAME", null, "receiverVariable.sendingProgramName.data");
            openListAttributeMap_.add("REPLY_STATUS", null, "receiverVariable.replyStatus.data");
            openListAttributeMap_.add("DEFAULT_REPLY", null, "receiverVariable.defaultReply.data");
            openListAttributeMap_.add("MESSAGE_HELP", null, "receiverVariable.messageHelpWithRDAndFC.data");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
        EMPTY_BYTES_ = new byte[0];
        BLANK_INTERNAL_JOB_ID_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    }
}

