/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class PeriodCHMAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    long count = 0L;
    double total = 0.0;
    double totalSquares = 0.0;
    long lastTimestamp = Long.MAX_VALUE;

    PeriodCHMAggregatorFactory() {
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new PeriodCHMAggregatorFactory();
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        if (threadInfo.timestamp() > this.lastTimestamp) {
            double delta = 0.001 * (double)(threadInfo.timestamp() - this.lastTimestamp);
            this.total += delta;
            this.totalSquares += delta * delta;
            ++this.count;
        }
        this.lastTimestamp = threadInfo.timestamp();
    }

    @Override
    public Object info() {
        if (this.count > 0L) {
            return this.totalSquares / this.total;
        }
        return Double.NaN;
    }
}

