/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ToolSpecifications {
    private ToolSpecifications() {
    }

    public static List<ToolSpecification> toolSpecificationsFrom(Object objectWithTools) {
        return Arrays.stream(objectWithTools.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(ToolSpecifications::toolSpecificationFrom).collect(Collectors.toList());
    }

    public static ToolSpecification toolSpecificationFrom(Method method) {
        Tool annotation = method.getAnnotation(Tool.class);
        String name = Utils.isNullOrBlank(annotation.name()) ? method.getName() : annotation.name();
        String description = String.join((CharSequence)"\n", annotation.value());
        ToolSpecification.Builder builder = ToolSpecification.builder().name(name).description(description);
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isAnnotationPresent(ToolMemoryId.class)) continue;
            builder.addParameter(parameter.getName(), ToolSpecifications.toJsonSchemaProperties(parameter));
        }
        return builder.build();
    }

    static Iterable<JsonSchemaProperty> toJsonSchemaProperties(Parameter parameter) {
        JsonSchemaProperty description;
        Class<?> type = parameter.getType();
        P annotation = parameter.getAnnotation(P.class);
        JsonSchemaProperty jsonSchemaProperty = description = annotation == null ? null : JsonSchemaProperty.description(annotation.value());
        if (type == String.class) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.STRING, description);
        }
        if (ToolSpecifications.isBoolean(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.BOOLEAN, description);
        }
        if (ToolSpecifications.isInteger(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.INTEGER, description);
        }
        if (ToolSpecifications.isNumber(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.NUMBER, description);
        }
        if (type.isArray()) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.ARRAY, ToolSpecifications.arrayTypeFrom(type.getComponentType()), description);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.ARRAY, ToolSpecifications.arrayTypeFrom(parameter.getParameterizedType()), description);
        }
        if (type.isEnum()) {
            return ToolSpecifications.removeNulls(JsonSchemaProperty.STRING, JsonSchemaProperty.enums(type), description);
        }
        return ToolSpecifications.removeNulls(JsonSchemaProperty.OBJECT, description);
    }

    private static JsonSchemaProperty arrayTypeFrom(Type type) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return ToolSpecifications.arrayTypeFrom((Class)actualTypeArguments[0]);
        }
        return JsonSchemaProperty.items(JsonSchemaProperty.OBJECT);
    }

    private static boolean isNumber(Class<?> type) {
        return type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class || type == BigDecimal.class;
    }

    private static boolean isInteger(Class<?> type) {
        return type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == BigInteger.class;
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    private static JsonSchemaProperty arrayTypeFrom(Class<?> clazz) {
        if (clazz == String.class) {
            return JsonSchemaProperty.items(JsonSchemaProperty.STRING);
        }
        if (ToolSpecifications.isBoolean(clazz)) {
            return JsonSchemaProperty.items(JsonSchemaProperty.BOOLEAN);
        }
        if (ToolSpecifications.isInteger(clazz)) {
            return JsonSchemaProperty.items(JsonSchemaProperty.INTEGER);
        }
        if (ToolSpecifications.isNumber(clazz)) {
            return JsonSchemaProperty.items(JsonSchemaProperty.NUMBER);
        }
        return JsonSchemaProperty.items(JsonSchemaProperty.OBJECT);
    }

    static Iterable<JsonSchemaProperty> removeNulls(JsonSchemaProperty ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

