/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.storage.core.EncryptionAgent;
import com.microsoft.azure.storage.core.EncryptionData;
import com.microsoft.azure.storage.core.JsonUtilities;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.core.WrappedContentKey;
import java.io.IOException;
import java.io.StringWriter;

class BlobEncryptionData
extends EncryptionData {
    private String encryptionMode;

    BlobEncryptionData() {
    }

    public String getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize() throws IOException {
        StringWriter strWriter = new StringWriter();
        try (JsonGenerator generator = Utility.getJsonGenerator(strWriter);){
            generator.writeStartObject();
            generator.writeStringField("EncryptionMode", "FullBlob");
            this.serialize(generator);
            generator.writeEndObject();
        }
        return strWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlobEncryptionData deserialize(String inputData) throws JsonProcessingException, IOException {
        BlobEncryptionData data = new BlobEncryptionData();
        try (JsonParser parser = Utility.getJsonParser(inputData);){
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                parser.nextToken();
                if (name.equals("EncryptionMode")) {
                    data.setEncryptionMode(parser.getValueAsString());
                } else if (name.equals("WrappedContentKey")) {
                    data.setWrappedContentKey(WrappedContentKey.deserialize(parser));
                } else if (name.equals("EncryptionAgent")) {
                    data.setEncryptionAgent(EncryptionAgent.deserialize(parser));
                } else if (name.equals("ContentEncryptionIV")) {
                    data.setContentEncryptionIV(parser.getBinaryValue());
                } else if (name.equals("KeyWrappingMetadata")) {
                    data.setKeyWrappingMetadata(BlobEncryptionData.deserializeKeyWrappingMetadata(parser));
                } else {
                    BlobEncryptionData.consumeJsonObject(parser);
                }
                parser.nextToken();
            }
            JsonUtilities.assertIsEndObjectJsonToken(parser);
        }
        return data;
    }
}

