/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpClientConnectionFactory;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="The HTTP client transport that supports many HTTP versions")
public class HttpClientTransportDynamic
extends AbstractConnectorHttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransportDynamic.class);
    private final List<ClientConnectionFactory.Info> clientConnectionFactoryInfos;

    public HttpClientTransportDynamic() {
        this(new ClientConnector(), HttpClientConnectionFactory.HTTP11);
    }

    public HttpClientTransportDynamic(ClientConnector connector, ClientConnectionFactory.Info ... infos) {
        super(connector);
        this.clientConnectionFactoryInfos = infos.length == 0 ? List.of(HttpClientConnectionFactory.HTTP11) : List.of(infos);
        this.clientConnectionFactoryInfos.forEach(x$0 -> this.installBean(x$0));
        this.setConnectionPoolFactory(destination -> new MultiplexConnectionPool(destination, destination.getHttpClient().getMaxConnectionsPerDestination(), 1));
    }

    @Override
    public Origin newOrigin(Request request) {
        boolean secure = HttpScheme.isSecure((String)request.getScheme());
        List<Object> matchingInfos = new ArrayList();
        List excludedProtocols = (List)request.getAttributes().get(Origin.Protocol.EXCLUDED_PROTOCOLS_ATTRIBUTE);
        List list = excludedProtocols = excludedProtocols != null ? excludedProtocols : List.of();
        if (((HttpRequest)request).isVersionExplicit()) {
            HttpVersion version = request.getVersion();
            List<String> wanted = this.toProtocols(version, secure);
            for (ClientConnectionFactory.Info info2 : this.clientConnectionFactoryInfos) {
                List protocols = info2.getProtocols(secure);
                if (protocols.isEmpty() || excludedProtocols.stream().anyMatch(protocols::contains)) continue;
                for (String p : protocols) {
                    if (!wanted.contains(p)) continue;
                    matchingInfos.add(info2);
                    break;
                }
                if (matchingInfos.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            for (ClientConnectionFactory.Info info3 : this.clientConnectionFactoryInfos) {
                List protocols = info3.getProtocols(secure);
                if (protocols.isEmpty() || excludedProtocols.stream().anyMatch(protocols::contains)) continue;
                matchingInfos.add(info3);
                if (secure) continue;
                break;
            }
        }
        if (matchingInfos.isEmpty()) {
            List available = this.clientConnectionFactoryInfos.stream().flatMap(info -> info.getProtocols(secure).stream()).toList();
            String explicit = String.valueOf(request.getVersion()).toLowerCase(Locale.ROOT);
            throw new HttpRequestException("Cannot send request, no protocol match: available %s, explicit %s, excluded %s".formatted(available, explicit, excludedProtocols), request);
        }
        ClientConnectionFactory.Info preferredInfo = (ClientConnectionFactory.Info)matchingInfos.get(0);
        if (matchingInfos.size() > 1) {
            matchingInfos = matchingInfos.stream().filter(i -> i.getTransport().equals((Object)preferredInfo.getTransport())).toList();
        }
        boolean manyProtocols = matchingInfos.size() > 1 || preferredInfo.getProtocols(secure).size() > 1;
        boolean negotiate = secure && manyProtocols;
        ArrayList<String> protocols = new ArrayList<String>();
        for (ClientConnectionFactory.Info info2 : matchingInfos) {
            protocols.addAll(info2.getProtocols(secure));
        }
        if (negotiate) {
            protocols.remove("h2c");
        }
        if (request.getTransport() == null) {
            request.transport(preferredInfo.getTransport());
        }
        return this.getHttpClient().createOrigin(request, new Origin.Protocol(protocols, negotiate));
    }

    @Override
    public Destination newDestination(Origin origin) {
        return new HttpDestination(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        ClientConnectionFactory.Info factoryInfo;
        String alpnProtocol = (String)context.get(ClientConnector.APPLICATION_PROTOCOL_CONTEXT_KEY);
        if (alpnProtocol != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ALPN protocol {}", (Object)alpnProtocol);
            }
            factoryInfo = this.findClientConnectionFactoryInfo(List.of(alpnProtocol), true).orElseThrow(() -> new IOException("Cannot create connection: no factory for negotiated protocol " + alpnProtocol));
        } else {
            HttpDestination destination = (HttpDestination)context.get(Destination.CONTEXT_KEY);
            Origin origin = destination.getOrigin();
            Origin.Protocol protocol = origin.getProtocol();
            List<String> protocols = protocol != null ? protocol.getProtocols() : List.of("http/1.1");
            boolean secure = origin.isSecure();
            factoryInfo = this.findClientConnectionFactoryInfo(protocols, secure).orElseThrow(() -> {
                if (protocol == null) {
                    return new IOException("Cannot create connection: no protocol enabled among " + String.valueOf(this.clientConnectionFactoryInfos.stream().flatMap(i -> i.getProtocols(secure).stream()).toList()));
                }
                return new IOException("Cannot create connection: no factory for protocol " + String.valueOf(protocol));
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("No ALPN protocol, using {}", (Object)factoryInfo);
            }
        }
        return factoryInfo.getClientConnectionFactory().newConnection(endPoint, context);
    }

    public void upgrade(EndPoint endPoint, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get(Destination.CONTEXT_KEY);
        Origin origin = destination.getOrigin();
        Origin.Protocol protocol = origin.getProtocol();
        List<String> protocols = protocol != null ? protocol.getProtocols() : List.of();
        ClientConnectionFactory.Info info = this.findClientConnectionFactoryInfo(protocols, origin.isSecure()).orElseThrow(() -> new IllegalStateException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " to upgrade to protocol " + String.valueOf(protocol)));
        info.upgrade(endPoint, context);
    }

    private Optional<ClientConnectionFactory.Info> findClientConnectionFactoryInfo(List<String> protocols, boolean secure) {
        return this.clientConnectionFactoryInfos.stream().filter(info -> info.matches(protocols, secure)).findFirst();
    }

    private List<String> toProtocols(HttpVersion version, boolean secure) {
        return switch (version) {
            default -> throw new IncompatibleClassChangeError();
            case HttpVersion.HTTP_0_9, HttpVersion.HTTP_1_0, HttpVersion.HTTP_1_1 -> List.of("http/1.1");
            case HttpVersion.HTTP_2 -> {
                if (secure) {
                    yield List.of("h2c", "h2");
                }
                yield List.of("h2c");
            }
            case HttpVersion.HTTP_3 -> secure ? List.of("h3") : List.of();
        };
    }
}

