/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.rest;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="restconnection", name="i18n::RestConnection.name", description="i18n::RestConnection.description", image="rest.svg", documentationUrl="/metadata-types/rest-connection.html", hopMetadataPropertyType=HopMetadataPropertyType.REST_CONNECTION)
public class RestConnection
extends HopMetadataBase
implements IHopMetadata {
    private IVariables variables;
    private ClientBuilder builder;
    private Client client;
    @HopMetadataProperty(key="base_url", injectionKey="BASE_URL")
    private String baseUrl;
    @HopMetadataProperty(key="test_url", injectionKey="TEST_URL")
    private String testUrl;
    @HopMetadataProperty(key="auth_header_name", injectionKey="AUTH_HEADER_NAME")
    private String authorizationHeaderName;
    @HopMetadataProperty(key="auth_header_prefix", injectionKey="AUTH_HEADER_PREFIX")
    private String authorizationPrefix;
    @HopMetadataProperty(key="auth_header_value", injectionKey="AUTH_HEADER_VALUE")
    private String authorizationHeaderValue;

    public RestConnection(IVariables variables) {
        this.variables = variables;
        this.builder = ClientBuilder.newBuilder();
        this.client = this.builder.build();
    }

    public String getResponse(String url) throws HopException {
        WebTarget target = this.client.target(this.testUrl);
        Invocation.Builder invocationBuilder = target.request();
        if (!StringUtils.isEmpty((String)this.variables.resolve(this.authorizationPrefix))) {
            invocationBuilder.header(this.variables.resolve(this.authorizationHeaderName), (Object)(this.variables.resolve(this.authorizationPrefix) + " " + this.variables.resolve(this.authorizationHeaderValue)));
        } else {
            invocationBuilder.header(this.variables.resolve(this.authorizationHeaderName), (Object)this.variables.resolve(this.authorizationHeaderValue));
        }
        Response response = invocationBuilder.get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new HopException("Error connecting to " + this.testUrl + ": " + response.getStatus());
        }
        return (String)response.readEntity(String.class);
    }

    public void disconnect() throws HopException {
        this.client.close();
    }

    public void testConnection() throws HopException {
        Response response;
        WebTarget target = this.client.target(this.variables.resolve(this.testUrl));
        Invocation.Builder invocationBuilder = target.request();
        if (!StringUtils.isEmpty((String)this.variables.resolve(this.authorizationHeaderName))) {
            if (!StringUtils.isEmpty((String)this.variables.resolve(this.authorizationPrefix))) {
                invocationBuilder.header(this.variables.resolve(this.authorizationHeaderName), (Object)(this.variables.resolve(this.authorizationPrefix) + " " + this.variables.resolve(this.authorizationHeaderValue)));
            } else {
                invocationBuilder.header(this.variables.resolve(this.authorizationHeaderName), (Object)this.variables.resolve(this.authorizationHeaderValue));
            }
        }
        if ((response = invocationBuilder.get()).getStatus() != Response.Status.OK.getStatusCode()) {
            throw new HopException("Error connecting to " + this.testUrl + ": " + response.getStatus());
        }
        response.close();
    }

    public RestConnection() {
    }

    public RestConnection(RestConnection connection) {
        this.baseUrl = connection.baseUrl;
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RestConnection)) {
            return false;
        }
        RestConnection connection = (RestConnection)((Object)object);
        return this.name != null && this.name.equalsIgnoreCase(connection.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public ClientBuilder getBuilder() {
        return this.builder;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getTestUrl() {
        return this.testUrl;
    }

    @Generated
    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    @Generated
    public String getAuthorizationPrefix() {
        return this.authorizationPrefix;
    }

    @Generated
    public String getAuthorizationHeaderValue() {
        return this.authorizationHeaderValue;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setBuilder(ClientBuilder builder) {
        this.builder = builder;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    @Generated
    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    @Generated
    public void setAuthorizationPrefix(String authorizationPrefix) {
        this.authorizationPrefix = authorizationPrefix;
    }

    @Generated
    public void setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
    }
}

