/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.constant;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.constant.Constant;
import org.apache.hop.pipeline.transforms.constant.ConstantData;
import org.apache.hop.pipeline.transforms.constant.ConstantField;

@Transform(id="Constant", image="constant.svg", name="i18n::AddConstants.Name", description="i18n::AddConstants.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ConstantMeta.keyword"}, documentationUrl="/pipeline/transforms/addconstant.html")
public class ConstantMeta
extends BaseTransformMeta<Constant, ConstantData> {
    private static final Class<?> PKG = ConstantMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupDescription="ConstantMeta.Injection.Fields", injectionKeyDescription="ConstantMeta.Injection.Field")
    List<ConstantField> fields = new ArrayList<ConstantField>();

    public List<ConstantField> getFields() {
        return this.fields;
    }

    public void setFields(List<ConstantField> fields) {
        this.fields = fields;
    }

    public Object clone() {
        return (ConstantMeta)((Object)super.clone());
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConstantField item = this.fields.get(i);
            if (StringUtils.isEmpty((String)item.getFieldName())) continue;
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getFieldType());
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)item.getFieldName(), (int)type);
                v.setLength(item.getFieldLength());
                v.setPrecision(item.getFieldPrecision());
                v.setOrigin(name);
                v.setConversionMask(item.getFieldFormat());
                rowMeta.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (prev != null && !prev.isEmpty()) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConstantMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ConstantMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        ConstantData data = new ConstantData();
        ConstantMeta meta = (ConstantMeta)transformMeta.getTransform();
        Constant.buildRow(meta, data, remarks);
    }
}

