/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.Role;
import java.util.Objects;

public final class ToolMessage
implements Message {
    private final Role role = Role.TOOL;
    private final String toolCallId;
    private final String content;

    private ToolMessage(Builder builder) {
        this.toolCallId = builder.toolCallId;
        this.content = builder.content;
    }

    @Override
    public Role role() {
        return this.role;
    }

    public String toolCallId() {
        return this.toolCallId;
    }

    public String content() {
        return this.content;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ToolMessage && this.equalTo((ToolMessage)another);
    }

    private boolean equalTo(ToolMessage another) {
        return Objects.equals((Object)this.role, (Object)another.role) && Objects.equals(this.toolCallId, another.toolCallId) && Objects.equals(this.content, another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode(this.toolCallId);
        h += (h << 5) + Objects.hashCode(this.content);
        return h;
    }

    public String toString() {
        return "ToolMessage{role=" + (Object)((Object)this.role) + ", toolCallId=" + this.toolCallId + ", content=" + this.content + "}";
    }

    public static ToolMessage from(String toolCallId, String content) {
        return ToolMessage.builder().toolCallId(toolCallId).content(content).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String toolCallId;
        private String content;

        private Builder() {
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public ToolMessage build() {
            return new ToolMessage(this);
        }
    }
}

