/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IValueMeta;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class ParquetValueConverter
extends PrimitiveConverter {
    private final RowMetaAndData group;
    private final IValueMeta valueMeta;
    private final int rowIndex;

    public ParquetValueConverter(RowMetaAndData group, int rowIndex) {
        this.group = group;
        this.valueMeta = group.getValueMeta(rowIndex);
        this.rowIndex = rowIndex;
    }

    public void addBinary(Binary value) {
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = switch (this.valueMeta.getType()) {
            case 2 -> value.toStringUsingUTF8();
            case 8 -> value.getBytes();
            case 6 -> {
                try {
                    yield new BigDecimal(value.toStringUsingUTF8());
                }
                catch (NumberFormatException e) {
                    yield ParquetValueConverter.binaryToDecimal(value, this.valueMeta.getLength(), this.valueMeta.getPrecision());
                }
            }
            case 9 -> {
                if (value.length() == 12) {
                    ByteBuffer bb = ByteBuffer.wrap(value.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
                    long nsDay = bb.getLong();
                    long julianDay = (long)bb.getInt() & 0xFFFFFFFFL;
                    BigInteger bns = BigInteger.valueOf(julianDay - 2440588L).multiply(BigInteger.valueOf(86400000000000L)).add(BigInteger.valueOf(nsDay));
                    BigInteger bms = bns.divide(BigInteger.valueOf(1000000L));
                    long ms = bms.longValue();
                    int nanos = (int)(ms % 1000000000L);
                    Timestamp timestamp = new Timestamp(ms);
                    timestamp.setNanos(nanos);
                    yield timestamp;
                }
            }
            default -> throw new RuntimeException("Unable to convert Binary source data to type " + this.valueMeta.getTypeDesc());
        };
    }

    public void addLong(long value) {
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = switch (this.valueMeta.getType()) {
            case 5 -> value;
            case 2 -> Long.toString(value);
            case 3 -> new Date(value);
            case 6 -> new BigDecimal(value);
            default -> throw new RuntimeException("Unable to convert Long source data to type " + this.valueMeta.getTypeDesc());
        };
    }

    public void addDouble(double value) {
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = switch (this.valueMeta.getType()) {
            case 1 -> value;
            case 2 -> Double.toString(value);
            case 6 -> BigDecimal.valueOf(value);
            default -> throw new RuntimeException("Unable to convert Double/Float source data to type " + this.valueMeta.getTypeDesc());
        };
    }

    public void addBoolean(boolean value) {
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = switch (this.valueMeta.getType()) {
            case 4 -> value;
            case 2 -> value ? "true" : "false";
            case 5 -> value ? 1L : 0L;
            default -> throw new RuntimeException("Unable to convert Boolean source data to type " + this.valueMeta.getTypeDesc());
        };
    }

    public void addFloat(float value) {
        this.addDouble(value);
    }

    public void addInt(int value) {
        this.addLong(value);
    }

    public static BigDecimal binaryToDecimal(Binary value, int precision, int scale) {
        if (precision <= 18) {
            ByteBuffer buffer = value.toByteBuffer();
            byte[] bytes = buffer.array();
            int start = buffer.arrayOffset() + buffer.position();
            int end = buffer.arrayOffset() + buffer.limit();
            long unscaled = 0L;
            for (int i = start; i < end; ++i) {
                unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
            }
            int bits = 8 * (end - start);
            long unscaledNew = unscaled << 64 - bits >> 64 - bits;
            if ((double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                return new BigDecimal(unscaledNew);
            }
            return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
        }
        return new BigDecimal(new BigInteger(value.getBytes()), scale);
    }
}

