/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.vfs.minio.MinioFileNameParser;
import org.apache.hop.vfs.minio.MinioFileSystem;
import org.apache.hop.vfs.minio.metadata.MinioMeta;

public class MinioFileProvider
extends AbstractOriginatingFileProvider {
    public static final long DEFAULT_PART_SIZE = 0x500000L;
    private static final FileSystemOptions defaultOptions = new FileSystemOptions();
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    private IVariables variables;
    private MinioMeta minioMeta;

    public static FileSystemOptions getDefaultFileSystemOptions() {
        return defaultOptions;
    }

    public MinioFileProvider() {
        this.setFileNameParser(MinioFileNameParser.getInstance());
    }

    public MinioFileProvider(IVariables variables, MinioMeta minioMeta) {
        this.variables = variables;
        this.minioMeta = minioMeta;
        this.setFileNameParser(MinioFileNameParser.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) {
        FileSystemOptions fsOptions = fileSystemOptions != null ? fileSystemOptions : MinioFileProvider.getDefaultFileSystemOptions();
        MinioFileSystem fileSystem = new MinioFileSystem(name, fsOptions);
        UserAuthenticationData authData = null;
        try {
            String region;
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fsOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            if (this.minioMeta == null || this.variables == null) {
                MinioFileSystem minioFileSystem = fileSystem;
                return minioFileSystem;
            }
            String endPointHostname = this.variables.resolve(this.minioMeta.getEndPointHostname());
            if (StringUtils.isEmpty((String)endPointHostname)) {
                LogChannel.GENERAL.logBasic("MinIO VFS: end point hostname not set. Set it in the Hop configuration or with variable HOP_MINIO_ENDPOINT_HOSTNAME");
            }
            fileSystem.setEndPointHostname(endPointHostname);
            String endPointPort = this.variables.resolve(this.minioMeta.getEndPointPort());
            fileSystem.setEndPointPort(Const.toInt((String)endPointPort, (int)9000));
            boolean endPointSecure = this.minioMeta.isEndPointSecure();
            fileSystem.setEndPointSecure(endPointSecure);
            String accessKey = this.variables.resolve(this.minioMeta.getAccessKey());
            if (StringUtils.isEmpty((String)accessKey)) {
                LogChannel.GENERAL.logBasic("MinIO VFS: no access key set. Set it in the Hop configuration or with variable HOP_MINIO_ACCESS_KEY");
            }
            fileSystem.setAccessKey(accessKey);
            String secretKey = this.variables.resolve(this.minioMeta.getSecretKey());
            fileSystem.setSecretKey(secretKey);
            if (StringUtils.isEmpty((String)secretKey)) {
                LogChannel.GENERAL.logBasic("MinIO VFS: no secret key set. Set it in the Hop configuration or with variable HOP_MINIO_SECRET_KEY");
            }
            if (StringUtils.isEmpty((String)(region = this.variables.resolve(this.minioMeta.getRegion())))) {
                LogChannel.GENERAL.logBasic("MinIO VFS: no region set. Set it in the Hop configuration or with variable HOP_MINIO_REGION");
            }
            fileSystem.setRegion(region);
            String partSize = this.variables.resolve(this.minioMeta.getRegion());
            fileSystem.setPartSize(Const.toLong((String)partSize, (long)0x500000L));
            MinioFileSystem minioFileSystem = fileSystem;
            return minioFileSystem;
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
    }

    public Collection<Capability> getCapabilities() {
        return MinioFileSystem.CAPABILITIES;
    }
}

