/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.watch;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.Time;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.RateLogger;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ServerMetrics;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.WorkerService;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.watch.IDeadWatcherListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherCleaner
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(WatcherCleaner.class);
    private final RateLogger RATE_LOGGER = new RateLogger(LOG);
    private volatile boolean stopped = false;
    private final Object cleanEvent = new Object();
    private final Object processingCompletedEvent = new Object();
    private final WorkerService cleaners;
    private final Set<Integer> deadWatchers;
    private final IDeadWatcherListener listener;
    private final int watcherCleanThreshold;
    private final int watcherCleanIntervalInSeconds;
    private final int maxInProcessingDeadWatchers;
    private final AtomicInteger totalDeadWatchers = new AtomicInteger();

    public WatcherCleaner(IDeadWatcherListener listener) {
        this(listener, Integer.getInteger("zookeeper.watcherCleanThreshold", 1000), Integer.getInteger("zookeeper.watcherCleanIntervalInSeconds", 600), Integer.getInteger("zookeeper.watcherCleanThreadsNum", 2), Integer.getInteger("zookeeper.maxInProcessingDeadWatchers", -1));
    }

    public WatcherCleaner(IDeadWatcherListener listener, int watcherCleanThreshold, int watcherCleanIntervalInSeconds, int watcherCleanThreadsNum, int maxInProcessingDeadWatchers) {
        this.listener = listener;
        this.watcherCleanThreshold = watcherCleanThreshold;
        this.watcherCleanIntervalInSeconds = watcherCleanIntervalInSeconds;
        int suggestedMaxInProcessingThreshold = watcherCleanThreshold * watcherCleanThreadsNum;
        if (maxInProcessingDeadWatchers > 0 && maxInProcessingDeadWatchers < suggestedMaxInProcessingThreshold) {
            maxInProcessingDeadWatchers = suggestedMaxInProcessingThreshold;
            LOG.info("The maxInProcessingDeadWatchers config is smaller than the suggested one, change it to use {}", (Object)maxInProcessingDeadWatchers);
        }
        this.maxInProcessingDeadWatchers = maxInProcessingDeadWatchers;
        this.deadWatchers = new HashSet<Integer>();
        this.cleaners = new WorkerService("DeadWatcherCleanner", watcherCleanThreadsNum, false);
        LOG.info("watcherCleanThreshold={}, watcherCleanIntervalInSeconds={}, watcherCleanThreadsNum={}, maxInProcessingDeadWatchers={}", new Object[]{watcherCleanThreshold, watcherCleanIntervalInSeconds, watcherCleanThreadsNum, maxInProcessingDeadWatchers});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeadWatcher(int watcherBit) {
        while (this.maxInProcessingDeadWatchers > 0 && !this.stopped && this.totalDeadWatchers.get() >= this.maxInProcessingDeadWatchers) {
            try {
                this.RATE_LOGGER.rateLimitLog("Waiting for dead watchers cleaning");
                long startTime = Time.currentElapsedTime();
                Object object = this.processingCompletedEvent;
                synchronized (object) {
                    this.processingCompletedEvent.wait(100L);
                }
                long latency = Time.currentElapsedTime() - startTime;
                ServerMetrics.getMetrics().ADD_DEAD_WATCHER_STALL_TIME.add(latency);
            }
            catch (InterruptedException e) {
                LOG.info("Got interrupted while waiting for dead watches queue size");
                break;
            }
        }
        WatcherCleaner watcherCleaner = this;
        synchronized (watcherCleaner) {
            if (this.deadWatchers.add(watcherBit)) {
                this.totalDeadWatchers.incrementAndGet();
                ServerMetrics.getMetrics().DEAD_WATCHERS_QUEUED.add(1L);
                if (this.deadWatchers.size() >= this.watcherCleanThreshold) {
                    Object object = this.cleanEvent;
                    synchronized (object) {
                        this.cleanEvent.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            Object object = this.cleanEvent;
            synchronized (object) {
                block9: {
                    try {
                        if (this.stopped || this.deadWatchers.size() >= this.watcherCleanThreshold) break block9;
                        int maxWaitMs = (this.watcherCleanIntervalInSeconds + ThreadLocalRandom.current().nextInt(this.watcherCleanIntervalInSeconds / 2 + 1)) * 1000;
                        this.cleanEvent.wait(maxWaitMs);
                    }
                    catch (InterruptedException e) {
                        LOG.info("Received InterruptedException while waiting for cleanEvent");
                        break;
                    }
                }
            }
            if (this.deadWatchers.isEmpty()) continue;
            object = this;
            synchronized (object) {
                final HashSet<Integer> snapshot = new HashSet<Integer>(this.deadWatchers);
                this.deadWatchers.clear();
                final int total = snapshot.size();
                LOG.info("Processing {} dead watchers", (Object)total);
                this.cleaners.schedule(new WorkerService.WorkRequest(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doWork() throws Exception {
                        long startTime = Time.currentElapsedTime();
                        WatcherCleaner.this.listener.processDeadWatchers(snapshot);
                        long latency = Time.currentElapsedTime() - startTime;
                        LOG.info("Takes {} to process {} watches", (Object)latency, (Object)total);
                        ServerMetrics.getMetrics().DEAD_WATCHERS_CLEANER_LATENCY.add(latency);
                        ServerMetrics.getMetrics().DEAD_WATCHERS_CLEARED.add(total);
                        WatcherCleaner.this.totalDeadWatchers.addAndGet(-total);
                        Object object = WatcherCleaner.this.processingCompletedEvent;
                        synchronized (object) {
                            WatcherCleaner.this.processingCompletedEvent.notifyAll();
                        }
                    }
                });
            }
        }
        LOG.info("WatcherCleaner thread exited");
    }

    public void shutdown() {
        this.stopped = true;
        this.deadWatchers.clear();
        this.cleaners.stop();
        this.interrupt();
        if (LOG.isInfoEnabled()) {
            LOG.info("WatcherCleaner thread shutdown is initiated");
        }
    }
}

