/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.transform.MorePartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.service.reads.ShortReadPartitionsProtection;
import org.apache.cassandra.transport.Dispatcher;

public class ShortReadProtection {
    public static UnfilteredPartitionIterator extend(Replica source, Runnable preFetchCallback, UnfilteredPartitionIterator partitions, ReadCommand command, DataLimits.Counter mergedResultCounter, Dispatcher.RequestTime requestTime, boolean enforceStrictLiveness) {
        DataLimits.Counter singleResultCounter = command.limits().newCounter(command.nowInSec(), false, command.selectsFullPartition(), enforceStrictLiveness).onlyCount();
        ShortReadPartitionsProtection protection = new ShortReadPartitionsProtection(command, source, preFetchCallback, singleResultCounter, mergedResultCounter, requestTime);
        if (!command.isLimitedToOnePartition()) {
            partitions = MorePartitions.extend(partitions, protection);
        }
        partitions = Transformation.apply(partitions, protection);
        partitions = Transformation.apply(partitions, singleResultCounter);
        return partitions;
    }
}

