/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.AbstractArrayClusteringPrefix;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;

public class ArrayClustering
extends AbstractArrayClusteringPrefix
implements Clustering<byte[]> {
    public static final long EMPTY_SIZE = ObjectSizes.measure(new ArrayClustering(EMPTY_VALUES_ARRAY));

    public ArrayClustering(byte[] ... values) {
        super(ClusteringPrefix.Kind.CLUSTERING, values);
    }

    @Override
    public long unsharedHeapSize() {
        long arrayRefSize = ObjectSizes.sizeOfArray(this.values);
        long elementsSize = 0L;
        for (int i = 0; i < ((byte[][])this.values).length; ++i) {
            elementsSize += ObjectSizes.sizeOfArray(((byte[][])this.values)[i]);
        }
        return EMPTY_SIZE + arrayRefSize + elementsSize;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.values);
    }

    public static ArrayClustering make(byte[] ... values) {
        return new ArrayClustering(values);
    }
}

