/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import org.apache.cassandra.concurrent.Shutdownable;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public interface Interruptible
extends Shutdownable {
    public void interrupt();

    public static interface SimpleTask {
        public void run() throws InterruptedException;
    }

    public static interface Task {
        public void run(State var1) throws InterruptedException;

        public static Task from(SimpleTask simpleTask) {
            return state -> {
                if (state == State.NORMAL) {
                    simpleTask.run();
                }
            };
        }
    }

    public static class TerminateException
    extends InterruptedException {
    }

    public static enum State {
        NORMAL,
        INTERRUPTED,
        SHUTTING_DOWN;

    }
}

