/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceStreamingResponseHandler;
import dev.langchain4j.service.OnCompleteOrOnError;
import dev.langchain4j.service.OnError;
import dev.langchain4j.service.OnStart;
import dev.langchain4j.service.TokenStream;
import java.util.List;
import java.util.function.Consumer;

public class AiServiceTokenStream
implements TokenStream {
    private final List<ChatMessage> messagesToSend;
    private final AiServiceContext context;
    private final Object memoryId;

    public AiServiceTokenStream(List<ChatMessage> messagesToSend, AiServiceContext context, Object memoryId) {
        this.messagesToSend = (List)ValidationUtils.ensureNotEmpty(messagesToSend, (String)"messagesToSend");
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        ValidationUtils.ensureNotNull((Object)context.streamingChatModel, (String)"streamingChatModel");
    }

    @Override
    public OnCompleteOrOnError onNext(final Consumer<String> tokenHandler) {
        return new OnCompleteOrOnError(){

            @Override
            public OnError onComplete(final Consumer<Response<AiMessage>> completionHandler) {
                return new OnError(){

                    @Override
                    public OnStart onError(Consumer<Throwable> errorHandler) {
                        return new AiServiceOnStart(tokenHandler, completionHandler, errorHandler);
                    }

                    @Override
                    public OnStart ignoreErrors() {
                        return new AiServiceOnStart(tokenHandler, completionHandler, null);
                    }
                };
            }

            @Override
            public OnStart onError(Consumer<Throwable> errorHandler) {
                return new AiServiceOnStart(tokenHandler, null, errorHandler);
            }

            @Override
            public OnStart ignoreErrors() {
                return new AiServiceOnStart(tokenHandler, null, null);
            }
        };
    }

    private class AiServiceOnStart
    implements OnStart {
        private final Consumer<String> tokenHandler;
        private final Consumer<Response<AiMessage>> completionHandler;
        private final Consumer<Throwable> errorHandler;

        private AiServiceOnStart(Consumer<String> tokenHandler, Consumer<Response<AiMessage>> completionHandler, Consumer<Throwable> errorHandler) {
            this.tokenHandler = (Consumer)ValidationUtils.ensureNotNull(tokenHandler, (String)"tokenHandler");
            this.completionHandler = completionHandler;
            this.errorHandler = errorHandler;
        }

        @Override
        public void start() {
            AiServiceStreamingResponseHandler handler = new AiServiceStreamingResponseHandler(AiServiceTokenStream.this.context, AiServiceTokenStream.this.memoryId, this.tokenHandler, this.completionHandler, this.errorHandler, new TokenUsage());
            if (((AiServiceTokenStream)AiServiceTokenStream.this).context.toolSpecifications != null) {
                ((AiServiceTokenStream)AiServiceTokenStream.this).context.streamingChatModel.generate(AiServiceTokenStream.this.messagesToSend, ((AiServiceTokenStream)AiServiceTokenStream.this).context.toolSpecifications, (StreamingResponseHandler)handler);
            } else {
                ((AiServiceTokenStream)AiServiceTokenStream.this).context.streamingChatModel.generate(AiServiceTokenStream.this.messagesToSend, (StreamingResponseHandler)handler);
            }
        }
    }
}

