/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.multimerge;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoinMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MultiMergeJoinDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MultiMergeJoinMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "MultiMergeJoinSortWarning";
    private final CCombo[] wInputTransformArray;
    private CCombo joinTypeCombo;
    private final Text[] keyValTextBox;
    private final List<String> inputFields = new ArrayList<String>();
    private IRowMeta prev;
    private ColumnInfo[] ciKeys;
    private final int margin = PropsUi.getMargin();
    private final int middle = this.props.getMiddlePct();
    private final MultiMergeJoinMeta joinMeta;

    public MultiMergeJoinDialog(Shell parent, IVariables variables, MultiMergeJoinMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.joinMeta = transformMeta;
        String[] inputTransformNames = this.getInputTransformNames();
        this.wInputTransformArray = new CCombo[inputTransformNames.length];
        this.keyValTextBox = new Text[inputTransformNames.length];
    }

    private String[] getInputTransformNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        String[] prevTransformNames = this.pipelineMeta.getPrevTransformNames(this.transformName);
        if (prevTransformNames != null) {
            for (String name : prevTransformNames) {
                String prevTransformName = name;
                if (nameList.contains(prevTransformName)) continue;
                nameList.add(prevTransformName);
            }
        }
        this.joinMeta.setInputTransforms(nameList.toArray(new String[0]));
        return nameList.toArray(new String[0]);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.joinMeta);
        ModifyListener lsMod = e -> this.joinMeta.setChanged();
        this.backupChanged = this.joinMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Shell.Label", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment((Control)this.wlTransformName, this.margin);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.createInputStreamWidgets(lsMod);
        this.createJoinTypeWidget(lsMod);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, this.margin, null);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.joinMeta.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void createJoinTypeWidget(ModifyListener lsMod) {
        Label joinTypeLabel = new Label((Composite)this.shell, 131072);
        joinTypeLabel.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Type.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)joinTypeLabel);
        FormData fdlType = new FormData();
        fdlType.left = new FormAttachment(0, 0);
        fdlType.right = new FormAttachment(this.middle, -this.margin);
        fdlType.top = this.wInputTransformArray.length > 0 ? new FormAttachment((Control)this.wInputTransformArray[this.wInputTransformArray.length - 1], this.margin * 3) : new FormAttachment((Control)this.wTransformName, this.margin * 3);
        joinTypeLabel.setLayoutData((Object)fdlType);
        this.joinTypeCombo = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.joinTypeCombo);
        this.joinTypeCombo.setItems(MultiMergeJoinMeta.joinTypes);
        this.joinTypeCombo.addModifyListener(lsMod);
        FormData fdType = new FormData();
        fdType.top = new FormAttachment((Control)joinTypeLabel, 0, 0x1000000);
        fdType.left = new FormAttachment((Control)joinTypeLabel, this.margin);
        fdType.right = new FormAttachment(60, 0);
        this.joinTypeCombo.setLayoutData((Object)fdType);
    }

    private void createInputStreamWidgets(ModifyListener lsMod) {
        String[] inputTransforms = this.getInputTransformNames();
        for (int index = 0; index < inputTransforms.length; ++index) {
            Label wlTransform = new Label((Composite)this.shell, 131072);
            wlTransform.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.InputTransform", (String[])new String[0]) + (index + 1));
            PropsUi.setLook((Widget)wlTransform);
            FormData fdlTransform = new FormData();
            fdlTransform.left = new FormAttachment(0, 0);
            fdlTransform.right = new FormAttachment(this.middle, -this.margin);
            fdlTransform.top = index == 0 ? new FormAttachment((Control)this.wTransformName, this.margin * 3) : new FormAttachment((Control)this.wInputTransformArray[index - 1], this.margin * 3);
            wlTransform.setLayoutData((Object)fdlTransform);
            this.wInputTransformArray[index] = new CCombo((Composite)this.shell, 2048);
            PropsUi.setLook((Widget)this.wInputTransformArray[index]);
            this.wInputTransformArray[index].setItems(inputTransforms);
            this.wInputTransformArray[index].addModifyListener(lsMod);
            FormData fdTransform1 = new FormData();
            fdTransform1.left = new FormAttachment((Control)wlTransform, this.margin);
            fdTransform1.top = new FormAttachment((Control)wlTransform, 0, 0x1000000);
            fdTransform1.right = new FormAttachment(60);
            this.wInputTransformArray[index].setLayoutData((Object)fdTransform1);
            Label keyLabel = new Label((Composite)this.shell, 16384);
            keyLabel.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.JoinKeys", (String[])new String[0]));
            PropsUi.setLook((Widget)keyLabel);
            FormData keyTransform = new FormData();
            keyTransform.left = new FormAttachment((Control)this.wInputTransformArray[index], this.margin * 2);
            keyTransform.top = new FormAttachment((Control)wlTransform, 0, 0x1000000);
            keyLabel.setLayoutData((Object)keyTransform);
            this.keyValTextBox[index] = new Text((Composite)this.shell, 18444);
            PropsUi.setLook((Widget)this.keyValTextBox[index]);
            this.keyValTextBox[index].setText("");
            this.keyValTextBox[index].addModifyListener(lsMod);
            FormData keyData = new FormData();
            keyData.left = new FormAttachment((Control)keyLabel, this.margin);
            keyData.top = new FormAttachment((Control)wlTransform, 0, 0x1000000);
            this.keyValTextBox[index].setLayoutData((Object)keyData);
            Button button = new Button((Composite)this.shell, 8);
            button.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.SelectKeys", (String[])new String[0]));
            button.addListener(13, (Listener)new ConfigureKeyButtonListener(this, this.keyValTextBox[index], index, lsMod));
            FormData buttonData = new FormData();
            buttonData.right = new FormAttachment(100, -this.margin);
            buttonData.top = new FormAttachment((Control)wlTransform, 0, 0x1000000);
            button.setLayoutData((Object)buttonData);
            keyData.right = new FormAttachment((Control)button, -this.margin);
        }
    }

    private void configureKeys(Text keyValTextBox, int inputStreamIndex, ModifyListener lsMod) {
        Shell subShell = new Shell(this.shell, 3312);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        subShell.setLayout((Layout)formLayout);
        subShell.setMinimumSize(300, 300);
        subShell.setSize(400, 300);
        subShell.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.JoinKeys", (String[])new String[0]));
        subShell.setImage(GuiResource.getInstance().getImageHop());
        Label wlKeys = new Label((Composite)subShell, 0);
        wlKeys.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Keys", (String[])new String[0]));
        FormData fdlKeys = new FormData();
        fdlKeys.left = new FormAttachment(0, 0);
        fdlKeys.right = new FormAttachment(50, -this.margin);
        fdlKeys.top = new FormAttachment(0, this.margin);
        wlKeys.setLayoutData((Object)fdlKeys);
        String[] keys = keyValTextBox.getText().split(",");
        int nrKeyRows = keys != null ? keys.length : 1;
        this.ciKeys = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.ColumnInfo.KeyField", (String[])new String[0]), 2, new String[]{""}, false)};
        TableView wKeys = new TableView(this.variables, (Composite)subShell, 68354, this.ciKeys, nrKeyRows, lsMod, this.props);
        FormData fdKeys = new FormData();
        fdKeys.top = new FormAttachment((Control)wlKeys, this.margin);
        fdKeys.left = new FormAttachment(0, 0);
        fdKeys.bottom = new FormAttachment(100, -70);
        fdKeys.right = new FormAttachment(100, -this.margin);
        wKeys.setLayoutData((Object)fdKeys);
        Runnable runnable = () -> {
            try {
                CCombo wInputTransform = this.wInputTransformArray[inputStreamIndex];
                String transformName = wInputTransform.getText();
                TransformMeta transformMeta = this.pipelineMeta.findTransform(transformName);
                if (transformMeta != null) {
                    this.prev = this.pipelineMeta.getTransformFields(this.variables, transformMeta);
                    if (this.prev != null) {
                        for (int i = 0; i < this.prev.size(); ++i) {
                            this.inputFields.add(this.prev.getValueMeta(i).getName());
                        }
                        this.setComboBoxes();
                        this.inputFields.clear();
                    }
                }
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
        };
        HopGui.getInstance().getDisplay().asyncExec(runnable);
        Button getKeyButton = new Button((Composite)subShell, 8);
        getKeyButton.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.KeyFields.Button", (String[])new String[0]));
        FormData fdbKeys = new FormData();
        fdbKeys.top = new FormAttachment((Control)wKeys, this.margin);
        fdbKeys.left = new FormAttachment(0, 0);
        fdbKeys.right = new FormAttachment(100, -this.margin);
        getKeyButton.setLayoutData((Object)fdbKeys);
        getKeyButton.addListener(13, e -> BaseTransformDialog.getFieldsFromPrevious((IRowMeta)this.prev, (TableView)wKeys, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null));
        Listener onOk = e -> {
            int nrKeys = wKeys.nrNonEmpty();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nrKeys; ++i) {
                TableItem item = wKeys.getNonEmpty(i);
                sb.append(item.getText(1));
                if (nrKeys <= 1 || i == nrKeys - 1) continue;
                sb.append(",");
            }
            keyValTextBox.setText(sb.toString());
            subShell.close();
        };
        Button okButton = new Button((Composite)subShell, 8);
        okButton.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        okButton.addListener(13, onOk);
        Button cancelButton = new Button((Composite)subShell, 8);
        cancelButton.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        cancelButton.addListener(13, e -> subShell.close());
        this.setButtonPositions(new Button[]{okButton, cancelButton}, this.margin, null);
        for (int i = 0; i < keys.length; ++i) {
            TableItem item = wKeys.table.getItem(i);
            if (keys[i] == null) continue;
            item.setText(1, keys[i]);
        }
        BaseDialog.defaultShellHandling((Shell)subShell, x -> onOk.handleEvent(null), x -> {});
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciKeys[0].setComboValues(fieldNames);
    }

    public void getData() {
        String[] inputTransformNames = this.joinMeta.getInputTransforms();
        if (inputTransformNames != null) {
            String[] keyFields = this.joinMeta.getKeyFields();
            for (int i = 0; i < inputTransformNames.length; ++i) {
                String inputTransformName = Const.NVL((String)inputTransformNames[i], (String)"");
                this.wInputTransformArray[i].setText(inputTransformName);
                String keyField = Const.NVL((String)(i < keyFields.length ? keyFields[i] : null), (String)"");
                this.keyValTextBox[i].setText(keyField);
            }
            String joinType = this.joinMeta.getJoinType();
            if (!Utils.isEmpty((CharSequence)joinType)) {
                this.joinTypeCombo.setText(joinType);
            } else {
                this.joinTypeCombo.setText(MultiMergeJoinMeta.joinTypes[0]);
            }
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.joinMeta.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getMeta(MultiMergeJoinMeta meta) {
        IStream stream;
        String inputTransformName;
        ITransformIOMeta transformIOMeta = meta.getTransformIOMeta();
        List infoStreams = transformIOMeta.getInfoStreams();
        ArrayList<String> inputTransformNameList = new ArrayList<String>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i = 0; i < this.wInputTransformArray.length; ++i) {
            CCombo wInputTransform = this.wInputTransformArray[i];
            inputTransformName = wInputTransform.getText();
            if (Utils.isEmpty((CharSequence)inputTransformName)) continue;
            inputTransformNameList.add(inputTransformName);
            keyList.add(this.keyValTextBox[i].getText());
            if (infoStreams.size() >= inputTransformNameList.size()) continue;
            String streamDescription = BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]);
            stream = new Stream(IStream.StreamType.INFO, null, streamDescription, StreamIcon.INFO, null);
            transformIOMeta.addStream(stream);
        }
        int inputTransformCount = inputTransformNameList.size();
        meta.allocateInputTransforms(inputTransformCount);
        meta.allocateKeys(inputTransformCount);
        String[] inputTransforms = meta.getInputTransforms();
        String[] keyFields = meta.getKeyFields();
        infoStreams = transformIOMeta.getInfoStreams();
        for (int i = 0; i < inputTransformCount; ++i) {
            inputTransforms[i] = inputTransformName = (String)inputTransformNameList.get(i);
            stream = (IStream)infoStreams.get(i);
            stream.setTransformMeta(this.pipelineMeta.findTransform(inputTransformName));
            keyFields[i] = (String)keyList.get(i);
        }
        meta.setJoinType(this.joinTypeCombo.getText());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getMeta(this.joinMeta);
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private static class ConfigureKeyButtonListener
    implements Listener {
        MultiMergeJoinDialog dialog;
        Text textBox;
        int inputStreamIndex;
        ModifyListener listener;

        public ConfigureKeyButtonListener(MultiMergeJoinDialog dialog, Text textBox, int streamIndex, ModifyListener lsMod) {
            this.dialog = dialog;
            this.textBox = textBox;
            this.listener = lsMod;
            this.inputStreamIndex = streamIndex;
        }

        public void handleEvent(Event event) {
            this.dialog.configureKeys(this.textBox, this.inputStreamIndex, this.listener);
        }
    }
}

