/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FireEventRequest
implements TBase<FireEventRequest, _Fields>,
Serializable,
Cloneable,
Comparable<FireEventRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("FireEventRequest");
    private static final TField SUCCESSFUL_FIELD_DESC = new TField("successful", 2, 1);
    private static final TField DATA_FIELD_DESC = new TField("data", 12, 2);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 3);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 4);
    private static final TField PARTITION_VALS_FIELD_DESC = new TField("partitionVals", 15, 5);
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 6);
    private static final TField TBL_PARAMS_FIELD_DESC = new TField("tblParams", 13, 7);
    private static final TField BATCH_PARTITION_VALS_FOR_REFRESH_FIELD_DESC = new TField("batchPartitionValsForRefresh", 15, 8);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new FireEventRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new FireEventRequestTupleSchemeFactory();
    private boolean successful;
    @Nullable
    private FireEventRequestData data;
    @Nullable
    private String dbName;
    @Nullable
    private String tableName;
    @Nullable
    private List<String> partitionVals;
    @Nullable
    private String catName;
    @Nullable
    private Map<String, String> tblParams;
    @Nullable
    private List<List<String>> batchPartitionValsForRefresh;
    private static final int __SUCCESSFUL_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DB_NAME, _Fields.TABLE_NAME, _Fields.PARTITION_VALS, _Fields.CAT_NAME, _Fields.TBL_PARAMS, _Fields.BATCH_PARTITION_VALS_FOR_REFRESH};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FireEventRequest() {
    }

    public FireEventRequest(boolean successful, FireEventRequestData data) {
        this();
        this.successful = successful;
        this.setSuccessfulIsSet(true);
        this.data = data;
    }

    public FireEventRequest(FireEventRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.successful = other.successful;
        if (other.isSetData()) {
            this.data = new FireEventRequestData(other.data);
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetPartitionVals()) {
            ArrayList<String> __this__partitionVals = new ArrayList<String>(other.partitionVals);
            this.partitionVals = __this__partitionVals;
        }
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
        if (other.isSetTblParams()) {
            HashMap<String, String> __this__tblParams = new HashMap<String, String>(other.tblParams);
            this.tblParams = __this__tblParams;
        }
        if (other.isSetBatchPartitionValsForRefresh()) {
            ArrayList<List<String>> __this__batchPartitionValsForRefresh = new ArrayList<List<String>>(other.batchPartitionValsForRefresh.size());
            for (List<String> other_element : other.batchPartitionValsForRefresh) {
                ArrayList<String> __this__batchPartitionValsForRefresh_copy = new ArrayList<String>(other_element);
                __this__batchPartitionValsForRefresh.add(__this__batchPartitionValsForRefresh_copy);
            }
            this.batchPartitionValsForRefresh = __this__batchPartitionValsForRefresh;
        }
    }

    public FireEventRequest deepCopy() {
        return new FireEventRequest(this);
    }

    public void clear() {
        this.setSuccessfulIsSet(false);
        this.successful = false;
        this.data = null;
        this.dbName = null;
        this.tableName = null;
        this.partitionVals = null;
        this.catName = null;
        this.tblParams = null;
        this.batchPartitionValsForRefresh = null;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
        this.setSuccessfulIsSet(true);
    }

    public void unsetSuccessful() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetSuccessful() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setSuccessfulIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public FireEventRequestData getData() {
        return this.data;
    }

    public void setData(@Nullable FireEventRequestData data) {
        this.data = data;
    }

    public void unsetData() {
        this.data = null;
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setDataIsSet(boolean value) {
        if (!value) {
            this.data = null;
        }
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nullable String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public int getPartitionValsSize() {
        return this.partitionVals == null ? 0 : this.partitionVals.size();
    }

    @Nullable
    public Iterator<String> getPartitionValsIterator() {
        return this.partitionVals == null ? null : this.partitionVals.iterator();
    }

    public void addToPartitionVals(String elem) {
        if (this.partitionVals == null) {
            this.partitionVals = new ArrayList<String>();
        }
        this.partitionVals.add(elem);
    }

    @Nullable
    public List<String> getPartitionVals() {
        return this.partitionVals;
    }

    public void setPartitionVals(@Nullable List<String> partitionVals) {
        this.partitionVals = partitionVals;
    }

    public void unsetPartitionVals() {
        this.partitionVals = null;
    }

    public boolean isSetPartitionVals() {
        return this.partitionVals != null;
    }

    public void setPartitionValsIsSet(boolean value) {
        if (!value) {
            this.partitionVals = null;
        }
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    public int getTblParamsSize() {
        return this.tblParams == null ? 0 : this.tblParams.size();
    }

    public void putToTblParams(String key, String val) {
        if (this.tblParams == null) {
            this.tblParams = new HashMap<String, String>();
        }
        this.tblParams.put(key, val);
    }

    @Nullable
    public Map<String, String> getTblParams() {
        return this.tblParams;
    }

    public void setTblParams(@Nullable Map<String, String> tblParams) {
        this.tblParams = tblParams;
    }

    public void unsetTblParams() {
        this.tblParams = null;
    }

    public boolean isSetTblParams() {
        return this.tblParams != null;
    }

    public void setTblParamsIsSet(boolean value) {
        if (!value) {
            this.tblParams = null;
        }
    }

    public int getBatchPartitionValsForRefreshSize() {
        return this.batchPartitionValsForRefresh == null ? 0 : this.batchPartitionValsForRefresh.size();
    }

    @Nullable
    public Iterator<List<String>> getBatchPartitionValsForRefreshIterator() {
        return this.batchPartitionValsForRefresh == null ? null : this.batchPartitionValsForRefresh.iterator();
    }

    public void addToBatchPartitionValsForRefresh(List<String> elem) {
        if (this.batchPartitionValsForRefresh == null) {
            this.batchPartitionValsForRefresh = new ArrayList<List<String>>();
        }
        this.batchPartitionValsForRefresh.add(elem);
    }

    @Nullable
    public List<List<String>> getBatchPartitionValsForRefresh() {
        return this.batchPartitionValsForRefresh;
    }

    public void setBatchPartitionValsForRefresh(@Nullable List<List<String>> batchPartitionValsForRefresh) {
        this.batchPartitionValsForRefresh = batchPartitionValsForRefresh;
    }

    public void unsetBatchPartitionValsForRefresh() {
        this.batchPartitionValsForRefresh = null;
    }

    public boolean isSetBatchPartitionValsForRefresh() {
        return this.batchPartitionValsForRefresh != null;
    }

    public void setBatchPartitionValsForRefreshIsSet(boolean value) {
        if (!value) {
            this.batchPartitionValsForRefresh = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field.ordinal()) {
            case 0: {
                if (value == null) {
                    this.unsetSuccessful();
                    break;
                }
                this.setSuccessful((Boolean)value);
                break;
            }
            case 1: {
                if (value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((FireEventRequestData)((Object)value));
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetPartitionVals();
                    break;
                }
                this.setPartitionVals((List)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetTblParams();
                    break;
                }
                this.setTblParams((Map)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetBatchPartitionValsForRefresh();
                    break;
                }
                this.setBatchPartitionValsForRefresh((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field.ordinal()) {
            case 0: {
                return this.isSuccessful();
            }
            case 1: {
                return this.getData();
            }
            case 2: {
                return this.getDbName();
            }
            case 3: {
                return this.getTableName();
            }
            case 4: {
                return this.getPartitionVals();
            }
            case 5: {
                return this.getCatName();
            }
            case 6: {
                return this.getTblParams();
            }
            case 7: {
                return this.getBatchPartitionValsForRefresh();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field.ordinal()) {
            case 0: {
                return this.isSetSuccessful();
            }
            case 1: {
                return this.isSetData();
            }
            case 2: {
                return this.isSetDbName();
            }
            case 3: {
                return this.isSetTableName();
            }
            case 4: {
                return this.isSetPartitionVals();
            }
            case 5: {
                return this.isSetCatName();
            }
            case 6: {
                return this.isSetTblParams();
            }
            case 7: {
                return this.isSetBatchPartitionValsForRefresh();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof FireEventRequest) {
            return this.equals((FireEventRequest)that);
        }
        return false;
    }

    public boolean equals(FireEventRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_successful = true;
        boolean that_present_successful = true;
        if (this_present_successful || that_present_successful) {
            if (!this_present_successful || !that_present_successful) {
                return false;
            }
            if (this.successful != that.successful) {
                return false;
            }
        }
        boolean this_present_data = this.isSetData();
        boolean that_present_data = that.isSetData();
        if (this_present_data || that_present_data) {
            if (!this_present_data || !that_present_data) {
                return false;
            }
            if (!this.data.equals(that.data)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_partitionVals = this.isSetPartitionVals();
        boolean that_present_partitionVals = that.isSetPartitionVals();
        if (this_present_partitionVals || that_present_partitionVals) {
            if (!this_present_partitionVals || !that_present_partitionVals) {
                return false;
            }
            if (!this.partitionVals.equals(that.partitionVals)) {
                return false;
            }
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_tblParams = this.isSetTblParams();
        boolean that_present_tblParams = that.isSetTblParams();
        if (this_present_tblParams || that_present_tblParams) {
            if (!this_present_tblParams || !that_present_tblParams) {
                return false;
            }
            if (!this.tblParams.equals(that.tblParams)) {
                return false;
            }
        }
        boolean this_present_batchPartitionValsForRefresh = this.isSetBatchPartitionValsForRefresh();
        boolean that_present_batchPartitionValsForRefresh = that.isSetBatchPartitionValsForRefresh();
        if (this_present_batchPartitionValsForRefresh || that_present_batchPartitionValsForRefresh) {
            if (!this_present_batchPartitionValsForRefresh || !that_present_batchPartitionValsForRefresh) {
                return false;
            }
            if (!this.batchPartitionValsForRefresh.equals(that.batchPartitionValsForRefresh)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.successful ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetData() ? 131071 : 524287);
        if (this.isSetData()) {
            hashCode = hashCode * 8191 + this.data.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionVals() ? 131071 : 524287);
        if (this.isSetPartitionVals()) {
            hashCode = hashCode * 8191 + this.partitionVals.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTblParams() ? 131071 : 524287);
        if (this.isSetTblParams()) {
            hashCode = hashCode * 8191 + this.tblParams.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBatchPartitionValsForRefresh() ? 131071 : 524287);
        if (this.isSetBatchPartitionValsForRefresh()) {
            hashCode = hashCode * 8191 + this.batchPartitionValsForRefresh.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(FireEventRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetSuccessful(), other.isSetSuccessful());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSuccessful() && (lastComparison = TBaseHelper.compareTo((boolean)this.successful, (boolean)other.successful)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetData(), other.isSetData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.data), (Comparable)((Object)other.data))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionVals(), other.isSetPartitionVals());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionVals() && (lastComparison = TBaseHelper.compareTo(this.partitionVals, other.partitionVals)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo((String)this.catName, (String)other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTblParams(), other.isSetTblParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTblParams() && (lastComparison = TBaseHelper.compareTo(this.tblParams, other.tblParams)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBatchPartitionValsForRefresh(), other.isSetBatchPartitionValsForRefresh());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBatchPartitionValsForRefresh() && (lastComparison = TBaseHelper.compareTo(this.batchPartitionValsForRefresh, other.batchPartitionValsForRefresh)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        FireEventRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        FireEventRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FireEventRequest(");
        boolean first = true;
        sb.append("successful:");
        sb.append(this.successful);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("data:");
        if (this.data == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.data);
        }
        first = false;
        if (this.isSetDbName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dbName:");
            if (this.dbName == null) {
                sb.append("null");
            } else {
                sb.append(this.dbName);
            }
            first = false;
        }
        if (this.isSetTableName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableName:");
            if (this.tableName == null) {
                sb.append("null");
            } else {
                sb.append(this.tableName);
            }
            first = false;
        }
        if (this.isSetPartitionVals()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partitionVals:");
            if (this.partitionVals == null) {
                sb.append("null");
            } else {
                sb.append(this.partitionVals);
            }
            first = false;
        }
        if (this.isSetCatName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (this.isSetTblParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tblParams:");
            if (this.tblParams == null) {
                sb.append("null");
            } else {
                sb.append(this.tblParams);
            }
            first = false;
        }
        if (this.isSetBatchPartitionValsForRefresh()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("batchPartitionValsForRefresh:");
            if (this.batchPartitionValsForRefresh == null) {
                sb.append("null");
            } else {
                sb.append(this.batchPartitionValsForRefresh);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetSuccessful()) {
            throw new TProtocolException("Required field 'successful' is unset! Struct:" + this.toString());
        }
        if (!this.isSetData()) {
            throw new TProtocolException("Required field 'data' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SUCCESSFUL, new FieldMetaData("successful", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.DATA, new FieldMetaData("data", 1, (FieldValueMetaData)new StructMetaData(12, FireEventRequestData.class)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARTITION_VALS, new FieldMetaData("partitionVals", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL_PARAMS, new FieldMetaData("tblParams", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.BATCH_PARTITION_VALS_FOR_REFRESH, new FieldMetaData("batchPartitionValsForRefresh", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11)))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FireEventRequest.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SUCCESSFUL(1, "successful"),
        DATA(2, "data"),
        DB_NAME(3, "dbName"),
        TABLE_NAME(4, "tableName"),
        PARTITION_VALS(5, "partitionVals"),
        CAT_NAME(6, "catName"),
        TBL_PARAMS(7, "tblParams"),
        BATCH_PARTITION_VALS_FOR_REFRESH(8, "batchPartitionValsForRefresh");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SUCCESSFUL;
                }
                case 2: {
                    return DATA;
                }
                case 3: {
                    return DB_NAME;
                }
                case 4: {
                    return TABLE_NAME;
                }
                case 5: {
                    return PARTITION_VALS;
                }
                case 6: {
                    return CAT_NAME;
                }
                case 7: {
                    return TBL_PARAMS;
                }
                case 8: {
                    return BATCH_PARTITION_VALS_FOR_REFRESH;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class FireEventRequestStandardSchemeFactory
    implements SchemeFactory {
        private FireEventRequestStandardSchemeFactory() {
        }

        public FireEventRequestStandardScheme getScheme() {
            return new FireEventRequestStandardScheme();
        }
    }

    private static class FireEventRequestTupleSchemeFactory
    implements SchemeFactory {
        private FireEventRequestTupleSchemeFactory() {
        }

        public FireEventRequestTupleScheme getScheme() {
            return new FireEventRequestTupleScheme();
        }
    }

    private static class FireEventRequestTupleScheme
    extends TupleScheme<FireEventRequest> {
        private FireEventRequestTupleScheme() {
        }

        public void write(TProtocol prot, FireEventRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBool(struct.successful);
            struct.data.write((TProtocol)oprot);
            BitSet optionals = new BitSet();
            if (struct.isSetDbName()) {
                optionals.set(0);
            }
            if (struct.isSetTableName()) {
                optionals.set(1);
            }
            if (struct.isSetPartitionVals()) {
                optionals.set(2);
            }
            if (struct.isSetCatName()) {
                optionals.set(3);
            }
            if (struct.isSetTblParams()) {
                optionals.set(4);
            }
            if (struct.isSetBatchPartitionValsForRefresh()) {
                optionals.set(5);
            }
            oprot.writeBitSet(optionals, 6);
            if (struct.isSetDbName()) {
                oprot.writeString(struct.dbName);
            }
            if (struct.isSetTableName()) {
                oprot.writeString(struct.tableName);
            }
            if (struct.isSetPartitionVals()) {
                oprot.writeI32(struct.partitionVals.size());
                for (String string : struct.partitionVals) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetTblParams()) {
                oprot.writeI32(struct.tblParams.size());
                for (Map.Entry entry : struct.tblParams.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetBatchPartitionValsForRefresh()) {
                oprot.writeI32(struct.batchPartitionValsForRefresh.size());
                for (List list : struct.batchPartitionValsForRefresh) {
                    oprot.writeI32(list.size());
                    for (String _iter1094 : list) {
                        oprot.writeString(_iter1094);
                    }
                }
            }
        }

        public void read(TProtocol prot, FireEventRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.successful = iprot.readBool();
            struct.setSuccessfulIsSet(true);
            struct.data = new FireEventRequestData();
            struct.data.read((TProtocol)iprot);
            struct.setDataIsSet(true);
            BitSet incoming = iprot.readBitSet(6);
            if (incoming.get(0)) {
                struct.dbName = iprot.readString();
                struct.setDbNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list1095 = iprot.readListBegin((byte)11);
                struct.partitionVals = new ArrayList<String>(_list1095.size);
                for (int _i1097 = 0; _i1097 < _list1095.size; ++_i1097) {
                    String _elem1096 = iprot.readString();
                    struct.partitionVals.add(_elem1096);
                }
                struct.setPartitionValsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(4)) {
                TMap _map1098 = iprot.readMapBegin((byte)11, (byte)11);
                struct.tblParams = new HashMap<String, String>(2 * _map1098.size);
                for (int _i1101 = 0; _i1101 < _map1098.size; ++_i1101) {
                    String _key1099 = iprot.readString();
                    String _val1100 = iprot.readString();
                    struct.tblParams.put(_key1099, _val1100);
                }
                struct.setTblParamsIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list1102 = iprot.readListBegin((byte)15);
                struct.batchPartitionValsForRefresh = new ArrayList<List<String>>(_list1102.size);
                for (int _i1104 = 0; _i1104 < _list1102.size; ++_i1104) {
                    TList _list1105 = iprot.readListBegin((byte)11);
                    ArrayList<String> _elem1103 = new ArrayList<String>(_list1105.size);
                    for (int _i1107 = 0; _i1107 < _list1105.size; ++_i1107) {
                        String _elem1106 = iprot.readString();
                        _elem1103.add(_elem1106);
                    }
                    struct.batchPartitionValsForRefresh.add(_elem1103);
                }
                struct.setBatchPartitionValsForRefreshIsSet(true);
            }
        }
    }

    private static class FireEventRequestStandardScheme
    extends StandardScheme<FireEventRequest> {
        private FireEventRequestStandardScheme() {
        }

        public void read(TProtocol iprot, FireEventRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 2) {
                            struct.successful = iprot.readBool();
                            struct.setSuccessfulIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.data = new FireEventRequestData();
                            struct.data.read(iprot);
                            struct.setDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readString();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list1074 = iprot.readListBegin();
                            struct.partitionVals = new ArrayList<String>(_list1074.size);
                            for (int _i1076 = 0; _i1076 < _list1074.size; ++_i1076) {
                                String _elem1075 = iprot.readString();
                                struct.partitionVals.add(_elem1075);
                            }
                            iprot.readListEnd();
                            struct.setPartitionValsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 13) {
                            TMap _map1077 = iprot.readMapBegin();
                            struct.tblParams = new HashMap<String, String>(2 * _map1077.size);
                            for (int _i1080 = 0; _i1080 < _map1077.size; ++_i1080) {
                                String _key1078 = iprot.readString();
                                String _val1079 = iprot.readString();
                                struct.tblParams.put(_key1078, _val1079);
                            }
                            iprot.readMapEnd();
                            struct.setTblParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list1081 = iprot.readListBegin();
                            struct.batchPartitionValsForRefresh = new ArrayList<List<String>>(_list1081.size);
                            for (int _i1083 = 0; _i1083 < _list1081.size; ++_i1083) {
                                TList _list1084 = iprot.readListBegin();
                                ArrayList<String> _elem1082 = new ArrayList<String>(_list1084.size);
                                for (int _i1086 = 0; _i1086 < _list1084.size; ++_i1086) {
                                    String _elem1085 = iprot.readString();
                                    _elem1082.add(_elem1085);
                                }
                                iprot.readListEnd();
                                struct.batchPartitionValsForRefresh.add(_elem1082);
                            }
                            iprot.readListEnd();
                            struct.setBatchPartitionValsForRefreshIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, FireEventRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(SUCCESSFUL_FIELD_DESC);
            oprot.writeBool(struct.successful);
            oprot.writeFieldEnd();
            if (struct.data != null) {
                oprot.writeFieldBegin(DATA_FIELD_DESC);
                struct.data.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null && struct.isSetDbName()) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tableName != null && struct.isSetTableName()) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.partitionVals != null && struct.isSetPartitionVals()) {
                oprot.writeFieldBegin(PARTITION_VALS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.partitionVals.size()));
                for (String string : struct.partitionVals) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.tblParams != null && struct.isSetTblParams()) {
                oprot.writeFieldBegin(TBL_PARAMS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.tblParams.size()));
                for (Map.Entry entry : struct.tblParams.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.batchPartitionValsForRefresh != null && struct.isSetBatchPartitionValsForRefresh()) {
                oprot.writeFieldBegin(BATCH_PARTITION_VALS_FOR_REFRESH_FIELD_DESC);
                oprot.writeListBegin(new TList(15, struct.batchPartitionValsForRefresh.size()));
                for (List list : struct.batchPartitionValsForRefresh) {
                    oprot.writeListBegin(new TList(11, list.size()));
                    for (String _iter1090 : list) {
                        oprot.writeString(_iter1090);
                    }
                    oprot.writeListEnd();
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

