/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.util.ArrayDeque;
import java.util.Deque;

public class StackThreadLocal<T> {
    private final ThreadLocal<Deque<T>> threadLocal = new ThreadLocal();

    public void set(T value) {
        Deque<T> stack = this.threadLocal.get();
        if (stack == null) {
            stack = new ArrayDeque<T>();
        }
        stack.push(value);
        this.threadLocal.set(stack);
    }

    public void unset() {
        Deque<T> stack = this.threadLocal.get();
        stack.pop();
        if (stack.isEmpty()) {
            this.threadLocal.remove();
        }
    }

    public T get() {
        Deque<T> stack = this.threadLocal.get();
        if (stack != null) {
            return stack.peek();
        }
        throw new IllegalStateException("There is no context to return!");
    }

    public boolean isSet() {
        return this.threadLocal.get() != null;
    }
}

