/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.entities.OperationType;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class LatestTxnIdInConflictHandler
implements QueryHandler<Long> {
    private static final List<String> OPERATION_TYPES = ImmutableList.of((Object)OperationType.UPDATE.getSqlConst(), (Object)OperationType.DELETE.getSqlConst());
    private final long txnId;

    public LatestTxnIdInConflictHandler(long txnId) {
        this.txnId = txnId;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return " SELECT MAX(\"COMMITTED\".\"WS_TXNID\") FROM \"WRITE_SET\" \"COMMITTED\" INNER JOIN (   SELECT DISTINCT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_TXNID\"   FROM \"TXN_COMPONENTS\"   WHERE \"TC_TXNID\" = :txnId     AND \"TC_OPERATION_TYPE\" IN (:types) ) \"CUR\" ON \"COMMITTED\".\"WS_DATABASE\" = \"CUR\".\"TC_DATABASE\"   AND \"COMMITTED\".\"WS_TABLE\" = \"CUR\".\"TC_TABLE\"   AND (\"COMMITTED\".\"WS_PARTITION\" = \"CUR\".\"TC_PARTITION\" OR     \"CUR\".\"TC_PARTITION\" IS NULL)  WHERE \"CUR\".\"TC_TXNID\" <= \"COMMITTED\".\"WS_COMMIT_ID\"" + (TxnHandler.ConfVars.useMinHistoryLevel() ? "" : "   AND \"COMMITTED\".\"WS_OPERATION_TYPE\" != :wsType");
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("txnId", (Object)this.txnId).addValue("types", OPERATION_TYPES, 1).addValue("wsType", (Object)OperationType.INSERT.getSqlConst(), 1);
    }

    public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
        return rs.next() ? rs.getLong(1) : -1L;
    }
}

