/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetTargetTxnIdListForPolicyHandler
implements QueryHandler<List<Long>> {
    private final String replPolicy;
    private final List<Long> txnIds;

    public GetTargetTxnIdListForPolicyHandler(String replPolicy, List<Long> txnIds) {
        this.replPolicy = replPolicy;
        this.txnIds = txnIds;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE \"RTM_TARGET_TXN_ID\" IN (:txnIds) AND \"RTM_REPL_POLICY\" = :replPolicy";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("txnIds", this.txnIds, -5).addValue("replPolicy", (Object)this.replPolicy);
    }

    public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<Long> targetTxnIdList = new ArrayList<Long>();
        while (rs.next()) {
            targetTxnIdList.add(rs.getLong(1));
        }
        return targetTxnIdList;
    }
}

