/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.OpenTxnTimeoutLowBoundaryTxnIdHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MinOpenTxnIdWaterMarkFunction
implements TransactionalFunction<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(MinOpenTxnIdWaterMarkFunction.class);
    private final long openTxnTimeOutMillis;

    public MinOpenTxnIdWaterMarkFunction(long openTxnTimeOutMillis) {
        this.openTxnTimeOutMillis = openTxnTimeOutMillis;
    }

    @Override
    public Long execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        long minOpenTxn = Objects.requireNonNull((Long)jdbcResource.getJdbcTemplate().query("SELECT MIN(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STATE\"= :status", (SqlParameterSource)new MapSqlParameterSource().addValue("status", (Object)TxnStatus.OPEN.getSqlConst(), 1), rs -> {
            if (!rs.next()) {
                throw new IllegalStateException("Scalar query returned no rows?!?!!");
            }
            long id = rs.getLong(1);
            if (rs.wasNull()) {
                id = Long.MAX_VALUE;
            }
            return id;
        }));
        long lowWaterMark = jdbcResource.execute(new OpenTxnTimeoutLowBoundaryTxnIdHandler(this.openTxnTimeOutMillis));
        LOG.debug("MinOpenTxnIdWaterMark calculated with minOpenTxn {}, lowWaterMark {}", (Object)minOpenTxn, (Object)lowWaterMark);
        return Long.min(minOpenTxn, lowWaterMark + 1L);
    }
}

