/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.UpdateTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONUpdateTableColumnStatMessage
extends UpdateTableColumnStatMessage {
    @JsonProperty
    private Long writeId;
    @JsonProperty
    private Long timestamp;
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;
    @JsonProperty
    private String database;
    @JsonProperty
    private String colStatsJson;
    @JsonProperty
    Map<String, String> parameters;
    @JsonProperty
    private String tableObjJson;

    public JSONUpdateTableColumnStatMessage() {
    }

    public JSONUpdateTableColumnStatMessage(String server, String servicePrincipal, Long timestamp, ColumnStatistics colStats, Table tableObj, Map<String, String> parameters, long writeId) {
        this.timestamp = timestamp;
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.writeId = writeId;
        this.database = colStats.getStatsDesc().getDbName();
        try {
            this.colStatsJson = MessageBuilder.createTableColumnStatJson(colStats);
            this.tableObjJson = MessageBuilder.createTableObjJson(tableObj);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize JSONUpdateTableColumnStatMessage : ", e);
        }
        this.parameters = parameters;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getDB() {
        return this.database;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public ColumnStatistics getColumnStatistics() {
        try {
            return (ColumnStatistics)MessageBuilder.getTObj(this.colStatsJson, ColumnStatistics.class);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get the ColumnStatistics object ", e);
        }
    }

    @Override
    public Table getTableObject() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Long getWriteId() {
        return this.writeId;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

