/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ReloadEvent
extends ListenerEvent {
    private final Table tableObj;
    private final Partition ptnObj;
    private final List<Partition> ptns;
    private final boolean refreshEvent;

    public ReloadEvent(String catName, String db, String table, List<List<String>> partVals, boolean status, boolean refreshEvent, Map<String, String> tblParams, IHMSHandler handler) throws MetaException, NoSuchObjectException {
        super(status, handler);
        GetTableRequest req = new GetTableRequest(db, table);
        req.setCatName(catName);
        req.setCapabilities(new ClientCapabilities((List)Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.TEST_CAPABILITY, ClientCapability.INSERT_ONLY_TABLES})));
        try {
            this.tableObj = handler.get_table_req(req).getTable();
            if (tblParams != null) {
                this.tableObj.getParameters().putAll(tblParams);
            }
            if (partVals != null) {
                if (partVals.size() == 1) {
                    this.ptnObj = handler.get_partition(MetaStoreUtils.prependNotNullCatToDbName((String)catName, (String)db), table, partVals.get(0));
                    this.ptns = null;
                } else {
                    this.ptnObj = null;
                    this.ptns = new ArrayList<Partition>();
                    ArrayList<String> part_names = new ArrayList<String>();
                    for (List<String> partVal : partVals) {
                        part_names.add(Warehouse.makePartName((List)this.tableObj.getPartitionKeys(), partVal));
                    }
                    GetPartitionsByNamesRequest partitionsReq = new GetPartitionsByNamesRequest(MetaStoreUtils.prependNotNullCatToDbName((String)catName, (String)db), table);
                    partitionsReq.setNames(part_names);
                    partitionsReq.setGet_col_stats(false);
                    this.ptns.addAll(handler.get_partitions_by_names_req(partitionsReq).getPartitions());
                }
            } else {
                this.ptnObj = null;
                this.ptns = null;
            }
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw MetaStoreUtils.newMetaException((Exception)((Object)e));
        }
        this.refreshEvent = refreshEvent;
    }

    public Table getTableObj() {
        return this.tableObj;
    }

    public Partition getPartitionObj() {
        return this.ptnObj;
    }

    public List<Partition> getPartitions() {
        return this.ptns;
    }

    public boolean isRefreshEvent() {
        return this.refreshEvent;
    }
}

