/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleColumnStatsMerger
extends ColumnStatsMerger<Double> {
    private static final Logger LOG = LoggerFactory.getLogger(DoubleColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Double highValue;
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        DoubleColumnStatsDataInspector aggregateData = ColumnsStatsUtils.doubleInspectorFromStats(aggregateColStats);
        DoubleColumnStatsDataInspector newData = ColumnsStatsUtils.doubleInspectorFromStats(newColStats);
        Double lowValue = this.mergeLowValue(this.getLowValue(aggregateData), this.getLowValue(newData));
        if (lowValue != null) {
            aggregateData.setLowValue(lowValue);
        }
        if ((highValue = this.mergeHighValue(this.getHighValue(aggregateData), this.getHighValue(newData))) != null) {
            aggregateData.setHighValue(highValue);
        }
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
        NumDistinctValueEstimator oldNDVEst = aggregateData.getNdvEstimator();
        NumDistinctValueEstimator newNDVEst = newData.getNdvEstimator();
        List<NumDistinctValueEstimator> ndvEstimatorsList = Arrays.asList(oldNDVEst, newNDVEst);
        aggregateData.setNumDVs(this.mergeNumDistinctValueEstimator(aggregateColStats.getColName(), ndvEstimatorsList, aggregateData.getNumDVs(), newData.getNumDVs()));
        aggregateData.setNdvEstimator(ndvEstimatorsList.get(0));
        KllHistogramEstimator oldKllEst = aggregateData.getHistogramEstimator();
        KllHistogramEstimator newKllEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), oldKllEst, newKllEst));
        aggregateColStats.getStatsData().setDoubleStats((DoubleColumnStatsData)aggregateData);
    }

    public Double getLowValue(DoubleColumnStatsDataInspector data) {
        return data.isSetLowValue() ? Double.valueOf(data.getLowValue()) : null;
    }

    public Double getHighValue(DoubleColumnStatsDataInspector data) {
        return data.isSetHighValue() ? Double.valueOf(data.getHighValue()) : null;
    }

    @Override
    public Double mergeLowValue(Double oldValue, Double newValue) {
        if (oldValue != null && newValue != null) {
            return Math.min(oldValue, newValue);
        }
        if (oldValue != null) {
            return oldValue;
        }
        return newValue;
    }

    @Override
    public Double mergeHighValue(Double oldValue, Double newValue) {
        if (oldValue != null && newValue != null) {
            return Math.max(oldValue, newValue);
        }
        if (oldValue != null) {
            return oldValue;
        }
        return newValue;
    }
}

