/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileMetadataManager.class);
    private final RawStore tlms;
    private final ExecutorService threadPool;
    private final Configuration conf;

    public FileMetadataManager(RawStore tlms, Configuration conf) {
        this.tlms = tlms;
        this.conf = conf;
        int numThreads = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILE_METADATA_THREADS);
        this.threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("File-Metadata-%d").setDaemon(true).build());
    }

    public void queueCacheMetadata(String location, FileMetadataExprType type) {
        this.threadPool.submit(new CacheUpdateRequest(type, location));
    }

    private void cacheMetadata(FileMetadataExprType type, String location) throws MetaException, IOException, InterruptedException {
        ArrayList files;
        Path path = new Path(location);
        FileSystem fs = path.getFileSystem(this.conf);
        if (!fs.isDirectory(path)) {
            files = Lists.newArrayList((Object[])new Path[]{path});
        } else {
            files = new ArrayList();
            RemoteIterator iter = fs.listFiles(path, true);
            while (iter.hasNext()) {
                LocatedFileStatus lfs = (LocatedFileStatus)iter.next();
                if (lfs.isDirectory()) continue;
                files.add(lfs.getPath());
            }
        }
        for (Path file : files) {
            long fileId;
            if (!(fs instanceof DistributedFileSystem)) {
                return;
            }
            try {
                fileId = HdfsUtils.getFileId((FileSystem)fs, (String)Path.getPathWithoutSchemeAndAuthority((Path)file).toString());
            }
            catch (UnsupportedOperationException ex) {
                LOG.error("Cannot cache file metadata for " + location + "; " + fs.getClass().getCanonicalName() + " does not support fileId");
                return;
            }
            LOG.info("Caching file metadata for " + String.valueOf(file) + " (file ID " + fileId + ")");
            file = HdfsUtils.getFileIdPath((FileSystem)fs, (Path)file, (long)fileId);
            this.tlms.getFileMetadataHandler(type).cacheFileMetadata(fileId, fs, file);
        }
    }

    private final class CacheUpdateRequest
    implements Callable<Void> {
        FileMetadataExprType type;
        String location;

        public CacheUpdateRequest(FileMetadataExprType type, String location) {
            this.type = type;
            this.location = location;
        }

        @Override
        public Void call() throws Exception {
            try {
                FileMetadataManager.this.cacheMetadata(this.type, this.location);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                LOG.error("Failed to cache file metadata in background for " + String.valueOf(this.type) + ", " + this.location, (Throwable)ex);
            }
            return null;
        }
    }
}

