/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.objects;

import org.apache.hive.hplsql.File;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.objects.HplClass;
import org.apache.hive.hplsql.objects.MethodDictionary;
import org.apache.hive.hplsql.objects.MethodParams;
import org.apache.hive.hplsql.objects.UtlFile;

public class UtlFileClass
implements HplClass {
    public static final UtlFileClass INSTANCE = new UtlFileClass();
    private final MethodDictionary<UtlFile> methodDictionary = new MethodDictionary();

    private UtlFileClass() {
        this.methodDictionary.put("fopen", (self, args) -> {
            MethodParams params = new MethodParams("fopen", args, MethodParams.Arity.min(2));
            String dir = params.stringAt(0);
            String name = params.stringAt(1);
            boolean write = true;
            boolean overwrite = false;
            if (args.size() > 2) {
                String mode = params.stringAt(2);
                if (mode.equalsIgnoreCase("r")) {
                    write = false;
                } else if (mode.equalsIgnoreCase("w")) {
                    write = true;
                    overwrite = true;
                }
            }
            File file = self.fileOpen(dir, name, write, overwrite);
            return new Var(Var.Type.FILE, file);
        });
        this.methodDictionary.put("get_line", (self, args) -> {
            MethodParams params = new MethodParams("get_line", args, MethodParams.Arity.UNARY);
            return new Var(self.getLine(params.fileAt(0)));
        });
        this.methodDictionary.put("put_line", (self, args) -> {
            MethodParams params = new MethodParams("put_line", args, MethodParams.Arity.BINARY);
            self.put(params.fileAt(0), params.stringAt(1), true);
            return null;
        });
        this.methodDictionary.put("put", (self, args) -> {
            MethodParams params = new MethodParams("put", args, MethodParams.Arity.BINARY);
            self.put(params.fileAt(0), params.stringAt(1), false);
            return null;
        });
        this.methodDictionary.put("fclose", (self, args) -> {
            File file = new MethodParams("fclose", args, MethodParams.Arity.UNARY).fileAt(0);
            self.fileClose(file);
            return null;
        });
    }

    @Override
    public UtlFile newInstance() {
        return new UtlFile(this);
    }

    @Override
    public MethodDictionary methodDictionary() {
        return this.methodDictionary;
    }
}

