/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Arguments {
    private CommandLine commandLine;
    private Options options = new Options();
    String execString;
    String fileName;
    String main;
    Map<String, String> vars = new HashMap<String, String>();

    public static Arguments script(String str) {
        Arguments arguments = new Arguments();
        arguments.parse(new String[]{"-e", str});
        return arguments;
    }

    public Arguments() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"quoted-query-string");
        OptionBuilder.withDescription((String)"HPL/SQL from command line");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"HPL/SQL from a file");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"procname");
        OptionBuilder.withDescription((String)"Entry point (procedure or function name)");
        this.options.addOption(OptionBuilder.create((String)"main"));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Value for given property");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.withDescription((String)"Variable substitution e.g. -d A=B or --define A=B");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withLongOpt((String)"hivevar");
        OptionBuilder.withDescription((String)"Variable substitution e.g. --hivevar A=B");
        this.options.addOption(OptionBuilder.create());
        this.options.addOption(new Option("version", "version", false, "Print HPL/SQL version"));
        this.options.addOption(new Option("trace", "trace", false, "Print debug information"));
        this.options.addOption(new Option("offline", "offline", false, "Offline mode - skip SQL execution"));
        this.options.addOption(new Option("H", "help", false, "Print help information"));
    }

    public boolean parse(String[] args) {
        try {
            this.commandLine = new GnuParser().parse(this.options, args);
            this.execString = this.commandLine.getOptionValue('e');
            this.fileName = this.commandLine.getOptionValue('f');
            this.main = this.commandLine.getOptionValue("main");
            Properties p = this.commandLine.getOptionProperties("hiveconf");
            for (String key : p.stringPropertyNames()) {
                this.vars.put(key, p.getProperty(key));
            }
            p = this.commandLine.getOptionProperties("hivevar");
            for (String key : p.stringPropertyNames()) {
                this.vars.put(key, p.getProperty(key));
            }
            p = this.commandLine.getOptionProperties("define");
            for (String key : p.stringPropertyNames()) {
                this.vars.put(key, p.getProperty(key));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    public String getExecString() {
        return this.execString;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMain() {
        return this.main;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public boolean hasVersionOption() {
        return this.commandLine.hasOption("version");
    }

    public boolean hasTraceOption() {
        return this.commandLine.hasOption("trace");
    }

    public boolean hasOfflineOption() {
        return this.commandLine.hasOption("offline");
    }

    public boolean hasHelpOption() {
        return this.commandLine.hasOption('H');
    }

    public void printHelp() {
        new HelpFormatter().printHelp("hplsql", this.options);
    }
}

