/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.mapreduce.lib.impl.OutputConfigurator;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.fate.Fate;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloStorageHandler;
import org.apache.hadoop.hive.ql.metadata.JarUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAccumuloHelper {
    private static final Logger log = LoggerFactory.getLogger(HiveAccumuloHelper.class);
    public static final Text ACCUMULO_SERVICE = new Text("ACCUMULO_AUTH_TOKEN");

    public void addTokenFromUserToJobConf(UserGroupInformation user, JobConf jobConf) throws IOException {
        Preconditions.checkNotNull((Object)user, (Object)"Provided UGI was null");
        Preconditions.checkNotNull((Object)jobConf, (Object)"JobConf was null");
        Token<?> accumuloToken = this.getAccumuloToken(user);
        if (null == accumuloToken) {
            log.error("Could not find accumulo token in user: " + String.valueOf(user.getTokens()));
            throw new IOException("Could not find Accumulo Token in user's tokens");
        }
        this.mergeTokenIntoJobConf(jobConf, accumuloToken);
    }

    public Token<?> getAccumuloToken(UserGroupInformation user) {
        Preconditions.checkNotNull((Object)user, (Object)"Provided UGI was null");
        Collection tokens = user.getTokens();
        for (Token token : tokens) {
            if (!ACCUMULO_SERVICE.equals((Object)token.getKind())) continue;
            return token;
        }
        return null;
    }

    public void mergeTokenIntoJobConf(JobConf jobConf, Token<?> accumuloToken) throws IOException {
        JobConf accumuloJobConf = new JobConf((Configuration)jobConf);
        accumuloJobConf.getCredentials().addToken(accumuloToken.getService(), accumuloToken);
        ShimLoader.getHadoopShims().mergeCredentials(jobConf, accumuloJobConf);
    }

    public AuthenticationToken getDelegationToken(Connector conn) throws IOException {
        try {
            DelegationTokenConfig config = new DelegationTokenConfig();
            return conn.securityOperations().getDelegationToken(config);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IOException("Failed to obtain DelegationToken", e);
        }
    }

    public Token<? extends TokenIdentifier> getHadoopToken(AuthenticationToken token) throws IOException {
        if (!(token instanceof DelegationTokenImpl)) {
            throw new IOException("Expected a DelegationTokenImpl but found " + String.valueOf(token != null ? token.getClass() : "null"));
        }
        DelegationTokenImpl dt = (DelegationTokenImpl)token;
        try {
            AuthenticationTokenIdentifier identifier = dt.getIdentifier();
            return new Token(identifier.getBytes(), dt.getPassword(), identifier.getKind(), dt.getServiceName());
        }
        catch (Exception e) {
            throw new IOException("Failed to create Hadoop token from Accumulo DelegationToken", e);
        }
    }

    public ClientConfiguration getClientConfiguration(String zookeepers, String instanceName, boolean useSasl) {
        return ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zookeepers).withSasl(useSasl);
    }

    public void updateInputFormatConfWithAccumuloToken(JobConf jobConf, UserGroupInformation currentUser, AccumuloConnectionParameters cnxnParams) throws IOException {
        this.updateConfWithAccumuloToken(jobConf, currentUser, cnxnParams, true);
    }

    public void updateOutputFormatConfWithAccumuloToken(JobConf jobConf, UserGroupInformation currentUser, AccumuloConnectionParameters cnxnParams) throws IOException {
        this.updateConfWithAccumuloToken(jobConf, currentUser, cnxnParams, false);
    }

    void updateConfWithAccumuloToken(JobConf jobConf, UserGroupInformation currentUser, AccumuloConnectionParameters cnxnParams, boolean isInputFormat) throws IOException {
        if (this.getAccumuloToken(currentUser) != null) {
            this.addTokenFromUserToJobConf(currentUser, jobConf);
        } else {
            try {
                Connector connector = cnxnParams.getConnector();
                AuthenticationToken token = this.getDelegationToken(connector);
                if (isInputFormat) {
                    this.setInputFormatConnectorInfo(jobConf, cnxnParams.getAccumuloUserName(), token);
                } else {
                    this.setOutputFormatConnectorInfo(jobConf, cnxnParams.getAccumuloUserName(), token);
                }
                Token<? extends TokenIdentifier> accumuloToken = this.getHadoopToken(token);
                this.mergeTokenIntoJobConf(jobConf, accumuloToken);
                if (!currentUser.addToken(accumuloToken)) {
                    throw new IOException("Failed to add Accumulo Token to UGI");
                }
                try {
                    this.addTokenFromUserToJobConf(currentUser, jobConf);
                }
                catch (IOException e) {
                    throw new IOException("Current user did not contain necessary delegation Tokens " + String.valueOf(currentUser), e);
                }
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new IOException("Failed to acquire Accumulo DelegationToken", e);
            }
        }
    }

    public boolean hasKerberosCredentials(UserGroupInformation ugi) {
        return ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.KERBEROS;
    }

    public void setInputFormatConnectorInfo(JobConf conf, String username, AuthenticationToken token) throws AccumuloSecurityException {
        try {
            AccumuloInputFormat.setConnectorInfo((JobConf)conf, (String)username, (AuthenticationToken)token);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring exception setting Accumulo Connector instance for user " + username, (Throwable)e);
        }
    }

    public void setOutputFormatConnectorInfo(JobConf conf, String username, AuthenticationToken token) throws AccumuloSecurityException {
        try {
            AccumuloOutputFormat.setConnectorInfo((JobConf)conf, (String)username, (AuthenticationToken)token);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring exception setting Accumulo Connector instance for user " + username, (Throwable)e);
        }
    }

    public void setInputFormatZooKeeperInstance(JobConf conf, String instanceName, String zookeepers, boolean isSasl) throws IOException {
        try {
            ClientConfiguration clientConf = this.getClientConfiguration(zookeepers, instanceName, isSasl);
            AccumuloInputFormat.setZooKeeperInstance((JobConf)conf, (ClientConfiguration)clientConf);
        }
        catch (IllegalStateException ise) {
            log.debug("Ignoring exception setting ZooKeeper instance of " + instanceName + " at " + zookeepers, (Throwable)ise);
        }
    }

    public void setOutputFormatZooKeeperInstance(JobConf conf, String instanceName, String zookeepers, boolean isSasl) throws IOException {
        try {
            ClientConfiguration clientConf = this.getClientConfiguration(zookeepers, instanceName, isSasl);
            AccumuloOutputFormat.setZooKeeperInstance((JobConf)conf, (ClientConfiguration)clientConf);
        }
        catch (IllegalStateException ise) {
            log.debug("Ignoring exception setting ZooKeeper instance of " + instanceName + " at " + zookeepers, (Throwable)ise);
        }
    }

    public void setInputFormatMockInstance(JobConf conf, String instanceName) {
        try {
            AccumuloInputFormat.setMockInstance((JobConf)conf, (String)instanceName);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring exception setting mock instance of " + instanceName, (Throwable)e);
        }
    }

    public void setOutputFormatMockInstance(JobConf conf, String instanceName) {
        try {
            AccumuloOutputFormat.setMockInstance((JobConf)conf, (String)instanceName);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring exception setting mock instance of " + instanceName, (Throwable)e);
        }
    }

    public void loadDependentJars(Configuration conf) {
        ArrayList<Class> classesToLoad = new ArrayList<Class>(Arrays.asList(Tracer.class, Fate.class, Connector.class, Main.class, ZooKeeper.class, AccumuloStorageHandler.class));
        try {
            classesToLoad.add(Class.forName("org.apache.htrace.Trace"));
        }
        catch (Exception e) {
            log.warn("Failed to load class for HTrace jar, trying to continue", (Throwable)e);
        }
        try {
            JarUtils.addDependencyJars((Configuration)conf, classesToLoad);
        }
        catch (IOException e) {
            log.error("Could not add necessary Accumulo dependencies to classpath", (Throwable)e);
        }
    }

    public Token<? extends TokenIdentifier> setConnectorInfoForInputAndOutput(AccumuloConnectionParameters params, Connector conn, Configuration conf) throws Exception {
        AuthenticationToken token = this.getDelegationToken(conn);
        try {
            InputConfigurator.setConnectorInfo(AccumuloInputFormat.class, (Configuration)conf, (String)params.getAccumuloUserName(), (AuthenticationToken)token);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring IllegalArgumentException about re-setting connector information");
        }
        try {
            OutputConfigurator.setConnectorInfo(AccumuloOutputFormat.class, (Configuration)conf, (String)params.getAccumuloUserName(), (AuthenticationToken)token);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring IllegalArgumentException about re-setting connector information");
        }
        return this.getHadoopToken(token);
    }
}

